/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.schema.property;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.model.schema.property.ParentProp;

public class Prop {
    private String key;
    private final ParentProp parentProp;
    private final String nameSpace;

    public Prop(ParentProp parentProp, String key) {
        Objects.requireNonNull(key, "key cannot be null");
        if (parentProp != null) {
            this.nameSpace = parentProp.getNameSpace();
            this.parentProp = parentProp;
        } else {
            this.nameSpace = null;
            this.parentProp = null;
        }
        this.key = key;
    }

    public Prop(String nameSpace, String key) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(nameSpace, "nameSpace cannot be null");
        this.nameSpace = nameSpace;
        this.key = key;
        this.parentProp = ParentProp.undefined;
    }

    public String toString() {
        return this.key;
    }

    public String toFullName() {
        return this.parentProp != ParentProp.undefined ? String.join((CharSequence)".", this.parentProp.toFullName(), this.toString()) : this.toString();
    }

    public String toTypeName() {
        LinkedList<String> toJoin = new LinkedList<String>();
        if (!StringUtils.isEmpty((CharSequence)this.nameSpace)) {
            toJoin.add(this.nameSpace);
        }
        if (this.parentProp != ParentProp.undefined) {
            toJoin.add(this.parentProp.toFullName());
        }
        if (!StringUtils.isEmpty((CharSequence)this.key)) {
            toJoin.add(this.key);
        }
        return String.join((CharSequence)".", toJoin);
    }

    public static String toSelectFieldStr(Prop ... props) {
        if (props.length == 0) {
            return "id";
        }
        return Arrays.stream(props).map(Prop::toFullName).collect(Collectors.joining(", "));
    }

    public QFilter toFilter(String cp, Object value) {
        return new QFilter(this.toFullName(), cp, value);
    }

    public QFilter toFilter(Object value) {
        return this.toFilter("=", value);
    }

    public Long longOf(DynamicObject entityDyo) {
        return entityDyo.getLong(this.toFullName());
    }

    public String stringOf(DynamicObject entityDyo) {
        return entityDyo.getString(this.toFullName());
    }

    public Long longOf(Row entityDyo) {
        return entityDyo.getLong(this.toFullName());
    }

    public String stringOf(Row entityDyo) {
        return entityDyo.getString(this.toFullName());
    }

    public Integer integerOf(Row entityDyo) {
        return entityDyo.getInteger(this.toFullName());
    }

    public Boolean booleanOf(Row entityDyo) {
        return entityDyo.getBoolean(this.toFullName());
    }

    public BigDecimal decimalOf(Row entityDyo) {
        return entityDyo.getBigDecimal(this.toFullName());
    }

    protected String getNameSpace() {
        return this.nameSpace;
    }

    public void overrideKey(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prop prop = (Prop)o;
        return this.key.equals(prop.key) && this.parentProp.equals(prop.parentProp) && this.nameSpace.equals(prop.nameSpace);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.parentProp, this.nameSpace);
    }
}

