/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.rate;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.rate.RateType;

public class IndirectRateConfigs {
    private boolean enableIndirectRateConversion;
    private Table<Long, Long, TreeMap<Date, RateType>> configTable;

    public static IndirectRateConfigs empty() {
        IndirectRateConfigs configs = new IndirectRateConfigs();
        configs.setEnableIndirectRateConversion(false);
        return configs;
    }

    public boolean isEnableIndirectRateConversion() {
        return this.enableIndirectRateConversion;
    }

    public void setEnableIndirectRateConversion(boolean enableIndirectRateConversion) {
        this.enableIndirectRateConversion = enableIndirectRateConversion;
    }

    public Table<Long, Long, TreeMap<Date, RateType>> getConfigTable() {
        return this.configTable;
    }

    public void setConfigTable(Table<Long, Long, TreeMap<Date, RateType>> configTable) {
        this.configTable = configTable;
    }

    public Optional<RateType> findRateTypeConfig(Long originalCurrencyId, Long targetCurrencyId, Date effectDate) {
        Map.Entry floorEntry;
        if (originalCurrencyId == null || targetCurrencyId == null || this.getConfigTable() == null || this.getConfigTable().isEmpty() || !this.isEnableIndirectRateConversion()) {
            return Optional.empty();
        }
        TreeMap configs = (TreeMap)this.getConfigTable().get((Object)originalCurrencyId, (Object)targetCurrencyId);
        Optional<Object> config = configs == null || configs.isEmpty() ? Optional.empty() : (effectDate != null ? ((floorEntry = configs.floorEntry(effectDate)) == null ? Optional.empty() : Optional.of(floorEntry.getValue())) : Optional.of(configs.lastEntry().getValue()));
        if (!config.isPresent() && originalCurrencyId > 0L && targetCurrencyId > 0L && !(config = this.findRateTypeConfig(originalCurrencyId, 0L, effectDate)).isPresent()) {
            config = this.findRateTypeConfig(0L, targetCurrencyId, effectDate);
        }
        return config;
    }

    public Map<Long, RateType> batchFindIndirectRateConfig(Collection<Long> originalCurrencyIds, Long targetCurrencyId, Date effectDate) {
        if (!this.isEnableIndirectRateConversion() || CollectionUtils.isEmpty(originalCurrencyIds)) {
            return Collections.emptyMap();
        }
        return originalCurrencyIds.stream().collect(Collectors.toMap(x -> x, x -> this.findRateTypeConfig((Long)x, targetCurrencyId, effectDate).orElse(RateType.DIRECT_RATE)));
    }
}

