/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.balance;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherOrderbyEnhancer;
import kd.fi.bd.service.balance.VoucherQueryUtils;

public class OrderEnhanceParam {
    private final QFilter[] filters;
    private final String orderBy;
    private final boolean existsEntrySelect;
    private VoucherOrderbyEnhancer.OrderEnhancerEnum[] forceEnhancers;

    public OrderEnhanceParam(QFilter[] filters, String orderBy, boolean existsEntrySelect) {
        this.filters = filters;
        this.orderBy = orderBy;
        this.existsEntrySelect = existsEntrySelect;
    }

    public QFilter[] getFilters() {
        return this.filters;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public boolean isExistsEntrySelect() {
        return this.existsEntrySelect;
    }

    public boolean isDefaultOrder() {
        return "id desc".equals(this.orderBy) || "id desc,entries.seq".equals(this.orderBy);
    }

    public boolean isVoucherDefaultFilter() {
        return VoucherQueryUtils.getFilterMatchOrNestsAnyMatchFilterList(Arrays.asList(this.filters), x -> !x.getProperty().startsWith("entries") && !x.getProperty().startsWith("org") && !x.getProperty().startsWith("booktype") && !x.getProperty().startsWith("period") && !x.getProperty().startsWith("bookeddate")).isEmpty();
    }

    public boolean hasBookDateFilter() {
        List<QFilter> dtFilters = VoucherQueryUtils.getFilterMatchOrNestsAnyMatchFilterList(Arrays.asList(this.getFilters()), x -> x.getProperty().startsWith("bookeddate"));
        return !dtFilters.isEmpty();
    }

    public Set<Object> getOrgIdFromFilters() {
        List<QFilter> orgFilters = VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList(Arrays.asList(this.filters), x -> !(!x.getNests(false).isEmpty() || !"org".equals(x.getProperty()) && !"org.id".equals(x.getProperty()) || !"in".equalsIgnoreCase(x.getCP()) && !"=".equalsIgnoreCase(x.getCP())));
        if (orgFilters.isEmpty()) {
            return Collections.emptySet();
        }
        return orgFilters.stream().flatMap(x -> VoucherQueryUtils.convertFilterValue(x.getValue()).stream()).collect(Collectors.toSet());
    }

    public Set<Object> getPeriodIdFromFilters() {
        List<QFilter> periodFilters = VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList(Arrays.asList(this.filters), x -> !(!x.getNests(false).isEmpty() || !"period".equals(x.getProperty()) && !"period.id".equals(x.getProperty()) || !"in".equalsIgnoreCase(x.getCP()) && !"=".equalsIgnoreCase(x.getCP())));
        if (periodFilters.isEmpty()) {
            return Collections.emptySet();
        }
        return periodFilters.stream().flatMap(x -> VoucherQueryUtils.convertFilterValue(x.getValue()).stream()).collect(Collectors.toSet());
    }

    public String toString() {
        return "OrderEnhanceParam{filters=" + VoucherQueryUtils.formatFilterAsString(Arrays.stream(this.filters)) + ", orderBy='" + this.orderBy + '\'' + ", existsEntrySelect=" + this.existsEntrySelect + '}';
    }

    public VoucherOrderbyEnhancer.OrderEnhancerEnum[] getForceEnhancers() {
        return this.forceEnhancers;
    }

    public void setForceEnhancers(VoucherOrderbyEnhancer.OrderEnhancerEnum[] forceEnhancers) {
        this.forceEnhancers = forceEnhancers;
    }
}

