/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.balance;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.enums.CodeRuleEntryTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.service.balance.OrderEnhanceParam;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.FibdApp;

public class VoucherOrderbyEnhancer {
    private static final Log LOGGER = ExtLogFactory.getLog(VoucherOrderbyEnhancer.class);

    public static boolean isEnhanceOrderEnable() {
        boolean isEnhanceOrderEnable = BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.gl.voucher.query.enhanceorder.enable", false);
        LOGGER.info("voucher_order_enhance enable:" + isEnhanceOrderEnable);
        return isEnhanceOrderEnable;
    }

    public static boolean isForceNumberOrder() {
        boolean isEnhanceOrderEnable = BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.gl.voucher.query.forceNumberOrder.enable", false);
        LOGGER.info("voucher_order_force_number enable:" + isEnhanceOrderEnable);
        return isEnhanceOrderEnable;
    }

    public static String enhanceOrderby(OrderEnhanceParam enhanceParam) {
        LOGGER.info("voucher_order_enhance original:{}" + enhanceParam.getOrderBy(), (Object)enhanceParam);
        String order = VoucherOrderbyEnhancer.getOrderEnhancer(enhanceParam).getEnhancer().apply(enhanceParam);
        LOGGER.info("voucher_order_enhance final:" + order);
        return order;
    }

    private static OrderEnhancerEnum getOrderEnhancer(OrderEnhanceParam enhanceParam) {
        OrderEnhancerEnum[] values;
        OrderEnhancerEnum[] forceEnhancers = enhanceParam.getForceEnhancers();
        if (forceEnhancers != null && forceEnhancers.length > 0) {
            for (OrderEnhancerEnum enhancer : forceEnhancers) {
                if (!enhancer.getMatcher().test(enhanceParam)) continue;
                return enhancer;
            }
            LOGGER.error(ResManager.loadKDString((String)"\u51ed\u8bc1\u67e5\u8be2\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6392\u5e8f\u4f18\u5316\u5668", (String)"VoucherOrderbyEnahancer_0", (String)FibdApp.instance.commonModule(), (Object[])new Object[0]));
            return OrderEnhancerEnum.PERIOD_ORDER;
        }
        if (!VoucherOrderbyEnhancer.isEnhanceOrderEnable() && !enhanceParam.isDefaultOrder()) {
            return OrderEnhancerEnum.DEFAULT;
        }
        for (OrderEnhancerEnum enhancer : values = OrderEnhancerEnum.values()) {
            if (!enhancer.isForceEnhance() || !enhancer.getMatcher().test(enhanceParam)) continue;
            return enhancer;
        }
        LOGGER.error(ResManager.loadKDString((String)"\u51ed\u8bc1\u67e5\u8be2\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6392\u5e8f\u4f18\u5316\u5668", (String)"VoucherOrderbyEnahancer_0", (String)FibdApp.instance.commonModule(), (Object[])new Object[0]));
        return OrderEnhancerEnum.PERIOD_ORDER;
    }

    private static boolean isVoucherCodeWithOrgAndPeriod() {
        return (Boolean)ThreadCache.get((Object)(VoucherOrderbyEnhancer.class.getName() + "#isVoucherCodeWithOrgAndPeriod"), () -> {
            DynamicObject tempVoucher = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
            tempVoucher.set("billstatus", (Object)"B");
            CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"gl_voucher", (DynamicObject)tempVoucher, null);
            if (codeRule == null) {
                return false;
            }
            Set codeEntries = codeRule.getRuleEntry().stream().filter(x -> !(!x.getVisable() || !CodeRuleEntryTypeEnum.TYPE_DATE_FIELD.getTypeStr().equals(x.getAttributeType()) && !CodeRuleEntryTypeEnum.TYPE_ITEM_FIELD.getTypeStr().equals(x.getAttributeType()) || !x.getValueAtribute().startsWith("org") && !x.getValueAtribute().startsWith("period") && !x.getValueAtribute().startsWith("bookeddate"))).map(CodeRuleEntryInfo::getValueAtribute).collect(Collectors.toSet());
            return codeEntries.stream().anyMatch(x -> x.startsWith("org")) && codeEntries.stream().anyMatch(x -> x.startsWith("period") || x.startsWith("bookeddate"));
        });
    }

    public static enum OrderEnhancerEnum {
        DEFAULT(0, p -> {
            String order;
            String orderBy = p.getOrderBy();
            if (StringUtils.isEmpty((String)orderBy)) {
                return orderBy;
            }
            List orderByList = Arrays.stream(orderBy.toLowerCase().replace(".name", "").replace(".number", "").split(",")).collect(Collectors.toList());
            orderByList.removeIf(x -> x.startsWith("id ") || "id".equals(x));
            orderByList.removeIf(x -> x.startsWith("entries.seq"));
            int index = 0;
            Iterator iterator = orderByList.iterator();
            while (iterator.hasNext() && !(order = (String)iterator.next()).startsWith("entries.")) {
                ++index;
            }
            if (index < orderByList.size()) {
                orderByList.add(index, "id desc");
            } else {
                orderByList.add("id desc");
                if (p.isExistsEntrySelect()) {
                    orderByList.add("entries.seq asc");
                }
            }
            return String.join((CharSequence)",", orderByList);
        }, p -> !VoucherOrderbyEnhancer.isEnhanceOrderEnable() && !p.isDefaultOrder(), false),
        NUMBER_ORDER(2, p -> p.isExistsEntrySelect() ? "billno desc,id desc,entries.seq" : "billno desc,id desc", p -> {
            if (p.isVoucherDefaultFilter()) {
                return false;
            }
            if (VoucherOrderbyEnhancer.isForceNumberOrder()) {
                return true;
            }
            Set<Object> orgIds = p.getOrgIdFromFilters();
            Set<Object> periodIds = p.getPeriodIdFromFilters();
            if (orgIds.size() == 1 && periodIds.size() == 1) {
                return true;
            }
            return VoucherOrderbyEnhancer.isVoucherCodeWithOrgAndPeriod();
        }, true),
        BOOKEDDATE_ORDER(3, p -> p.isExistsEntrySelect() ? "org desc,bookeddate desc,billno desc,id desc,entries.seq" : "org desc,bookeddate desc,billno desc,id desc", OrderEnhanceParam::hasBookDateFilter, true),
        PERIOD_ORDER(4, p -> p.isExistsEntrySelect() ? "org desc,period desc,billno desc,id desc,entries.seq" : "org desc,period desc,billno desc,id desc", p -> !p.hasBookDateFilter(), true);

        private final Integer code;
        private final Function<OrderEnhanceParam, String> enhancer;
        private final Predicate<OrderEnhanceParam> matcher;
        private final boolean forceEnhance;

        private OrderEnhancerEnum(Integer code, Function<OrderEnhanceParam, String> enhancer, Predicate<OrderEnhanceParam> matcher, boolean forceEnhance) {
            this.code = code;
            this.enhancer = enhancer;
            this.matcher = matcher;
            this.forceEnhance = forceEnhance;
        }

        public Integer getCode() {
            return this.code;
        }

        public Function<OrderEnhanceParam, String> getEnhancer() {
            return this.enhancer;
        }

        public Predicate<OrderEnhanceParam> getMatcher() {
            return this.matcher;
        }

        public boolean isForceEnhance() {
            return this.forceEnhance;
        }
    }
}

