/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.balance.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.util.TreeNodeRelationFactory;

public class AccountTreeModel
implements IAccountTreeModel {
    private static final Log LOG = LogFactory.getLog(AccountTreeModel.class);
    private RowMeta rowMeta = new RowMeta(new String[]{"id", "masterid", "parent", "org", "level"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.IntegerType});
    private String[] acctFields = new String[]{"id", "masterid", "number"};
    private List<Object[]> accountTreeData = new ArrayList<Object[]>(64);
    private Set<Long> filterAccountIds = new HashSet<Long>(50);
    private Set<Object> displayAccountIds = new HashSet<Object>(10);
    private Set<String> _parentNumberSet = new HashSet<String>(32);
    public DynamicObject periodDyn;
    private static final int BATCH_SIZE = 1000;

    @Override
    public List<Object[]> getAccountTreeData() {
        return this.accountTreeData;
    }

    @Override
    public Set<Long> getFilterAccountIds() {
        return this.filterAccountIds;
    }

    @Override
    public Set<Object> getDisplayAccountIds() {
        return this.displayAccountIds;
    }

    public AccountTreeModel(Long[] orgIds, long accountTableId, long periodId, QueryParam param) {
        PerformanceWatch watch = new PerformanceWatch(AccountTreeModel.class, "AccountTreeModel", true);
        this.periodDyn = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        if (param == null || this.periodDyn == null) {
            return;
        }
        if (param.getAccountFilter() == null || !this.existAccIdFilter(param.getAccountFilter())) {
            watch.start("getbalance AccountTreeModel getData");
            this.accountTreeData = this.getData(orgIds, accountTableId, null);
        } else {
            watch.start("getbalance AccountTreeModel queryAccountNumbersByFilter");
            Set<String> accountNumbers = this.queryAccountNumbersByFilter(orgIds, accountTableId, param);
            watch.stop();
            watch.start("getbalance AccountTreeModel getAllLeafAcct");
            this.filterAccountIds = this.getAllLeafAcct(accountNumbers, orgIds, accountTableId, param);
            watch.stop();
            watch.start("getbalance AccountTreeModel getData");
            this.accountTreeData = this.getData(orgIds, accountTableId, new QFilter("masterid", "in", this.filterAccountIds));
        }
        watch.stop();
        LOG.info(watch.show());
        if (!param.isSpecialAccount()) {
            for (Object[] row : this.accountTreeData) {
                this.displayAccountIds.add(row[0]);
            }
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("getbalance accountTreeData\uff1a%s, filterAccountIds:%s", this.accountTreeData, this.filterAccountIds));
        }
    }

    private Set<String> queryAccountNumbersByFilter(Long[] orgIds, long accountTableId, QueryParam param) {
        HashSet<String> accountNumbers = new HashSet<String>(64);
        boolean queryParentAcct = !param.isOnlyLeafAcctBal();
        QFilter acctTableFilter = new QFilter("accounttable", "=", (Object)accountTableId);
        String selFields = queryParentAcct ? "number, longnumber" : "number";
        DataSet acctSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)selFields, (QFilter[])new QFilter[]{acctTableFilter, param.getAccountFilter()}, null);
        acctSet = acctSet.distinct();
        for (Row row : acctSet) {
            accountNumbers.add(row.getString("number"));
            if (!queryParentAcct) continue;
            this._parentNumberSet.addAll(Arrays.asList(row.getString("longnumber").split("_")));
        }
        boolean isSpecialAccount = param.isSpecialAccount();
        if (isSpecialAccount) {
            ArrayList<QFilter> baseFilter = new ArrayList<QFilter>(8);
            baseFilter.add(new QFilter("number", "in", accountNumbers));
            DataSet accountSet = AccountUtils.queryAccountDataSet(new HashSet<Long>(Arrays.asList(orgIds)), accountTableId, "id,masterid,number", baseFilter, null);
            for (Row row : accountSet) {
                this.displayAccountIds.add(row.getLong("id"));
            }
        }
        return accountNumbers;
    }

    @Override
    public DataSet getTreeDataSet() {
        return Algo.create((String)this.getClass().getName()).createDataSet(this.accountTreeData.iterator(), this.rowMeta);
    }

    private boolean existAccIdFilter(QFilter accFilter) {
        String property = accFilter.getProperty();
        if (property.equalsIgnoreCase("id") || property.equalsIgnoreCase("number") || property.equalsIgnoreCase("masterid")) {
            return true;
        }
        List nests = accFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            String prop = nest.getFilter().getProperty();
            if (!prop.equalsIgnoreCase("id") && !prop.equalsIgnoreCase("number") && !property.equalsIgnoreCase("masterid")) continue;
            return true;
        }
        return false;
    }

    private String parseAccFilter(QFilter accFilter) {
        String property;
        List<String> accList = Arrays.asList(this.acctFields);
        if (!accList.contains(property = accFilter.getProperty()) || this.isEmptyCollection(accFilter)) {
            return null;
        }
        property = this.addF_Id(property);
        accFilter.__setProperty(property);
        List nests = accFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            String prop = nestFilter.getProperty();
            if (!accList.contains(prop) || this.isEmptyCollection(accFilter)) {
                return null;
            }
            prop = this.addF_Id(prop);
            nestFilter.__setProperty(prop);
        }
        return accFilter.toString();
    }

    private boolean isEmptyCollection(QFilter accFilter) {
        Collection setId;
        String prop = accFilter.getProperty();
        Object valObj = accFilter.getValue();
        if ("number".equalsIgnoreCase(prop)) {
            return valObj instanceof String;
        }
        return valObj instanceof Collection && ((setId = (Collection)accFilter.getValue()) == null || setId.isEmpty());
    }

    private String addF_Id(String property) {
        property = "c.f" + property;
        return property;
    }

    private Set<Long> getAllLeafAcct(Set<String> numbers, Long[] orgIds, Long accountableId, QueryParam param) {
        HashSet<Long> masterSet = new HashSet<Long>(100);
        if (numbers == null || numbers.isEmpty()) {
            return masterSet;
        }
        boolean queryParentAcct = !param.isOnlyLeafAcctBal();
        DataSet accountSet = this.sqlQueryAccount(orgIds, this.periodDyn.getDate("enddate"), accountableId, null, false);
        if (accountSet != null) {
            for (Row row : accountSet) {
                String number;
                String[] split;
                String longnumber = row.getString("longnumber");
                for (String s : split = longnumber.split("_")) {
                    if (!numbers.contains(s)) continue;
                    masterSet.add(row.getLong("masterid"));
                }
                if (!queryParentAcct || !this._parentNumberSet.contains(number = row.getString("number"))) continue;
                masterSet.add(row.getLong("masterid"));
            }
        }
        DataSet shareAccountSet = this.sqlQueryShareAccount(this.periodDyn.getDate("enddate"), accountableId, null);
        for (Row row : shareAccountSet) {
            String number;
            String[] split;
            String longnumber = row.getString("longnumber");
            for (String s : split = longnumber.split("_")) {
                if (!numbers.contains(s)) continue;
                masterSet.add(row.getLong("masterid"));
            }
            if (!queryParentAcct || !this._parentNumberSet.contains(number = row.getString("number"))) continue;
            masterSet.add(row.getLong("masterid"));
        }
        return masterSet;
    }

    private List<Object[]> getData(Long[] orgIds, long accountTableId, QFilter accountFilter) {
        AccountTreeNode node;
        ArrayList<Object[]> accountData = new ArrayList<Object[]>(64);
        String accFilterStr = null;
        if (accountFilter != null) {
            accFilterStr = this.parseAccFilter(accountFilter.copy());
        }
        Map<String, AccountTreeNode> accountNodeMap = accountFilter != null && accFilterStr == null || orgIds.length == 1 ? this.queryAccount(orgIds, accountFilter, this.periodDyn, accountTableId) : this.queryAccount(orgIds, this.periodDyn, accountTableId, accFilterStr);
        for (Map.Entry<String, AccountTreeNode> entry : accountNodeMap.entrySet()) {
            node = entry.getValue();
            Map<Long, String> orgToPnumberMap = node.getOrgToPnumberMap();
            if (orgToPnumberMap == null) continue;
            for (Map.Entry<Long, String> entryPnumber : orgToPnumberMap.entrySet()) {
                AccountTreeNode pnode;
                long orgId = entryPnumber.getKey();
                String pNumber = entryPnumber.getValue();
                if (pNumber == null || (pnode = accountNodeMap.get(pNumber)) == null) continue;
                node.setOrgToPidMap(orgId, pnode.orgToObjsMap.get(orgId) == null ? null : (Long)((Object[])pnode.orgToObjsMap.get(orgId))[0]);
            }
        }
        for (Map.Entry<String, AccountTreeNode> entry : accountNodeMap.entrySet()) {
            node = entry.getValue();
            for (Map.Entry<Long, Object[]> entryObj : node.getOrgToObjsMap().entrySet()) {
                long orgId = entryObj.getKey();
                Object[] objs = entryObj.getValue();
                accountData.add(new Object[]{objs[0], objs[1], node.getOrgToPidMap() == null ? null : node.getOrgToPidMap().get(orgId), orgId, node.getLevel()});
            }
        }
        return accountData;
    }

    private Map<String, AccountTreeNode> queryAccount(Long[] orgIds, DynamicObject period, long accountTableId, String accFilterStr) {
        HashMap<String, AccountTreeNode> numberToNodeMap = new HashMap<String, AccountTreeNode>(64);
        DataSet querAccountSet = this.sqlQueryAccount(orgIds, period.getDate("enddate"), accountTableId, accFilterStr, true);
        if (querAccountSet != null) {
            for (Row row : querAccountSet) {
                this.buildAccountTreeMap(row.getLong("orgid"), row, numberToNodeMap);
            }
        }
        DataSet shareAccountSet = this.sqlQueryShareAccount(period.getDate("enddate"), accountTableId, accFilterStr);
        for (Row row : shareAccountSet) {
            for (Long orgId : orgIds) {
                this.buildAccountTreeMap(orgId, row, numberToNodeMap);
            }
        }
        return numberToNodeMap;
    }

    private DataSet sqlQueryAccount(Long[] orgIds, Date endDate, long accountTableId, String accFilterStr, boolean queryOrg) {
        ArrayList<Long> orgList = new ArrayList<Long>(1000);
        DataSet resultSet = null;
        Long[] longArray = orgIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long orgId = longArray[i];
            orgList.add(orgId);
            if (orgList.size() != 1000) continue;
            DataSet sqlSet = this.sqlQueryAccountInBatches(orgList.toArray(new Long[orgList.size()]), endDate, accountTableId, accFilterStr, queryOrg);
            resultSet = resultSet == null ? sqlSet : resultSet.union(sqlSet);
            orgList.clear();
        }
        if (orgList.size() > 0) {
            DataSet sqlSet = this.sqlQueryAccountInBatches(orgList.toArray(new Long[orgList.size()]), endDate, accountTableId, accFilterStr, queryOrg);
            resultSet = resultSet == null ? sqlSet : resultSet.union(sqlSet);
        }
        return resultSet;
    }

    private DataSet sqlQueryAccountInBatches(Long[] orgIds, Date endDate, long accountTableId, String accFilterStr, boolean queryOrg) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]);
        if (queryOrg) {
            sqlBuilder.append("u.fuseorgid orgid, ", new Object[0]);
        }
        sqlBuilder.append("c.fid id, c.fmasterid masterid, c.fnumber number, c.flongnumber longnumber, c.fparentid parentid, c.flevel flevel  FROM T_BD_ACCOUNT_U AS u INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid WHERE", new Object[0]);
        sqlBuilder.append(" c.faccounttableid = ?", new Object[]{accountTableId});
        sqlBuilder.append(" and c.fstartdate <= ?", new Object[]{endDate});
        sqlBuilder.append(" and c.fenddate >= ?", new Object[]{endDate});
        sqlBuilder.appendIn(" and u.fuseorgid ", (Object[])orgIds);
        if (accFilterStr != null) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.append(accFilterStr, new Object[0]);
        }
        DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        return dataSet;
    }

    private DataSet sqlQueryShareAccount(Date endDate, long accountTableId, String accFilterStr) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select c.fid id, c.fmasterid masterid, c.fnumber number, c.flongnumber longnumber, c.fparentid parentid, c.flevel flevel FROM T_BD_ACCOUNT AS c WHERE c.fctrlstrategy = '5' AND c.fstatus = 'C' AND", new Object[0]);
        sqlBuilder.append(" c.faccounttableid = ?", new Object[]{accountTableId});
        sqlBuilder.append(" and c.fstartdate <= ?", new Object[]{endDate});
        sqlBuilder.append(" and c.fenddate >= ?", new Object[]{endDate});
        if (accFilterStr != null) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.append(accFilterStr, new Object[0]);
        }
        DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        return dataSet;
    }

    private Map<String, AccountTreeNode> queryAccount(Long[] orgIds, QFilter accountFilter, DynamicObject period, long accountTableId) {
        HashMap<String, AccountTreeNode> numberToNodeMap = new HashMap<String, AccountTreeNode>(64);
        Long[] longArray = orgIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long orgId = longArray[i];
            ArrayList<QFilter> baseFilter = new ArrayList<QFilter>(10);
            baseFilter.add(accountFilter);
            baseFilter.add(new QFilter("startdate", "<=", (Object)period.getDate("enddate")));
            baseFilter.add(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
            DataSet dataSet = AccountUtils.queryAccountDataSet(orgId, accountTableId, "id,masterid,number,longnumber longnumber,level flevel", baseFilter, null);
            for (Row row : dataSet) {
                this.buildAccountTreeMap(orgId, row, numberToNodeMap);
            }
        }
        return numberToNodeMap;
    }

    private void buildAccountTreeMap(long orgId, Row row, Map<String, AccountTreeNode> numberToNodeMap) {
        String number = row.getString("number");
        AccountTreeNode treeNode = numberToNodeMap.computeIfAbsent(number, x -> new AccountTreeNode());
        treeNode.buildAccountTreeNode(orgId, row);
        numberToNodeMap.put(row.getString("number"), treeNode);
    }

    @Override
    public Map<OrgAccMidKey, BiTreeNode.TreeNodeRelation<Long>> toMap() {
        if (CollectionUtils.isEmpty(this.accountTreeData)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<OrgAccMidKey, BiTreeNode.TreeNodeRelation<Long>> result = new HashMap<OrgAccMidKey, BiTreeNode.TreeNodeRelation<Long>>(this.accountTreeData.size());
        for (Object[] entry : this.accountTreeData) {
            long accMasterId;
            long orgId = (Long)entry[3];
            OrgAccMidKey key = new OrgAccMidKey(orgId, accMasterId = ((Long)entry[1]).longValue());
            if (result.containsKey(key)) {
                String errMsg = "logic error, there is duplicate entry for org:" + orgId + "account master id:" + accMasterId;
                LOG.error(errMsg + "detail data as below:" + String.join((CharSequence)"\n", this.accountTreeData.stream().map(x -> StringUtils.join((Object[])x)).collect(Collectors.toList())));
                throw new KDBizException(errMsg);
            }
            result.put(key, TreeNodeRelationFactory.get().getTreeNodeRelation((Long)entry[0], (Long)entry[2]));
        }
        return result;
    }

    public static class AccountParentRelation {
        private long accountId;
        private Long parentAccId;

        public AccountParentRelation(long accountId, Long parentAccId) {
            this.accountId = accountId;
            this.parentAccId = parentAccId;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public Long getParentAccId() {
            return this.parentAccId;
        }
    }

    public static class OrgAccMidKey {
        private long orgId;
        private long accMasterId;

        public OrgAccMidKey(long orgId, long accMasterId) {
            this.orgId = orgId;
            this.accMasterId = accMasterId;
        }

        public long getOrgId() {
            return this.orgId;
        }

        public long getAccMasterId() {
            return this.accMasterId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrgAccMidKey that = (OrgAccMidKey)o;
            return this.orgId == that.orgId && this.accMasterId == that.accMasterId;
        }

        public int hashCode() {
            return Objects.hash(this.orgId, this.accMasterId);
        }
    }

    static class AccountTreeNode {
        private String number;
        private Integer level;
        private Map<Long, String> orgToPnumberMap = new HashMap<Long, String>(16);
        private Map<Long, Object[]> orgToObjsMap = new HashMap<Long, Object[]>(16);
        private Map<Long, Long> orgToPidMap = new HashMap<Long, Long>(16);

        private AccountTreeNode() {
        }

        private void buildAccountTreeNode(long orgId, Row row) {
            this.number = row.getString("number");
            this.level = row.getInteger("flevel");
            String longNumber = row.getString("longnumber");
            String[] numbers = longNumber.split("_");
            String parentNumber = null;
            if (numbers.length > 1) {
                int parentLen = numbers.length;
                parentNumber = numbers[parentLen - 2];
                this.orgToPnumberMap.put(orgId, parentNumber);
            }
            Object[] objs = new Object[]{row.getLong("id"), row.getLong("masterid"), parentNumber};
            this.orgToObjsMap.put(orgId, objs);
        }

        public Integer getLevel() {
            return this.level;
        }

        public String getNumber() {
            return this.number;
        }

        public Map<Long, String> getOrgToPnumberMap() {
            return this.orgToPnumberMap;
        }

        public Map<Long, Object[]> getOrgToObjsMap() {
            return this.orgToObjsMap;
        }

        public Map<Long, Long> getOrgToPidMap() {
            return this.orgToPidMap;
        }

        public void setOrgToPidMap(Long orgId, Long pid) {
            this.orgToPidMap.put(orgId, pid);
        }
    }
}

