/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.budgetaccounting;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.accountmap.exception.AccountMappingNotFoundException;
import kd.fi.bd.service.budgetaccounting.BudgetAccountingService;
import kd.fi.bd.service.budgetaccounting.DynamicAdapterConverter;
import kd.fi.bd.service.budgetaccounting.IEntryConverter;
import kd.fi.bd.service.budgetaccounting.dao.VoucherDao;
import kd.fi.bd.service.budgetaccounting.dao.VoucherDaoImpl;
import kd.fi.bd.service.budgetaccounting.service.BudgetEntryGeneratorService;
import kd.fi.bd.service.budgetaccounting.vo.VoucherEntryDynamicObjectAdapter;
import kd.fi.bd.service.budgetaccounting.vo.VoucherEntryVO;
import kd.fi.bd.util.BDUtil;

public class BudgetAccountingServiceImpl
implements BudgetAccountingService {
    private final VoucherDao voucherDao = VoucherDaoImpl.getInstance();

    @Override
    public void appendBudgetEntriesFromEntryIds(Collection<Long> entryIds, Long bookId, Long bookedPeriodId) {
        Preconditions.checkArgument((bookId != null && bookId > 0L ? 1 : 0) != 0, (Object)("bookId:" + bookId));
        Preconditions.checkArgument((bookedPeriodId != null && bookedPeriodId > 0L ? 1 : 0) != 0, (Object)("bookedPeriodId:" + bookedPeriodId));
        if (CollectionUtils.isEmpty(entryIds)) {
            return;
        }
        DynamicObject bookDyn = this.loadBookDyn(bookId);
        HintCondition orgHint = new HintCondition("forgid", "=", (Object)bookDyn.getLong("org_id"));
        HintCondition periodHint = new HintCondition("fperiodid", "=", (Object)bookedPeriodId);
        try (TXHandle txHandle = TX.required();){
            List<VoucherEntryVO> budgetEntries;
            Throwable throwable;
            ShardingHintContext ignore;
            block34: {
                block35: {
                    block36: {
                        ignore = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{orgHint, periodHint}).prepareShardingIndex();
                        throwable = null;
                        List<VoucherEntryVO> voucherEntryVOS = this.voucherDao.getBatchByIds(entryIds);
                        budgetEntries = new BudgetEntryGeneratorService(bookDyn).generateBudgetEntries(voucherEntryVOS);
                        if (!budgetEntries.isEmpty()) break block34;
                        if (ignore == null) break block35;
                        if (throwable == null) break block36;
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block35;
                    }
                    ignore.close();
                }
                return;
            }
            try {
                try {
                    this.voucherDao.batchSaveVoucherEntryVOList(budgetEntries);
                }
                catch (AccountMappingNotFoundException e) {
                    LogFactory.getLog(this.getClass()).warn("account mapping not found, bookid={}", (Object)bookId);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (ignore != null) {
                    if (throwable != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ignore.close();
                    }
                }
            }
        }
    }

    @Override
    public List<DynamicObject> appendBudgetEntriesFromVoucherDyn(DynamicObject voucherDyn) throws AccountMappingNotFoundException {
        DynamicObjectCollection entries = voucherDyn.getDynamicObjectCollection("entries");
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        long orgId = voucherDyn.getLong("org_id");
        long periodId = voucherDyn.getLong("period.id");
        IEntryConverter<VoucherEntryDynamicObjectAdapter> entryConverter = this.getEntryConverter(orgId, periodId, voucherDyn);
        List entryAdapters = entries.stream().map(entryConverter::convert).collect(Collectors.toList());
        BudgetEntryGeneratorService generatorService = voucherDyn.containsProperty("book") ? new BudgetEntryGeneratorService(voucherDyn.getDynamicObject("book")) : new BudgetEntryGeneratorService(this.loadBookId(voucherDyn));
        List budgetEntries = generatorService.generateBudgetEntries(entryAdapters);
        if (budgetEntries.isEmpty()) {
            return Collections.emptyList();
        }
        List<DynamicObject> budgetDyns = BDUtil.extractToList(budgetEntries, entryConverter::revert);
        BusinessDataReader.loadRefence((Object[])budgetDyns.toArray(), (IDataEntityType)budgetDyns.get(0).getDataEntityType());
        int lastAvailRow = entries.indexOf((Object)entries.stream().filter(row -> row.get("account") != null).reduce((a, b) -> b).get());
        entries.addAll(lastAvailRow + 1, budgetDyns);
        return budgetDyns;
    }

    protected IEntryConverter<VoucherEntryDynamicObjectAdapter> getEntryConverter(long orgId, long periodId, DynamicObject voucher) {
        return new DynamicAdapterConverter(orgId, periodId);
    }

    private long loadBookId(DynamicObject voucherDyn) {
        return new AccountBookInfo(voucherDyn.getLong("org_id"), voucherDyn.getLong("booktype_id")).getId();
    }

    private DynamicObject loadBookDyn(long bookId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)bookId, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"gl_accountbook", Arrays.asList("org", "accounttable", "basecurrency")));
    }
}

