/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.budgetaccounting.dao;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.service.budgetaccounting.dao.VoucherDao;
import kd.fi.bd.service.budgetaccounting.vo.VoucherEntryVO;

public class VoucherDaoImpl
implements VoucherDao {
    private static final VoucherDaoImpl INSTANCE = new VoucherDaoImpl();

    private VoucherDaoImpl() {
    }

    public static VoucherDaoImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public List<VoucherEntryVO> getBatchByIds(Collection<Long> entryIds) {
        return Arrays.stream(BusinessDataReader.load((Object[])entryIds.toArray(), (IDataEntityType)OrmUtils.getDataEntityType(VoucherEntryVO.class))).map(VoucherEntryVO.class::cast).collect(Collectors.toList());
    }

    @Override
    public void batchSaveVoucherEntryVOList(Collection<VoucherEntryVO> entryVOS) {
        SequenceReader reader = new SequenceReader(DBRoute.of((String)"gl"));
        Long[] entryPks = (Long[])reader.getSequences((Object[])new Long[0], "t_gl_voucherentry", entryVOS.size());
        int i = 0;
        for (VoucherEntryVO entryVO : entryVOS) {
            entryVO.setEntryId(entryPks[i++]);
        }
        SaveServiceHelper.save((IDataEntityType)OrmUtils.getDataEntityType(VoucherEntryVO.class), (Object[])entryVOS.toArray());
    }

    @Override
    public Map<Long, Long> getMaxSeqMap(Collection<Long> voucherIds) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(voucherIds.size());
        try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, voucherIds)});
             DataSet dataSet = DB.queryDataSet((String)"VoucherDaoImpl#getMaxSeqMap", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)new SqlBuilder().appendIn("select fid,max(fseq) maxseq from t_gl_voucherentry where fid ", voucherIds.toArray()).append("group by fid", new Object[0]));){
            for (Row row : dataSet) {
                result.put(row.getLong("fid"), row.getLong("maxseq"));
            }
        }
        return result;
    }
}

