/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.budgetaccounting.mc;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.service.budgetaccounting.vo.VoucherEntryDynamicObjectAdapter;
import kd.fi.bd.service.budgetaccounting.vo.VoucherEntryVO;

public class MCBudgetDynamicEntryVO
extends VoucherEntryDynamicObjectAdapter {
    private static final long serialVersionUID = 7431829022290576420L;
    private final LocalCurrencyConfigVO[] usingEntryCurrencyConfigs;

    public MCBudgetDynamicEntryVO(DynamicObject entryRow, long orgId, long bookedPeriodId, LocalCurrencyConfigVO[] usingEntryCurrencyConfigs) {
        super(entryRow, orgId, bookedPeriodId);
        this.usingEntryCurrencyConfigs = usingEntryCurrencyConfigs;
    }

    @Override
    public void setCurrencyId(long currencyId) {
        long oldCurrencyId = this.getCurrencyId();
        super.setCurrencyId(currencyId);
        if (currencyId != oldCurrencyId) {
            for (LocalCurrencyConfigVO config : this.usingEntryCurrencyConfigs) {
                this.getEntryRow().set(config.getVoucherField(MCT.DEBIT).getMetaId(), (Object)BigDecimal.ZERO);
                this.getEntryRow().set(config.getVoucherField(MCT.CREDIT).getMetaId(), (Object)BigDecimal.ZERO);
                this.getEntryRow().set(config.getVoucherField(MCT.EX_RATE).getMetaId(), (Object)BigDecimal.ZERO);
                this.getEntryRow().set(config.getVoucherField(MCT.EX_RATE_TYPE).getMetaId(), null);
            }
        }
    }

    @Override
    public VoucherEntryVO clone() {
        VoucherEntryDynamicObjectAdapter clone = (VoucherEntryDynamicObjectAdapter)super.clone();
        return new MCBudgetDynamicEntryVO(clone.getEntryRow(), clone.getEorgId(), clone.getePeriodId(), this.usingEntryCurrencyConfigs);
    }
}

