/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.voucher;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import org.apache.commons.lang3.ArrayUtils;

public class TempVoucherCFService {
    private static final Log LOG = LogFactory.getLog(TempVoucherCFService.class);
    private static DBRoute ROUNTE_FI = DBRoute.of((String)"fi");
    private static final String ENTITY = "gl_tempvoucher_cf_index";
    private static final String UPDATE_SQL = "UPDATE t_gl_tempvoucher_cf_index SET fcashflowitemid = ? WHERE fid = ?;";
    private static final String INSERT_SQL = "INSERT INTO t_gl_tempvoucher_cf_index (fid,fvoucherid,forgid,fcashflowitemid) values(?,?,?,?);";

    public static void deleteByIds(Long[] voucherIds) {
        if (!ArrayUtils.isEmpty((Object[])voucherIds)) {
            try (TXHandle tx = TX.required();){
                try {
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("delete from t_gl_tempvoucher_cf_index where ", new Object[0]);
                    sqlBuilder.appendIn(" fvoucherid ", (Object[])voucherIds);
                    DB.execute((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDException((Throwable)e, new ErrorCode("TempVoucherCFService", e.getMessage()), new Object[]{""});
                }
            }
        }
    }

    private static boolean checkConsistentOnOrgAndPeriod(long voucherId, long orgId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select TOP 1 fid from t_gl_tempvoucher_cf_index where ", new Object[0]);
        sqlBuilder.append(" fvoucherid = ? ", new Object[]{voucherId});
        sqlBuilder.append(" and (", new Object[0]);
        sqlBuilder.append(" forgid != ? ", new Object[]{orgId});
        sqlBuilder.append(" ) ", new Object[0]);
        return (Boolean)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        }) == false;
    }

    private static DataSet queryNotExistCfIds(Set<Long> voucherIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid id,fvoucherid vid, fcashflowitemid cfitemid from t_gl_tempvoucher_cf_index where ", new Object[0]);
        sqlBuilder.appendIn(" fvoucherid ", voucherIds.toArray());
        sqlBuilder.append(" order by fid ", new Object[0]);
        return DB.queryDataSet((String)(TempVoucherCFService.class.getName() + "/queryNotExistCfIds"), (DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
    }

    public static void updateOrInsert(Set<Long> voucherIds, Map<Long, Long> vId2orgId, Map<Long, Set<Long>> vId2newVersionCfIds) {
        if (CollectionUtils.isEmpty(vId2newVersionCfIds.values())) {
            return;
        }
        DataSet existCfIdDs = TempVoucherCFService.queryNotExistCfIds(voucherIds);
        long vid = 0L;
        int idCount = TempVoucherCFService.getCfCount(vId2newVersionCfIds);
        Set<Object> newVersionCfIds = new HashSet(1);
        HashMap vid2dirtyCfPairs = new HashMap(vId2newVersionCfIds.size());
        ArrayList<Tuple> dirtyCfPairs = new ArrayList<Tuple>(16);
        for (Row row : existCfIdDs) {
            long cfitemId;
            long voucherId = row.getLong("vid");
            if (vid == 0L || vid != voucherId) {
                vid = voucherId;
                newVersionCfIds = vId2newVersionCfIds.get(vid);
                dirtyCfPairs = new ArrayList(16);
                vid2dirtyCfPairs.put(vid, dirtyCfPairs);
            }
            if (!newVersionCfIds.contains(cfitemId = row.getLong("cfitemid").longValue())) {
                dirtyCfPairs.add(Tuple.create((Object)row.getLong("id"), (Object)cfitemId));
                continue;
            }
            newVersionCfIds.remove(cfitemId);
            --idCount;
        }
        if (DebugTrace.enable()) {
            LOG.info("new CfIds:" + vId2newVersionCfIds);
        }
        long[] newIds = DBServiceHelper.genLongIds((String)"t_gl_tempvoucher_cf_index", (int)idCount);
        try (TXHandle tx = TX.required();){
            try {
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
                ArrayList<DynamicObject> insertDys = new ArrayList<DynamicObject>(8);
                ArrayList<Tuple<Long, Long>> deleteIds = new ArrayList<Tuple<Long, Long>>(16);
                int i = 0;
                for (Map.Entry<Long, Set<Long>> entry : vId2newVersionCfIds.entrySet()) {
                    long voucherId = entry.getKey();
                    List curDirtyCfPairs = vid2dirtyCfPairs.getOrDefault(voucherId, new ArrayList(0));
                    Set<Long> curCfitemids = entry.getValue();
                    int j = 0;
                    for (Long cfItemId : curCfitemids) {
                        if (j < curDirtyCfPairs.size()) {
                            updateParams.add(new Object[]{cfItemId, ((Tuple)curDirtyCfPairs.get((int)j)).item1});
                            if (updateParams.size() >= 1000) {
                                TempVoucherCFService.updateTempVoucher(updateParams, UPDATE_SQL);
                                if (DebugTrace.enable()) {
                                    LOG.info("update cfitem info:" + updateParams);
                                }
                                updateParams.clear();
                            }
                        } else {
                            DynamicObject newDy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
                            newDy.set("id", (Object)newIds[i]);
                            newDy.set("voucherid", (Object)voucherId);
                            newDy.set("org", (Object)vId2orgId.get(voucherId));
                            newDy.set("cashflowitem", (Object)cfItemId);
                            insertDys.add(newDy);
                            if (insertDys.size() >= 1000) {
                                SaveServiceHelper.save((DynamicObject[])insertDys.toArray(new DynamicObject[insertDys.size()]));
                                if (DebugTrace.enable()) {
                                    LOG.info("insert new cashflow info:" + insertDys.size());
                                }
                                insertDys.clear();
                            }
                        }
                        ++i;
                        ++j;
                    }
                    if (curCfitemids.size() >= curDirtyCfPairs.size()) continue;
                    deleteIds.addAll(curDirtyCfPairs.subList(curCfitemids.size(), curDirtyCfPairs.size()));
                    if (deleteIds.size() < 1000) continue;
                    TempVoucherCFService.deleteTempVoucher(deleteIds);
                    deleteIds.clear();
                }
                if (!updateParams.isEmpty()) {
                    TempVoucherCFService.updateTempVoucher(updateParams, UPDATE_SQL);
                    if (DebugTrace.enable()) {
                        LOG.info("update cashflow info:" + updateParams);
                    }
                    updateParams.clear();
                }
                if (!insertDys.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])insertDys.toArray(new DynamicObject[insertDys.size()]));
                    if (DebugTrace.enable()) {
                        LOG.info("insert new cashflow info:" + insertDys.size());
                    }
                    insertDys.clear();
                }
                if (!deleteIds.isEmpty()) {
                    TempVoucherCFService.deleteTempVoucher(deleteIds);
                    deleteIds.clear();
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("TempVoucherCFService", e.getMessage()), new Object[]{""});
            }
        }
    }

    private static void deleteTempVoucher(List<Tuple<Long, Long>> deleteIds) {
        QFilter filter = new QFilter("id", "in", deleteIds.stream().map(x -> (Long)x.item1).collect(Collectors.toList()));
        DeleteServiceHelper.delete((String)ENTITY, (QFilter[])filter.toArray());
        if (DebugTrace.enable()) {
            LOG.info("delete cashflow size:" + deleteIds.size());
        }
    }

    public static void updateTempVoucher(List<Object[]> updateParams, String updateSql) {
        DB.executeBatch((DBRoute)ROUNTE_FI, (String)updateSql, updateParams);
    }

    public static void batchInsert(List<Long> voucherIds) {
        if (CollectionUtils.isEmpty(voucherIds)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select distinct v.fid fvoucherid,v.forgid,ve.fmaincfitemid,ve.fsuppcfitemid from t_gl_voucher v inner join t_gl_voucherentry ve on v.fid = ve.fid where ", new Object[0]);
                sqlBuilder.appendIn(" v.fid ", voucherIds.toArray(new Object[voucherIds.size()]));
                ArrayList<Object[]> insertParams = new ArrayList<Object[]>(128);
                DataSet ds = DB.queryDataSet((String)(TempVoucherCFService.class.getName() + "/batchInsert"), (DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
                while (ds.hasNext()) {
                    Row row = ds.next();
                    long voucherId = row.getLong("fvoucherid");
                    long orgId = row.getLong("forgid");
                    long mainCfIetmId = row.getLong("fmaincfitemid");
                    long suppCfitemId = row.getLong("fsuppcfitemid");
                    if (mainCfIetmId == 0L && suppCfitemId == 0L) continue;
                    if (mainCfIetmId != 0L) {
                        insertParams.add(new Object[]{null, voucherId, orgId, mainCfIetmId});
                    }
                    if (suppCfitemId != 0L) {
                        insertParams.add(new Object[]{null, voucherId, orgId, suppCfitemId});
                    }
                    if (insertParams.size() < 1000) continue;
                    TempVoucherCFService.batchInsertIntoDB(insertParams);
                }
                if (!insertParams.isEmpty()) {
                    TempVoucherCFService.batchInsertIntoDB(insertParams);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("TempVoucherService", e.getMessage()), new Object[]{""});
            }
        }
    }

    private static void batchInsertIntoDB(List<Object[]> insertParams) {
        long[] newIds = DBServiceHelper.genLongIds((String)"t_gl_tempvoucher_cf_index", (int)insertParams.size());
        for (int i = 0; i < insertParams.size(); ++i) {
            insertParams.get((int)i)[0] = newIds[i];
        }
        TempVoucherCFService.updateTempVoucher(insertParams, INSERT_SQL);
        insertParams.clear();
    }

    public static void reInit() {
        long tick = System.currentTimeMillis();
        int loop = 0;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)ROUNTE_FI, (String)"truncate table t_gl_tempvoucher_cf_index;");
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select distinct v.fvoucherid from (select DISTINCT fvoucherid from t_gl_tempvoucher_index ) v inner join t_gl_voucherentry ve on v.fvoucherid=ve.fid where  ve.fmaincfitemid > 0", new Object[0]);
                DataSet ds = DB.queryDataSet((String)(TempVoucherCFService.class.getName() + "reInit"), (DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
                ArrayList<Long> vids = new ArrayList<Long>(100);
                while (ds.hasNext()) {
                    vids.add(ds.next().getLong("fvoucherid"));
                    if (vids.size() <= 100) continue;
                    long loopTick = System.currentTimeMillis();
                    TempVoucherCFService.batchInsert(vids);
                    LOG.info("reinit_tempvoucherindex loop: {} cost: {}", (Object)(++loop), (Object)(System.currentTimeMillis() - loopTick));
                    vids.clear();
                }
                if (!vids.isEmpty()) {
                    TempVoucherCFService.batchInsert(vids);
                }
            }
            catch (Exception e) {
                LOG.error("failed init tempvoucher index on " + e.getMessage(), (Throwable)e);
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("TempVoucherService-Reinit", e.getMessage()), new Object[]{""});
            }
        }
        LOG.info("reinit temp voucher index cost:" + (System.currentTimeMillis() - tick));
    }

    private static int getCfCount(Map<Long, Set<Long>> vId2newVersionCfIds) {
        int count = 0;
        for (Map.Entry<Long, Set<Long>> entry : vId2newVersionCfIds.entrySet()) {
            count += entry.getValue().size();
        }
        return count;
    }
}

