/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.tasks.IGroupTaskStatusEvent;
import kd.fi.bd.tasks.ITaskStatusEvent;

public interface IDataWorkTaskStatusMgr {
    public ITaskStatusEvent getTaskStatus(Object var1, Object var2, boolean var3);

    default public ITaskStatusEvent getTaskStatus(Object taskId, boolean removeFromCache) {
        return this.getTaskStatus(taskId, taskId, removeFromCache);
    }

    default public ITaskStatusEvent getTaskStatus(Object taskId) {
        return this.getTaskStatus(taskId, taskId, false);
    }

    public IGroupTaskStatusEvent getGroupStatus(Object var1, boolean var2);

    default public IGroupTaskStatusEvent getGroupStatus(Object groupId) {
        return this.getGroupStatus(groupId, false);
    }

    default public Map<Object, ITaskStatusEvent> getTaskStatusBatch(Object groupId, Collection<Object> taskIds, boolean removeFromCache) {
        LinkedHashMap<Object, ITaskStatusEvent> resultMap = new LinkedHashMap<Object, ITaskStatusEvent>(taskIds.size());
        for (Object taskId : taskIds) {
            resultMap.put(taskId, this.getTaskStatus(groupId, taskId, removeFromCache));
        }
        return resultMap;
    }

    default public Map<Object, ITaskStatusEvent> getGroupTaskStatus(Object groupId, BiFunction<Object, CDCStageEnum, Boolean> taskFilter) {
        IGroupTaskStatusEvent groupStatusEvent = this.getGroupStatus(groupId);
        Iterator taskIds = groupStatusEvent.getSubTaskIds(taskFilter);
        if (taskIds == null) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<Object, ITaskStatusEvent> resultMap = new LinkedHashMap<Object, ITaskStatusEvent>();
        while (taskIds.hasNext()) {
            PairTuple taskInfo = (PairTuple)((Object)taskIds.next());
            if (taskInfo == null) continue;
            Object taskId = taskInfo.getKey();
            resultMap.put(taskId, this.getTaskStatus(groupId, taskId, false));
        }
        return resultMap;
    }

    default public boolean isTaskCompleted(Object groupId, Object taskId) {
        ITaskStatusEvent statusEvent = this.getTaskStatus(groupId, taskId, false);
        return statusEvent != null ? statusEvent.isCompleted() : true;
    }

    default public boolean isTaskCompleted(Object taskId) {
        return this.isTaskCompleted(taskId, taskId);
    }

    default public boolean isGroupCompleted(Object groupId) {
        IGroupTaskStatusEvent statusEvent = this.getGroupStatus(groupId, false);
        return statusEvent != null ? statusEvent.isCompleted() : true;
    }

    public boolean reportTaskStatus(ITaskStatusEvent var1);

    default public boolean reportTaskStatus(Object groupId, Object taskId, int completedPoint, CDCStageEnum newStatusCode, String statusInfo) {
        return this.reportTaskStatus(this.buildTaskStatusEvent(groupId, taskId, completedPoint, null, newStatusCode, statusInfo));
    }

    default public boolean registerNewTaskStatus(Object groupId, Object taskId, int completedPoint, int taskTotalPoint, CDCStageEnum newStatusCode, String statusInfo) {
        return this.reportTaskStatus(this.buildTaskStatusEvent(groupId, taskId, completedPoint, taskTotalPoint, newStatusCode, statusInfo));
    }

    default public boolean registerGroupStatus(Object groupId, int completedPoint, int taskTotalPoint, CDCStageEnum newStatusCode, String statusInfo) {
        return this.reportTaskStatus(this.buildTaskStatusEvent(groupId, null, completedPoint, taskTotalPoint, newStatusCode, statusInfo));
    }

    default public boolean reportGroupStatus(Object groupId, int completedPoint, CDCStageEnum newStatusCode, String statusInfo) {
        this.reportTaskStatus(this.buildTaskStatusEvent(groupId, null, completedPoint, null, newStatusCode, statusInfo));
        return true;
    }

    public ITaskStatusEvent buildTaskStatusEvent(Object var1, Object var2, int var3, Integer var4, CDCStageEnum var5, String var6);

    public void cancelTask(Object var1, Object var2);

    default public void cancelTask(Object taskId) {
        this.cancelTask(taskId, taskId);
    }

    public void cancelGroup(Object var1);

    default public boolean isTaskCancelled(Object groupId, Object taskId) {
        ITaskStatusEvent statusEvent = this.getTaskStatus(groupId, taskId, false);
        return statusEvent != null ? statusEvent.isCancelled() : true;
    }

    default public boolean isTaskCancelled(Object taskId) {
        return this.isTaskCancelled(taskId, taskId);
    }

    default public boolean isGroupCancelled(Object groupId) {
        IGroupTaskStatusEvent statusEvent = this.getGroupStatus(groupId, false);
        return statusEvent != null ? statusEvent.isCancelled() : true;
    }

    public static enum StatusModelType {
        Group_Status(1),
        Task_Status(2),
        Control_Flag(10);

        int code;

        private StatusModelType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public boolean isControlType() {
            return this.code == Control_Flag.getCode();
        }
    }
}

