/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.tasks.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.DistributeCache;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.tasks.IDataWorkTaskStatusMgr;
import kd.fi.bd.tasks.IGroupTaskStatusEvent;
import kd.fi.bd.tasks.ITaskStatusEvent;
import kd.fi.bd.tasks.common.BaseTaskGroupStatus;
import kd.fi.bd.tasks.common.BaseTaskStatus;
import kd.fi.bd.threads.ThreadCategoryEnum;
import kd.fi.bd.util.bean.IDataBeanUtil;
import kd.fi.bd.util.data.IDataJsonUtil;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.pipe.SimpleAsyncPipe;
import kd.fi.bd.util.pipe.datablock.IAsyncStreamDataBlock;

public abstract class AbstractWorkTaskStatusConsumer
implements IDataWorkTaskStatusMgr {
    private static final Log logger = LogFactory.getLog(AbstractWorkTaskStatusConsumer.class);
    private static final int cacheTimeOut = 600;
    protected SimpleAsyncPipe<ITaskStatusEvent> processPipe = new SimpleAsyncPipe(ThreadCategoryEnum.FI_PIPE, (category, data) -> this.onConsumePipeQueue((ThreadCategoryEnum)((Object)category), (IAsyncStreamDataBlock<ITaskStatusEvent>)data));
    protected DistributeCache cache;

    protected abstract CacheModule getCacheModel();

    protected int getCacheTimeOut() {
        return 600;
    }

    protected AbstractWorkTaskStatusConsumer() {
        if (this.getCacheModel() == null) {
            throw new IllegalArgumentException();
        }
        this.cache = new DistributeCache(this.getCacheModel());
    }

    protected void onConsumePipeQueue(ThreadCategoryEnum category, IAsyncStreamDataBlock<ITaskStatusEvent> dataBlock) {
        ITaskStatusEvent taskStatus;
        if (dataBlock != null && (taskStatus = dataBlock.getData()) != null) {
            Object groupId = taskStatus.getGroupId();
            Object taskId = taskStatus.getTaskId();
            if (taskStatus.needMergeStatus()) {
                switch (taskStatus.getStatusEventType()) {
                    case Group_Status: {
                        taskStatus.mergeStatus(this.getGroupStatus(groupId, false));
                        break;
                    }
                    case Task_Status: {
                        taskStatus.mergeStatus(this.getTaskStatus(groupId, taskId, false));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not Support StatusEventType:" + (Object)((Object)taskStatus.getStatusEventType()));
                    }
                }
            }
            this.putCacheValue(taskStatus);
        }
    }

    protected String getTaskCacheKey(IDataWorkTaskStatusMgr.StatusModelType modelType, Object groupId, Object taskId) {
        String splitter;
        String string = splitter = modelType != null && modelType.isControlType() ? "||" : "|";
        if (taskId == null) {
            return String.valueOf((Object)this.getCacheModel()) + splitter + groupId;
        }
        return String.valueOf((Object)this.getCacheModel()) + splitter + groupId + splitter + taskId;
    }

    protected String getTaskCacheKey(ITaskStatusEvent taskStatusEvent) {
        switch (taskStatusEvent.getStatusEventType()) {
            case Group_Status: 
            case Control_Flag: {
                return this.getTaskCacheKey(taskStatusEvent.getStatusEventType(), taskStatusEvent.getGroupId(), null);
            }
        }
        return this.getTaskCacheKey(taskStatusEvent.getStatusEventType(), taskStatusEvent.getGroupId(), taskStatusEvent.getTaskId());
    }

    protected String serializeValue(IDataWorkTaskStatusMgr.StatusModelType modelType, Object groupId, Object taskId, Object value) {
        return IDataJsonUtil.toJSONString(value);
    }

    protected ITaskStatusEvent deserializeTaskStatus(IDataWorkTaskStatusMgr.StatusModelType modelType, Object groupId, Object taskId, Object value) {
        JSONArray jsonArray = IDataValueUtil.toJSONArray(value);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return (ITaskStatusEvent)IDataBeanUtil.getClassNewInstance(IDataBeanUtil.getClassByName(String.valueOf(jsonArray.get(0))), jsonArray);
    }

    protected IGroupTaskStatusEvent deserializeGroupStatus(IDataWorkTaskStatusMgr.StatusModelType modelType, Object groupId, Object value) {
        JSONArray jsonArray = IDataValueUtil.toJSONArray(value);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return (IGroupTaskStatusEvent)IDataBeanUtil.getClassNewInstance(IDataBeanUtil.getClassByName(String.valueOf(jsonArray.get(0))), jsonArray);
    }

    protected void putCacheValue(ITaskStatusEvent taskStatusEvent) {
        if (taskStatusEvent == null) {
            return;
        }
        this.cache.put(this.getTaskCacheKey(taskStatusEvent), this.serializeValue(taskStatusEvent.getStatusEventType(), taskStatusEvent.getGroupId(), taskStatusEvent.getTaskId(), taskStatusEvent));
    }

    protected Object getCacheValue(String key, boolean remove) {
        if (remove) {
            String result = this.cache.get(key);
            this.cache.remove(key);
            return result;
        }
        return this.cache.get(key);
    }

    @Override
    public ITaskStatusEvent getTaskStatus(Object groupId, Object taskId, boolean removeFromCache) {
        return this.deserializeTaskStatus(IDataWorkTaskStatusMgr.StatusModelType.Task_Status, groupId, taskId, this.getCacheValue(this.getTaskCacheKey(IDataWorkTaskStatusMgr.StatusModelType.Task_Status, groupId, taskId), removeFromCache));
    }

    @Override
    public IGroupTaskStatusEvent getGroupStatus(Object groupId, boolean remove) {
        return this.deserializeGroupStatus(IDataWorkTaskStatusMgr.StatusModelType.Group_Status, groupId, this.getCacheValue(this.getTaskCacheKey(IDataWorkTaskStatusMgr.StatusModelType.Group_Status, groupId, null), remove));
    }

    public void setCacheStatusFlag(Object groupId, Object taskId, Object statusFlag) {
        this.cache.put(this.getTaskCacheKey(IDataWorkTaskStatusMgr.StatusModelType.Control_Flag, groupId, taskId), IDataJsonUtil.toJSONString(statusFlag));
    }

    protected <T> T getCacheStatusFlag(Object groupId, Object taskId, Class<T> targetClass, boolean removeFromCache) {
        String cacheKey = this.getTaskCacheKey(IDataWorkTaskStatusMgr.StatusModelType.Control_Flag, groupId, taskId);
        String cacheValue = this.cache.get(cacheKey);
        T result = IDataJsonUtil.parseJsonString(cacheValue, targetClass, new Feature[0]);
        if (removeFromCache) {
            this.cache.remove(cacheKey);
        }
        return result;
    }

    @Override
    public boolean reportTaskStatus(ITaskStatusEvent taskStatusEvent) {
        this.processPipe.putToQueue(taskStatusEvent);
        return true;
    }

    @Override
    public ITaskStatusEvent buildTaskStatusEvent(Object groupId, Object taskId, int completedPoint, Integer taskTotalPoint, CDCStageEnum statusCode, String statusInfo) {
        boolean registerNew;
        if (groupId == null) {
            throw new IllegalArgumentException("Invalid Task Group ID!");
        }
        boolean bl = registerNew = taskTotalPoint != null;
        BaseTaskStatus resultEvent = taskId == null ? (registerNew ? new BaseTaskGroupStatus(String.valueOf(groupId), false, completedPoint, taskTotalPoint, statusCode, statusInfo) : new BaseTaskGroupStatus(String.valueOf(groupId), true, completedPoint, statusInfo)) : (registerNew ? new BaseTaskStatus(String.valueOf(groupId), String.valueOf(taskId), false, completedPoint, taskTotalPoint, statusCode, statusInfo) : new BaseTaskStatus(String.valueOf(groupId), String.valueOf(taskId), true, completedPoint, statusInfo));
        return resultEvent;
    }

    @Override
    public void cancelTask(Object groupId, Object taskId) {
        this.setCacheStatusFlag(groupId, taskId, (Object)CDCStageEnum.Canceled);
    }

    @Override
    public void cancelGroup(Object groupId) {
        this.setCacheStatusFlag(groupId, null, (Object)CDCStageEnum.Canceled);
    }
}

