/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.tasks.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.tasks.IGroupTaskStatusEvent;
import kd.fi.bd.tasks.ITaskStatusEvent;
import kd.fi.bd.tasks.common.BaseTaskStatus;
import kd.fi.bd.util.data.IDataValueUtil;

public class BaseTaskGroupStatus
extends BaseTaskStatus
implements IGroupTaskStatusEvent<String, String> {
    protected Map<String, CDCStageEnum> subTaskStatus;

    public BaseTaskGroupStatus(String groupId, boolean needToMerge, int completedPoint, int taskTotalPoints, CDCStageEnum newTaskStatus, String statusMessage) {
        super(groupId, null, needToMerge, completedPoint, taskTotalPoints, newTaskStatus, statusMessage);
        this.subTaskStatus = new LinkedHashMap<String, CDCStageEnum>(8);
    }

    public BaseTaskGroupStatus(String groupId, boolean needToMerge, int taskTotalPoints, String statusMessage) {
        this(groupId, needToMerge, 0, taskTotalPoints, CDCStageEnum.Waiting_Start, statusMessage);
    }

    public BaseTaskGroupStatus(JSONArray jsonArray) {
        super(jsonArray);
    }

    public BaseTaskGroupStatus(Object[] v) {
        super(v);
    }

    @Override
    public String toString() {
        return "BaseTaskGroupStatus{taskStatisticsPoints=" + Arrays.toString(this.taskStatisticsPoints) + ", totalTaskTimeCost=" + Arrays.toString(this.totalTaskTimeCost) + ", withError=" + this.withError + ", groupId=" + (String)this.v1 + ", taskId=" + (String)this.v2 + ", needToMerge=" + this.v3 + ", statusMessage=" + this.statusMessage + ", subTaskStatus=" + this.subTaskStatus + '}';
    }

    public void reportSubTaskStatus(String taskId, CDCStageEnum status) {
        this.subTaskStatus.put(taskId, status);
    }

    public void registerSubTaskStatus(Collection<String> taskIds) {
        if (taskIds != null) {
            taskIds.forEach(v -> this.subTaskStatus.put((String)v, CDCStageEnum.Waiting_Start));
        }
    }

    @Override
    public void reset(int totalPoints, CDCStageEnum status) {
        this.initTaskStatistics(0, totalPoints, status);
        this.subTaskStatus.clear();
    }

    @Override
    public BaseTaskGroupStatus copy() {
        BaseTaskGroupStatus newCopy = new BaseTaskGroupStatus((String)this.v1, (Boolean)this.v3, this.taskStatisticsPoints[0], this.taskStatisticsPoints[1], this.taskStatus, this.statusMessage);
        this.subTaskStatus.entrySet().forEach(en -> newCopy.subTaskStatus.put((String)en.getKey(), (CDCStageEnum)((Object)((Object)en.getValue()))));
        return newCopy;
    }

    @Override
    public void mergeStatus(ITaskStatusEvent targetStatusEvent) {
        Iterator it;
        super.mergeStatus(targetStatusEvent);
        if (targetStatusEvent instanceof IGroupTaskStatusEvent && (it = ((IGroupTaskStatusEvent)targetStatusEvent).getSubTaskIds()) != null) {
            while (it.hasNext()) {
                PairTuple taskInfo = (PairTuple)((Object)it.next());
                if (taskInfo == null || this.subTaskStatus.containsKey(taskInfo.getKey())) continue;
                this.subTaskStatus.put(String.valueOf(taskInfo.getKey()), (CDCStageEnum)((Object)taskInfo.getValue()));
            }
        }
    }

    @Override
    public Iterator<Map.Entry<String, CDCStageEnum>> getSubTaskIds() {
        return this.subTaskStatus.entrySet().iterator();
    }

    @Override
    public int getSubTaskCnt() {
        return this.subTaskStatus.size();
    }

    @Override
    public void updateSubTaskStatus(String taskId, CDCStageEnum newStatus, boolean hasError, Object statusMessage) {
        this.subTaskStatus.put(taskId, newStatus);
        if (!this.withError) {
            this.withError = hasError;
        }
        this.statusMessage = statusMessage != null ? String.valueOf(statusMessage) : null;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return super.getArraySize() + 1;
    }

    @Override
    protected int serializedArrayStartPos() {
        return 1;
    }

    @Override
    protected Object[] appendSerializedArray(int startPos, Object[] targetArray) {
        targetArray = super.appendSerializedArray(startPos, targetArray);
        int idx = super.getArraySize();
        targetArray[idx] = this.subTaskStatus;
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        super.updateValueArray(v);
        int idx = super.getArraySize();
        Map<String, Object> buf = IDataValueUtil.parseMap(IDataValueUtil.getJSONObject(v, idx));
        if (buf != null) {
            this.subTaskStatus = new LinkedHashMap<String, CDCStageEnum>(buf.size());
            buf.entrySet().forEach(en -> this.subTaskStatus.put((String)en.getKey(), CDCStageEnum.valueOf(String.valueOf(en.getValue()))));
        } else {
            this.subTaskStatus = new LinkedHashMap<String, CDCStageEnum>(8);
        }
    }
}

