/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import org.apache.commons.lang3.time.DateFormatUtils;

public class AccountBizCheckUtil {
    private static final Log LOG = LogFactory.getLog(AccountBizCheckUtil.class);

    public static Table<Long, Long, Integer> batchCheckAfterSpecificDate(Map<Long, Set<Long>> orgAccMap, Date specificDate) {
        Preconditions.checkArgument((boolean)Objects.nonNull(orgAccMap));
        if (Objects.isNull(specificDate)) {
            specificDate = AccountVersionUtil.getStartDate();
        }
        long tick = System.currentTimeMillis();
        Set<Long> periodIds = BDUtil.getLaterCrossPeriods(specificDate);
        Set<Long> accIds = orgAccMap.values().stream().filter(x -> Objects.nonNull(x)).flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (accIds.isEmpty()) {
            return HashBasedTable.create();
        }
        Set<Long> orgs = orgAccMap.keySet();
        long balanceInitTick = System.currentTimeMillis();
        Multimap<Long, Long> balanceInitData = AccountBizCheckUtil.checkBalanceInitHappen(accIds, orgs, periodIds);
        LOG.info("query_biz_happen on balance init cost: " + (System.currentTimeMillis() - balanceInitTick));
        long balanceTick = System.currentTimeMillis();
        Multimap<Long, Long> balanceData = AccountBizCheckUtil.checkBalanceHappen(orgAccMap, periodIds);
        LOG.info("query_biz_happen on balance cost: " + (System.currentTimeMillis() - balanceTick));
        long reciInitTick = System.currentTimeMillis();
        Multimap<Long, Long> reciInitData = AccountBizCheckUtil.checkReciInitHappen(accIds, orgs, periodIds);
        LOG.info("query_biz_happen on reciInit cost: " + (System.currentTimeMillis() - reciInitTick));
        long reciStateTick = System.currentTimeMillis();
        Multimap<Long, Long> reciStateData = AccountBizCheckUtil.reciStateHappen(accIds, orgs, periodIds);
        LOG.info("query_biz_happen on reciState cost: " + (System.currentTimeMillis() - reciStateTick));
        long voucherTick = System.currentTimeMillis();
        Multimap<Long, Long> voucherData = AccountBizCheckUtil.checkVoucherHappen(accIds, orgs, periodIds);
        LOG.info("query_biz_happen on voucher cost: " + (System.currentTimeMillis() - voucherTick));
        HashBasedTable result = HashBasedTable.create();
        for (Map.Entry<Long, Set<Long>> orgEntry : orgAccMap.entrySet()) {
            Long orgId = orgEntry.getKey();
            for (Long accountId : orgEntry.getValue()) {
                Integer bizType = BizType.NONE.value;
                if (balanceInitData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.BALANCE_INIT.value;
                }
                if (balanceData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.BALANCE.value;
                }
                if (reciInitData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.RECIINIT.value;
                }
                if (reciStateData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.RECISTATE.value;
                }
                if (voucherData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.VOUCHER.value;
                }
                result.put((Object)orgId, (Object)accountId, (Object)bizType);
            }
        }
        LOG.info(String.format("query_biz_happen on %s on date: %s cost: %s", SerializationUtils.toJsonString(orgAccMap), DateFormatUtils.format((Date)specificDate, (String)"yyyy-MM-dd"), System.currentTimeMillis() - tick));
        return result;
    }

    public static Multimap<Long, Long> checkBalanceInitHappen(Set<Long> acctIds, Set<Long> orgIds, Set<Long> periodIds) {
        int i;
        if (CollectionUtils.isEmpty(acctIds)) {
            return LinkedListMultimap.create();
        }
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(8);
        DynamicObjectCollection bookColl = null;
        if (!CollectionUtils.isEmpty(periodIds)) {
            QFilter qperiod = new QFilter("startperiod", "in", periodIds);
            qfs.add(qperiod);
        }
        if ((bookColl = CollectionUtils.isEmpty(orgIds) ? QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype", qfs.isEmpty() ? null : qfs.toArray(new QFilter[0])) : BatchProcessUtil.batchQueryDynColl(orgIds, batchOrgs -> {
            qfs.add(new QFilter("org", "in", (Object)batchOrgs.toArray()));
            return QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype", (QFilter[])qfs.toArray(new QFilter[0]));
        })) == null) {
            return LinkedListMultimap.create();
        }
        HashMap<Long, Set> orgBooktypes = new HashMap<Long, Set>(bookColl.size());
        for (DynamicObject book : bookColl) {
            orgBooktypes.computeIfAbsent(book.getLong("org"), k -> new HashSet()).add(book.getLong("bookstype"));
        }
        if (orgBooktypes.isEmpty()) {
            return LinkedListMultimap.create();
        }
        StringBuilder sql = new StringBuilder("select distinct faccountid,forgid,fbooktypeid from t_gl_initbalance where fisdeleted = '0' and faccountid in (");
        ArrayList<Long> params = new ArrayList<Long>(acctIds.size() + orgBooktypes.size());
        for (i = 0; i < acctIds.size(); ++i) {
            sql.append(i > 0 ? ",?" : "?");
        }
        params.addAll(acctIds);
        sql.append(") ");
        if (!orgBooktypes.isEmpty()) {
            sql.append(" AND forgid IN (");
            i = 0;
            HashSet allbooktypes = new HashSet(orgBooktypes.size());
            for (Map.Entry orgBooktypesEntry : orgBooktypes.entrySet()) {
                sql.append(i > 0 ? ",?" : "?");
                ++i;
                params.add((Long)orgBooktypesEntry.getKey());
                allbooktypes.addAll((Collection)orgBooktypesEntry.getValue());
            }
            sql.append(")");
            i = 0;
            sql.append(" AND fbooktypeid IN (");
            for (Long booktype : allbooktypes) {
                sql.append(i > 0 ? ",?" : "?");
                ++i;
                params.add(booktype);
            }
            sql.append(")");
        }
        LinkedListMultimap result = LinkedListMultimap.create();
        DataSet dataSet = DB.queryDataSet((String)AccountBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql.toString(), (Object[])params.toArray());
        Iterator iterator = null;
        try {
            for (Row row : dataSet) {
                long orgId = row.getLong("forgid");
                long accId = row.getLong("faccountid");
                result.put((Object)orgId, (Object)accId);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (iterator != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return result;
    }

    public static Multimap<Long, Long> checkReciInitHappen(Set<Long> acctIds, Set<Long> orgIds, Set<Long> periodIds) {
        DataSet dataSet;
        if (CollectionUtils.isEmpty(acctIds)) {
            return LinkedListMultimap.create();
        }
        LinkedListMultimap result = LinkedListMultimap.create();
        if (CollectionUtils.isEmpty(orgIds)) {
            SqlBuilder sql = new SqlBuilder();
            sql.append(" SELECT b.faccountid, b.forgid FROM t_gl_initacccurrent b inner join t_gl_reci_init_state c on b.forgid=c.forgid ", new Object[0]).append(" and b.fbooktypeid=c.fbooktypeid and b.faccountid=c.faccountid WHERE ", new Object[0]);
            sql.appendIn(" b.faccountid ", acctIds.toArray());
            if (!CollectionUtils.isEmpty(periodIds)) {
                sql.appendIn(" AND c.fendinitperiod ", periodIds.toArray());
            }
            sql.append(" group by b.faccountid, b.forgid ", new Object[0]);
            dataSet = DB.queryDataSet((String)AccountBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
        } else {
            dataSet = BatchProcessUtil.batchQueryDataSet(orgIds, batchOrgs -> {
                SqlBuilder sql = new SqlBuilder();
                sql.append(" SELECT b.faccountid, b.forgid FROM t_gl_initacccurrent b inner join t_gl_reci_init_state c on b.forgid=c.forgid ", new Object[0]).append(" and b.fbooktypeid=c.fbooktypeid and b.faccountid=c.faccountid WHERE ", new Object[0]);
                sql.appendIn(" b.faccountid ", acctIds.toArray());
                sql.appendIn(" AND b.forgid ", batchOrgs.toArray());
                if (!CollectionUtils.isEmpty((Collection)periodIds)) {
                    sql.appendIn(" AND c.fendinitperiod ", periodIds.toArray());
                }
                sql.append(" group by b.faccountid, b.forgid ", new Object[0]);
                return DB.queryDataSet((String)AccountBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
            });
        }
        for (Row row : dataSet) {
            long orgId = row.getLong("forgid");
            long accId = row.getLong("faccountid");
            result.put((Object)orgId, (Object)accId);
        }
        return result;
    }

    public static Multimap<Long, Long> reciStateHappen(Set<Long> acctIds, Set<Long> orgIds, Set<Long> periodIds) {
        DataSet dataSet;
        if (CollectionUtils.isEmpty(acctIds)) {
            return LinkedListMultimap.create();
        }
        LinkedListMultimap result = LinkedListMultimap.create();
        if (CollectionUtils.isEmpty(orgIds)) {
            SqlBuilder sql = new SqlBuilder();
            sql.append(" SELECT faccountid, forgid FROM t_gl_reci_init_state WHERE ", new Object[0]);
            sql.appendIn(" faccountid ", acctIds.toArray());
            if (!CollectionUtils.isEmpty(periodIds)) {
                sql.appendIn(" AND fendinitperiod ", periodIds.toArray());
            }
            sql.append(" group by faccountid, forgid ", new Object[0]);
            dataSet = DB.queryDataSet((String)AccountBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
        } else {
            dataSet = BatchProcessUtil.batchQueryDataSet(orgIds, batchOrgs -> {
                SqlBuilder sql = new SqlBuilder();
                sql.append(" SELECT faccountid, forgid FROM t_gl_reci_init_state WHERE ", new Object[0]);
                sql.appendIn(" faccountid ", acctIds.toArray());
                sql.appendIn(" AND forgid ", batchOrgs.toArray());
                if (!CollectionUtils.isEmpty((Collection)periodIds)) {
                    sql.appendIn(" AND fendinitperiod ", periodIds.toArray());
                }
                sql.append(" group by faccountid, forgid ", new Object[0]);
                return DB.queryDataSet((String)AccountBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
            });
        }
        for (Row row : dataSet) {
            long orgId = row.getLong("forgid");
            long accId = row.getLong("faccountid");
            result.put((Object)orgId, (Object)accId);
        }
        return result;
    }

    public static Multimap<Long, Long> checkBalanceHappen(Map<Long, Set<Long>> orgAccMap, Set<Long> periodIds) {
        Set allAccIds = orgAccMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(allAccIds)) {
            return LinkedListMultimap.create();
        }
        HashMap masterIdAccIdsMap = new HashMap(8);
        QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter("id", "in", allAccIds).toArray()).stream().forEach(x -> {
            long masterId = x.getLong("masterid");
            masterIdAccIdsMap.putIfAbsent(masterId, new HashSet(8));
            ((Set)masterIdAccIdsMap.get(masterId)).add(x.getLong("id"));
        });
        Set<Long> orgIds = orgAccMap.keySet();
        DataSet dataSet = BatchProcessUtil.batchQueryDataSet(orgIds, batchOrgs -> {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select faccountid masterid, forgid FROM t_gl_balance where", new Object[0]);
            sqlBuilder.appendIn(" faccountid", new ArrayList(masterIdAccIdsMap.keySet()));
            sqlBuilder.appendIn(" and forgid", new ArrayList(batchOrgs));
            if (!CollectionUtils.isEmpty((Collection)periodIds)) {
                sqlBuilder.appendIn(" and fperiodid", new ArrayList(periodIds));
            }
            return DB.queryDataSet((String)AccountBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        });
        LinkedListMultimap result = LinkedListMultimap.create();
        for (Row row : dataSet) {
            long orgId = row.getLong("forgid");
            Set ownAccIds = orgAccMap.getOrDefault(orgId, new HashSet(8));
            long masterId = row.getLong("masterid");
            HashSet accIds = new HashSet(masterIdAccIdsMap.getOrDefault(masterId, new HashSet(8)));
            accIds.retainAll(ownAccIds);
            if (CollectionUtils.isEmpty(accIds)) continue;
            accIds.stream().forEach(arg_0 -> AccountBizCheckUtil.lambda$checkBalanceHappen$9((Multimap)result, orgId, arg_0));
        }
        return result;
    }

    public static Multimap<Long, Long> checkVoucherHappen(Set<Long> acctIds, Set<Long> orgIds, Set<Long> periodIds) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(acctIds) ? 1 : 0) != 0);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(orgIds) ? 1 : 0) != 0);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(periodIds) ? 1 : 0) != 0);
        if (CollectionUtils.isEmpty(acctIds)) {
            return LinkedListMultimap.create();
        }
        LinkedListMultimap result = LinkedListMultimap.create();
        try (DataSet ds = BatchProcessUtil.batchQueryDataSet(orgIds, batchOrgs -> QueryServiceHelper.queryDataSet((String)AccountBizCheckUtil.class.getName(), (String)"gl_voucher", (String)"org,entries.account account", (QFilter[])new QFilter[]{new QFilter("org.id", "in", batchOrgs), new QFilter("period.id", "in", (Object)periodIds), new QFilter("entries.account.id", "in", (Object)acctIds)}, null)).groupBy(new String[]{"org", "account"}).finish();){
            for (Row row : ds) {
                long orgId = row.getLong("org");
                long accId = row.getLong("account");
                result.put((Object)orgId, (Object)accId);
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$checkBalanceHappen$9(Multimap result, long orgId, Long x) {
        result.put((Object)orgId, (Object)x);
    }

    public static enum BizType {
        NONE(0),
        BALANCE_INIT(1),
        BALANCE(2),
        RECIINIT(4),
        VOUCHER(8),
        BALANCE_LOG(16),
        RECISTATE(32);

        private int value;

        private BizType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getDesc() {
            switch (this.value) {
                case 0: {
                    return ResManager.loadKDString((String)"\u65e0\u4e1a\u52a1\u53d1\u751f", (String)"BizType_0", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 1: {
                    return ResManager.loadKDString((String)"\u4f59\u989d\u521d\u59cb\u5316", (String)"BizType_1", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 2: {
                    return ResManager.loadKDString((String)"\u4f59\u989d", (String)"BizType_2", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 4: {
                    return ResManager.loadKDString((String)"\u5f80\u6765\u521d\u59cb\u5316", (String)"BizType_4", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 8: {
                    return ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"BizType_8", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 32: {
                    return ResManager.loadKDString((String)"\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316\u72b6\u6001", (String)"BizType_32", (String)"fi-bd-common", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public static BizType getBizType(int value) {
            BizType[] values;
            for (BizType bizType : values = BizType.values()) {
                if (bizType.value != value) continue;
                return bizType;
            }
            throw new IllegalStateException("invalid BizType value:" + value);
        }

        public static boolean containType(int value, BizType type) {
            return (value & type.value) == type.value;
        }

        public static Set<BizType> withTypes(int value) {
            return Arrays.stream(BizType.values()).filter(x -> NONE != x).filter(x -> x.isIn(value)).collect(Collectors.toSet());
        }

        public boolean isIn(int value) {
            return (value & this.value) == this.value;
        }
    }
}

