/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AccountDataMutexUtil {
    private static Log logger = LogFactory.getLog(AccountDataMutexUtil.class);
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MUTEX_DATAOBJID = "dataObjId";
    private static final String MUTEX_GROUPID = "groupId";
    private static final String MUTEX_ENTITYKEY = "entityKey";
    private static final String MUTEX_OPERATIONKEY = "operationKey";
    private static final String MUTEX_ISSTRICT = "isStrict";

    public static Map<Long, String> requireMutex(String entityKey, Set<Long> billids) {
        HashMap<Long, String> returnMsg = new HashMap<Long, String>(billids.size());
        boolean isStrict = true;
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityKey;
        ArrayList mutexRequireList = new ArrayList(billids.size());
        for (Long l : billids) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(MUTEX_DATAOBJID, l.toString());
            requireParam.put(MUTEX_GROUPID, netGroupId);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, "modify");
            requireParam.put(MUTEX_ISSTRICT, isStrict);
            mutexRequireList.add(requireParam);
        }
        try {
            Throwable throwable = null;
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    Long ID = Long.valueOf(objId);
                    if (ret.booleanValue()) continue;
                    Map lockInfo = dataMutex.getLockInfo(objId, netGroupId, entityKey);
                    StringBuilder sb = new StringBuilder();
                    if (lockInfo != null) {
                        Long timeL;
                        String timeStr;
                        DynamicObject userObj;
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"AccountDataMutexUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
                        Long userid = Long.valueOf((String)lockInfo.get("userid"));
                        if (userid != null && (userObj = BusinessDataServiceHelper.loadSingle((Object)userid, (String)"bos_user")) != null) {
                            sb.append(userObj.getString("name"));
                        }
                        if ((timeStr = (String)lockInfo.get("lockedTime")) != null && (timeL = Long.valueOf(Long.parseLong(timeStr))) != null) {
                            sb.append(ResManager.loadKDString((String)"\u5728", (String)"AccountDataMutexUtil_1", (String)"fi-bd-common", (Object[])new Object[0])).append(timesdf.format(new Date(timeL)));
                        }
                        sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"AccountDataMutexUtil_2", (String)"fi-bd-common", (Object[])new Object[0]));
                    } else {
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a", (String)"AccountDataMutexUtil_3", (String)"fi-bd-common", (Object[])new Object[0]));
                    }
                    returnMsg.put(ID, sb.toString());
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            ErrorCode errorCode = new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:", (String)"AccountDataMutexUtil_4", (String)"fi-bd-common", (Object[])new Object[0]));
            throw new KDException((Throwable)e, errorCode, new Object[0]);
        }
        return returnMsg;
    }

    public static Set<Object> requireMutex(Set<Object> billids, String entityKey) {
        HashSet<Object> lockIDs = new HashSet<Object>();
        boolean isStrict = true;
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityKey;
        ArrayList mutexRequireList = new ArrayList(billids.size());
        for (Object billid : billids) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(MUTEX_DATAOBJID, billid.toString());
            requireParam.put(MUTEX_GROUPID, netGroupId);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, "modify");
            requireParam.put(MUTEX_ISSTRICT, isStrict);
            mutexRequireList.add(requireParam);
        }
        lockIDs.clear();
        try {
            Object billid;
            DataMutex dataMutex = DataMutex.create();
            billid = null;
            try {
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    Long ID = Long.valueOf(objId);
                    if (ret.booleanValue()) {
                        lockIDs.add(ID);
                        continue;
                    }
                    Map lockInfo = dataMutex.getLockInfo(objId, netGroupId, entityKey);
                    StringBuilder sb = new StringBuilder();
                    if (lockInfo != null) {
                        Long timeL;
                        String timeStr;
                        DynamicObject userObj;
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"AccountDataMutexUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
                        Long userid = Long.valueOf((String)lockInfo.get("userid"));
                        if (userid != null && (userObj = BusinessDataServiceHelper.loadSingle((Object)userid, (String)"bos_user")) != null) {
                            sb.append(userObj.getString("name"));
                        }
                        if ((timeStr = (String)lockInfo.get("lockedTime")) != null && (timeL = Long.valueOf(Long.parseLong(timeStr))) != null) {
                            sb.append(ResManager.loadKDString((String)"\u5728", (String)"AccountDataMutexUtil_1", (String)"fi-bd-common", (Object[])new Object[0])).append(timesdf.format(new Date(timeL)));
                        }
                        sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"AccountDataMutexUtil_2", (String)"fi-bd-common", (Object[])new Object[0]));
                        continue;
                    }
                    sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a", (String)"AccountDataMutexUtil_3", (String)"fi-bd-common", (Object[])new Object[0]));
                }
            }
            catch (Throwable throwable) {
                billid = throwable;
                throw throwable;
            }
            finally {
                if (dataMutex != null) {
                    if (billid != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)billid).addSuppressed(throwable);
                        }
                    } else {
                        dataMutex.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:", (String)"AccountDataMutexUtil_4", (String)"fi-bd-common", (Object[])new Object[0]));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        return lockIDs;
    }

    public static void batchRelease(String entityNumber, Set<Long> lockIDs) {
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityNumber;
        if (!lockIDs.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIDs.size());
            for (Long lockID : lockIDs) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(MUTEX_DATAOBJID, lockID.toString());
                requireParam.put(MUTEX_GROUPID, netGroupId);
                requireParam.put(MUTEX_ENTITYKEY, entityNumber);
                requireParam.put(MUTEX_OPERATIONKEY, "modify");
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + objId + "]\u4e92\u65a5\u9501\u5931\u8d25.");
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519", (String)"AccountDataMutexUtil_5", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    public static void batchReleaseForScheme(Set<Object> lockIDs, String entityNumber) {
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityNumber;
        if (!lockIDs.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIDs.size());
            for (Object lockID : lockIDs) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(MUTEX_DATAOBJID, lockID.toString());
                requireParam.put(MUTEX_GROUPID, netGroupId);
                requireParam.put(MUTEX_ENTITYKEY, entityNumber);
                requireParam.put(MUTEX_OPERATIONKEY, "modify");
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + objId + "]\u4e92\u65a5\u9501\u5931\u8d25.");
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519", (String)"AccountDataMutexUtil_5", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
            }
        }
    }
}

