/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.ThreadLocals;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.util.filter.QFilterBuilder;

public class AccountUtils {
    private static final Log logger = LogFactory.getLog(AccountUtils.class);
    private static final ThreadLocal<Map<Long, String>> ORG_FILTER_THL = ThreadLocals.create();
    private static final QFilter LEAF_FILTER = new QFilter("isleaf", "=", (Object)Character.valueOf('1'));

    private AccountUtils() {
    }

    public static List<Long> getLeafAccountIds(long orgId, long accountTableId, Date date) {
        return AccountUtils.getAccountIds(orgId, accountTableId, date, LEAF_FILTER);
    }

    public static List<Long> getAccountIds(long orgId, long accountTableId, Date date, QFilter customFilter) {
        return AccountUtils.getAccountDOs(orgId, accountTableId, date, customFilter, "id").stream().map(x -> x.getLong("id")).collect(Collectors.toList());
    }

    public static Set<Long> getAccountIdSet(long orgId, long accountTableId, Date date, QFilter customFilter) {
        return AccountUtils.getAccountDOs(orgId, accountTableId, date, customFilter, "id").stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
    }

    public static List<DynamicObject> getLeafAccountDOs(long orgId, long accountTableId, Date date, QFilter customFilter, String ... fields) {
        return AccountUtils.getAccountDOs(orgId, accountTableId, date, true, customFilter, fields);
    }

    public static List<DynamicObject> getLeafAccountDOs(long orgId, long accountTableId, Date date, String ... fields) {
        return AccountUtils.getLeafAccountDOs(orgId, accountTableId, date, null, fields);
    }

    public static List<DynamicObject> getAccountDOs(long orgId, long accountTableId, Date date, QFilter customFilter, String ... fields) {
        return AccountUtils.getAccountDOs(orgId, accountTableId, date, false, customFilter, fields);
    }

    @Deprecated
    public static List<DynamicObject> getAccountDOs(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        QFBuilder qfBuilder = AccountUtils.getAccountFilter(orgId, accountTableId, date, isOnlyLeaf, customFilter);
        if (DebugTrace.enable()) {
            logger.info("getAccountDOs getAccountFilter : {} ", (Object)DebugTraceHelper.toString(qfBuilder));
        }
        if (Objects.isNull(fields) || fields.length == 0) {
            return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (QFilter[])qfBuilder.toArray()).values());
        }
        DynamicObject[] accountDOs = BusinessDataServiceHelper.load((String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray());
        return Stream.of(accountDOs).collect(Collectors.toList());
    }

    @Deprecated
    public static DataSet getAccountDataSet(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        if (Objects.isNull(fields) || fields.length == 0) {
            fields = new String[]{"id"};
        }
        QFBuilder qfBuilder = new QFBuilder();
        if (Objects.isNull(date)) {
            qfBuilder.add("enddate", "=", AccountVersionUtil.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", date);
            qfBuilder.add("enddate", ">", date);
        }
        qfBuilder.add("enable", "=", "1");
        if (!Objects.isNull(customFilter)) {
            qfBuilder.add(customFilter);
        }
        if (isOnlyLeaf) {
            qfBuilder.add(LEAF_FILTER);
        }
        return AccountUtils.queryAccountDataSet(orgId, accountTableId, String.join((CharSequence)",", fields), qfBuilder.toList(), "id");
    }

    @Deprecated
    public static QFBuilder getAccountFilter(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter) {
        QFBuilder qfBuilder = new QFBuilder();
        if (Objects.isNull(date)) {
            qfBuilder.add("enddate", "=", AccountVersionUtil.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", date);
            qfBuilder.add("enddate", ">", date);
        }
        qfBuilder.add("enable", "=", "1");
        if (!Objects.isNull(customFilter)) {
            qfBuilder.add(customFilter);
        }
        if (isOnlyLeaf) {
            qfBuilder.add(LEAF_FILTER);
        }
        QFilter accountDataFilter = AccountUtils.getAccountDataFilter(orgId, accountTableId, qfBuilder.toList());
        qfBuilder = new QFBuilder();
        qfBuilder.add(accountDataFilter);
        return qfBuilder;
    }

    @Deprecated
    public static QFilter getBaseDataFilter(long orgId) {
        Map<Long, String> filterMap = ORG_FILTER_THL.get();
        if (filterMap == null) {
            filterMap = new HashMap<Long, String>(1);
            ORG_FILTER_THL.set(filterMap);
        }
        String filterStr = filterMap.computeIfAbsent(orgId, k -> SerializationUtils.serializeToBase64((Object)BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId)));
        return (QFilter)SerializationUtils.deSerializeFromBase64((String)filterStr);
    }

    public static QFilter getAccountDataFilter(long orgId, long accountTableId) {
        return new QFilter("id", "in", AccountUtils.queryAccountIds(orgId, accountTableId, null));
    }

    public static QFilter getAccountDataFilter(long orgId, long accountTableId, List<QFilter> filters) {
        return new QFilter("id", "in", AccountUtils.queryAccountIds(orgId, accountTableId, filters));
    }

    public static QFilter getAccountDataFilter(Set<Long> orgIds, long accountTableId) {
        return AccountUtils.getAccountDataFilter(orgIds, accountTableId, null);
    }

    public static QFilter getAccountDataFilter(Set<Long> orgIds, long accountTableId, List<QFilter> filters) {
        return new QFilter("id", "in", AccountUtils.queryAccountIds(orgIds, accountTableId, filters));
    }

    public static boolean existUseRangeAccountByOrg(long orgId, long accountTableId, List<QFilter> otherFilters) {
        HashSet<Long> orgIds = new HashSet<Long>(1);
        orgIds.add(orgId);
        return AccountUtils.existUseRangeAccountByOrg(orgIds, accountTableId, otherFilters);
    }

    public static boolean existUseRangeAccountByOrg(Set<Long> orgIds, long accountTableId, List<QFilter> otherFilters) {
        if (Objects.isNull(orgIds) || orgIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountUtils_1", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        ArrayList<QFilter> globalShareFilters = new ArrayList<QFilter>(10);
        if (Objects.nonNull(otherFilters) && !otherFilters.isEmpty()) {
            globalShareFilters.addAll(otherFilters);
        }
        globalShareFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        globalShareFilters.add(new QFilter("ctrlstrategy", "=", (Object)"5"));
        globalShareFilters.add(new QFilter("status", "=", (Object)"C"));
        boolean exists = QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])globalShareFilters.toArray(new QFilter[0]));
        if (exists) {
            return exists;
        }
        ArrayList<QFilter> useRangeFilters = new ArrayList<QFilter>(10);
        if (Objects.nonNull(otherFilters) && !otherFilters.isEmpty()) {
            useRangeFilters.addAll(otherFilters);
        }
        useRangeFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        useRangeFilters.add(QFilter.joinSQL((String)"bd_accountview", (String)("inner join t_bd_account_u u on u.fdataid=bd_accountview.fid and u.fuseorgid in " + QFilterBuilder.buildSQLParamHolder(orgIds.size())), (Object[])orgIds.toArray()));
        return QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])useRangeFilters.toArray(new QFilter[0]));
    }

    public static Set<Long> queryAccountIds(long orgId, long accountTableId, List<QFilter> filters) {
        HashSet<Long> orgIds = new HashSet<Long>(1);
        orgIds.add(orgId);
        return AccountUtils.queryAccountIds(orgIds, accountTableId, filters);
    }

    public static Set<Long> queryAccountIds(Set<Long> orgIds, long accountTableId, List<QFilter> filters) {
        if (Objects.isNull(orgIds) || orgIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountUtils_1", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        ArrayList<QFilter> globalShareFilters = new ArrayList<QFilter>(10);
        ArrayList<QFilter> useRangeFilters = new ArrayList<QFilter>(10);
        if (Objects.nonNull(filters) && !filters.isEmpty()) {
            globalShareFilters.addAll(filters);
            useRangeFilters.addAll(filters);
        }
        globalShareFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        globalShareFilters.add(new QFilter("ctrlstrategy", "=", (Object)"5"));
        globalShareFilters.add(new QFilter("status", "=", (Object)"C"));
        useRangeFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        useRangeFilters.add(QFilter.joinSQL((String)"bd_accountview", (String)("inner join t_bd_account_u u on u.fdataid=bd_accountview.fid and u.fuseorgid in " + QFilterBuilder.buildSQLParamHolder(orgIds.size())), (Object[])orgIds.toArray()));
        HashSet<Long> accountIds = new HashSet<Long>(10);
        DataSet globalShareDataSet = QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)"id", (QFilter[])globalShareFilters.toArray(new QFilter[0]), null);
        for (Row row : globalShareDataSet) {
            accountIds.add(row.getLong("id"));
        }
        DataSet useRangeDataSet = QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)"id", (QFilter[])useRangeFilters.toArray(new QFilter[0]), null);
        for (Row row : useRangeDataSet) {
            accountIds.add(row.getLong("id"));
        }
        return accountIds;
    }

    public static DataSet queryAccountDataSet(long orgId, long accountTableId, String selectFields, List<QFilter> otherFilters) {
        return AccountUtils.queryAccountDataSet(orgId, accountTableId, selectFields, otherFilters, null);
    }

    public static DataSet queryAccountDataSet(long orgId, long accountTableId, String selectFields, List<QFilter> otherFilters, String orderBys) {
        HashSet<Long> orgIds = new HashSet<Long>(1);
        orgIds.add(orgId);
        return AccountUtils.queryAccountDataSet(orgIds, accountTableId, selectFields, otherFilters, orderBys);
    }

    public static DataSet queryAccountDataSet(Set<Long> orgIds, long accountTableId, String selectFields, List<QFilter> otherFilters, String orderBys) {
        if (Objects.isNull(selectFields) || selectFields.length() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountUtils_2", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        Set<Long> accountIds = AccountUtils.queryAccountIds(orgIds, accountTableId, otherFilters);
        DataSet accountDataSet = null;
        for (List idList : Lists.partition(new ArrayList<Long>(accountIds), (int)1999)) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)}, null);
            if (null == accountDataSet) {
                accountDataSet = dataSet;
                continue;
            }
            accountDataSet = accountDataSet.union(dataSet);
        }
        if (null != accountDataSet && StringUtils.isNotEmpty((CharSequence)orderBys)) {
            accountDataSet = accountDataSet.orderBy(orderBys.split(","));
        }
        if (null == accountDataSet) {
            accountDataSet = Algo.create((String)AccountUtils.class.getName()).createDataSet(Collections.emptyIterator(), new RowMeta(new Field[0]));
        }
        return accountDataSet;
    }

    public static Set<Long> getSuperAccIds(long orgId, Set<String> numbers, Long accountableId, Date endDate) {
        HashSet superNumbers = new HashSet(16);
        numbers.forEach(v -> {
            String[] split = v.split("_");
            superNumbers.addAll(Arrays.asList(split));
        });
        QFilter atFilter = new QFilter("startdate", "<=", (Object)endDate);
        atFilter.and(new QFilter("enddate", ">=", (Object)endDate));
        atFilter.and(new QFilter("number", "in", superNumbers));
        return AccountUtils.queryAccountIds(orgId, (long)accountableId, Collections.singletonList(atFilter));
    }

    @Deprecated
    public static Map<Long, DynamicObject> loadAccounts(long orgId, long accttableId, boolean onlyLeaf, List<QFilter> filters, String[] fields) {
        if (onlyLeaf) {
            filters.add(LEAF_FILTER);
        }
        Set<Long> ids = AccountUtils.queryAccountIds(orgId, accttableId, filters);
        QFilter fids = new QFilter("id", "in", ids);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{fids});
        Map<Long, DynamicObject> map = result.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        return map;
    }

    public static DataSet getAllLeafAcct(Set<String> numbers, Long endPeriod, Long pOrg, Long accountableId) {
        HashSet<Long> ids = new HashSet<Long>(100);
        QFilter atFilter = AccountUtils.getBaseAcctFilter(endPeriod, pOrg, accountableId, null, null);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAcctLongNumber"), (String)"bd_accountview", (String)"id,longnumber", (QFilter[])atFilter.toArray(), null);){
            for (Row row : dataSet) {
                String[] split;
                String longnumber = row.getString("longnumber");
                for (String s : split = longnumber.split("_")) {
                    if (!numbers.contains(s)) continue;
                    ids.add(row.getLong("id"));
                }
            }
            QFilter filter = new QFilter("id", "in", ids);
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAllLeafAcct"), (String)"bd_accountview", (String)"id,masterid,parent.id parent,parent.number pnum,number,level,isleaf,dc,isassist,isqty", (QFilter[])filter.toArray(), null);
            return dataSet2;
        }
    }

    public static QFilter getBaseAcctFilter(Long endPeriod, Long orgId, Long accountableId, Set<Long> masterIdSet, List<Long> accountList) {
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)endPeriod).toArray());
        QFilter atFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        atFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        atFilter.and(AccountUtils.getAccountDataFilter(orgId, (long)accountableId));
        if (null != masterIdSet) {
            atFilter.and(new QFilter("id", "in", accountList));
        }
        return atFilter;
    }

    public static Set<Long> queryHistoryAcctIds(long orgId, long accountTableId, Date startDate, Date endDate) {
        String selectFields = "a.fid";
        DataSet acctHisDataSet = AccountUtils.queryHistoryAcct(orgId, accountTableId, startDate, endDate, selectFields, null);
        HashSet<Long> actIds = new HashSet<Long>(16);
        for (Row row : acctHisDataSet) {
            actIds.add(row.getLong("fid"));
        }
        return actIds;
    }

    public static DataSet queryHistoryAcct(long orgId, long accountTableId, Date startDate, Date endDate, String selectFields, SqlBuilder sql) {
        SqlBuilder shareSql = new SqlBuilder();
        shareSql.append("SELECT ", new Object[0]).append(selectFields, new Object[0]);
        shareSql.append(" FROM t_bd_account a where a.fctrlstrategy = '5' AND a.fstatus = 'C' ", new Object[0]);
        shareSql.append(" and a.faccounttableid = ?", new Object[]{accountTableId});
        shareSql.append(" and a.fstartdate < ? ", new Object[]{endDate});
        shareSql.append(" and a.fenddate >= ? ", new Object[]{startDate});
        shareSql.appendSqlBuilder(sql);
        DataSet shareDataSet = DB.queryDataSet((String)AccountUtils.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)shareSql);
        SqlBuilder createSql = new SqlBuilder();
        createSql.append("SELECT ", new Object[0]).append(selectFields, new Object[0]);
        createSql.append(" from t_bd_account a where ", new Object[0]);
        createSql.append(" a.faccounttableid = ?", new Object[]{accountTableId});
        createSql.append(" and a.fcreateorgid = ?", new Object[]{orgId});
        createSql.append(" and a.fstartdate < ? ", new Object[]{endDate});
        createSql.append(" and a.fenddate >= ? ", new Object[]{startDate});
        createSql.appendSqlBuilder(sql);
        DataSet createDataSet = DB.queryDataSet((String)AccountUtils.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)createSql);
        SqlBuilder useregSql = new SqlBuilder();
        useregSql.append("SELECT ", new Object[0]).append(selectFields, new Object[0]);
        useregSql.append(" FROM t_bd_accountusereg as u inner join t_Bd_account as a on a.fid=u.fdataid  where ", new Object[0]);
        useregSql.append(" a.faccounttableid = ?", new Object[]{accountTableId});
        useregSql.append(" and u.fuseorgid = ?", new Object[]{orgId});
        useregSql.append(" and a.fstartdate < ? ", new Object[]{endDate});
        useregSql.append(" and a.fenddate >= ? ", new Object[]{startDate});
        useregSql.appendSqlBuilder(sql);
        DataSet useregDataSet = DB.queryDataSet((String)AccountUtils.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)useregSql);
        return shareDataSet.union(createDataSet).union(useregDataSet).distinct();
    }
}

