/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.DebugTrace;
import org.apache.commons.lang3.StringUtils;

public class AccountVersionControlChecker {
    private static final String CACHE_KEY_CHECKED_ACC_PAIR = AccountVersionControlChecker.class.getName() + "/checkedAccPairs";
    private static Log logger = LogFactory.getLog(AccountVersionControlChecker.class);
    private static final String USED_PROPS = String.join((CharSequence)",", Arrays.asList("id", "number", "name", "accounttable", "accrualdirection", "orgcontrollevel", "isallowca", "ismanual", "createorg", "iscash", "isbank", "iscashequivalent", "acnotice", "ischangecurrency", "isqty", "acctcurrency", "currencyentry", "currencyentry.currency", "dc", "asstactitem", "checkitementry.isrequire", "checkitementry.isdetail", "checkitementry.enaccheck", "asstactitem.flexfield"));

    public static Result checkAccountControl(DynamicObject newAcc, long operateOrgId, boolean forceLatestVersion, long processAccId, int checkTypes, int propTypes, OperateOption option) {
        DynamicObject parentAcc = AccountVersionUtil.getParentAcct(newAcc, operateOrgId, Optional.of(USED_PROPS), forceLatestVersion);
        return AccountVersionControlChecker.checkAccountControl(newAcc, Optional.ofNullable(parentAcc), operateOrgId, new DefaultOrgAccountFunction(), forceLatestVersion, processAccId, checkTypes, propTypes, option);
    }

    public static Result checkAccountControl(DynamicObject newAcc, long operateOrgId, RetrieveOrgAccountFunction accountVersionRetrieveFunc, boolean forceLatestVersion, long processAccId, int checkTypes, int propTypes, OperateOption option) {
        DynamicObject parentAcc = AccountVersionUtil.getParentAcct(newAcc, operateOrgId, Optional.of(USED_PROPS), forceLatestVersion);
        return AccountVersionControlChecker.checkAccountControl(newAcc, Optional.ofNullable(parentAcc), operateOrgId, accountVersionRetrieveFunc, forceLatestVersion, processAccId, checkTypes, propTypes, option);
    }

    public static Result checkAccountControl(DynamicObject newAcc, Optional<DynamicObject> newAccParent, long operateOrgId, boolean forceLatestVersion, long processAccId, int checkTypes, int propTypes, OperateOption option) {
        return AccountVersionControlChecker.checkAccountControl(newAcc, newAccParent, operateOrgId, new DefaultOrgAccountFunction(), forceLatestVersion, processAccId, checkTypes, propTypes, option);
    }

    public static Result checkAccountControl(DynamicObject newAcc, Optional<DynamicObject> newAccParent, long operateOrgId, RetrieveOrgAccountFunction accountVersionRetrieveFunc, boolean forceLatestVersion, long processAccId, int checkTypes, int propTypes, OperateOption option) {
        boolean isDelOperation;
        Result curAccCheckResult;
        long tick = System.currentTimeMillis();
        ThreadCache.put((Object)CACHE_KEY_CHECKED_ACC_PAIR, new HashSet(8));
        Set<Long> assignRawChildOrgIds = AccountVersionUtil.queryAssignedRawOrgIds(processAccId);
        Set<Long> childOrgIds = BDUtil.getAllChildrenOrgIds(operateOrgId, false);
        assignRawChildOrgIds.retainAll(childOrgIds);
        assignRawChildOrgIds.add(operateOrgId);
        if (DebugTrace.enable()) {
            logger.info(String.format("checkAccountControl assignRawChildOrgIds=%s", String.join((CharSequence)",", assignRawChildOrgIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet()))));
        }
        if (Status.SUCCESS != (curAccCheckResult = AccountVersionControlChecker.checkSpecificAccountControl(newAcc, newAccParent, operateOrgId, accountVersionRetrieveFunc, forceLatestVersion, processAccId, assignRawChildOrgIds, checkTypes, propTypes)).status) {
            return curAccCheckResult;
        }
        logger.info(String.format("checkAccountControl costcurAccCheckResult: %s on operateAcc:[%s][Org:%s], processAccId: %s", System.currentTimeMillis() - tick, newAcc.getString("number"), operateOrgId, processAccId));
        tick = System.currentTimeMillis();
        boolean isBatchAddingAssist = AccountVersionOpVars.isBatchAddingAssist(option);
        boolean bl = isDelOperation = newAcc.getLong("id") != processAccId;
        if (!isDelOperation && !isBatchAddingAssist && CheckType.ASSGIN_ACC.isIn(checkTypes)) {
            for (Long orgId : assignRawChildOrgIds) {
                DynamicObject parentAcc;
                Result assignAccCheckResult;
                if (operateOrgId == orgId || Status.SUCCESS == (assignAccCheckResult = AccountVersionControlChecker.checkSpecificAccountControl(newAcc, Optional.ofNullable(parentAcc = AccountVersionUtil.getParentAcct(newAcc, orgId, Optional.of(USED_PROPS), forceLatestVersion)), orgId, accountVersionRetrieveFunc, forceLatestVersion, processAccId, assignRawChildOrgIds, checkTypes, propTypes)).status) continue;
                return new Result(Status.ASSGIN_ACC_FAIL, assignAccCheckResult.getErrMsg());
            }
        }
        logger.info(String.format("checkAccountControl cost: %s on operateAcc:[%s][Org:%s], processAccId: %s", System.currentTimeMillis() - tick, newAcc.getString("number"), operateOrgId, processAccId));
        return Result.success();
    }

    private static boolean isChecked(long relativeChildAccId, long relativeChildOrgId, long relativeParentAccId, long relativeParentOrgId) {
        String key = String.format("%s_org:%s_%s_org:%s", relativeChildAccId, relativeChildOrgId, relativeParentAccId, relativeParentOrgId);
        Set checkAccCache = (Set)ThreadCache.get((Object)CACHE_KEY_CHECKED_ACC_PAIR);
        return checkAccCache.contains(key);
    }

    private static void addToCheckedList(long relativeChildAccId, long relativeChildOrgId, long relativeParentAccId, long relativeParentOrgId) {
        String key = String.format("%s_org:%s_%s_org:%s", relativeChildAccId, relativeChildOrgId, relativeParentAccId, relativeParentOrgId);
        Set checkAccCache = (Set)ThreadCache.get((Object)CACHE_KEY_CHECKED_ACC_PAIR);
        checkAccCache.add(key);
    }

    private static Result checkSpecificAccountControl(DynamicObject specificAcc, Optional<DynamicObject> specificAccParent, long operateOrgId, RetrieveOrgAccountFunction accountVersionRetrieveFunc, boolean forceLatestVersion, long processAccId, Set<Long> assignRawChildOrgIds, int checkTypes, int propTypes) {
        Map<String, Object> parentProp;
        DynamicObject[] errMsg;
        Preconditions.checkArgument((boolean)Objects.nonNull(accountVersionRetrieveFunc));
        long currentAccId = specificAcc.getLong("id");
        long currentAccMasterId = specificAcc.getLong("masterid");
        String accNumber = specificAcc.getString("number");
        String controlStrategy = specificAcc.getString("ctrlstrategy");
        logger.info(String.format("checkAccountControl.checkSpecificAccountControl on AccId: %s, AccMasterId: %s, Org: %s", currentAccId, currentAccMasterId, operateOrgId));
        Map<String, Object> prop = AccountVersionControlChecker.getAccountProp(specificAcc);
        if (CheckType.ACC_UP.isIn(checkTypes) && specificAccParent.isPresent() && (errMsg = AccountVersionControlChecker.validateAccountControlRelation(prop, parentProp = AccountVersionControlChecker.getAccountProp(specificAccParent.get()), propTypes)).isPresent()) {
            DynamicObject specificParentAcc = specificAccParent.get();
            String resultTip = (String)errMsg.get() + String.format(ResManager.loadKDString((String)"\u4e0e\u5f53\u524d\u7ec4\u7ec7\u7684(%1$s)\u7684'%2$s'\u79d1\u76ee\u4e0d\u6ee1\u8db3\u7ba1\u63a7\u5173\u7cfb\u3002", (String)"AccountVersionControlChecker_15", (String)"fi-bd-opplugin", (Object[])new Object[0]), specificParentAcc.getString("createorg.name") + "(" + specificParentAcc.getString("createorg.number") + ")", specificParentAcc.getString("number"));
            return new Result(Status.ACC_UP_FAIL, resultTip);
        }
        if (CheckType.ACC_DOWN.isIn(checkTypes)) {
            DynamicObject[] childAccs;
            for (DynamicObject childDy : childAccs = AccountVersionUtil.getChildAccts(specificAcc, operateOrgId, Optional.of(USED_PROPS), forceLatestVersion)) {
                if (AccountVersionControlChecker.isChecked(childDy.getLong("id"), operateOrgId, currentAccId, operateOrgId)) continue;
                Map<String, Object> childProp = AccountVersionControlChecker.getAccountProp(childDy);
                Optional<String> errMsg2 = AccountVersionControlChecker.validateAccountControlRelation(childProp, prop, propTypes);
                AccountVersionControlChecker.addToCheckedList(childDy.getLong("id"), operateOrgId, currentAccId, operateOrgId);
                if (!errMsg2.isPresent()) continue;
                String resultTip = errMsg2.get() + String.format(ResManager.loadKDString((String)"\u4e0e\u5f53\u524d\u7ec4\u7ec7\u7684(%1$s)\u7684'%2$s'\u79d1\u76ee\u4e0d\u6ee1\u8db3\u7ba1\u63a7\u5173\u7cfb\u3002", (String)"AccountVersionControlChecker_15", (String)"fi-bd-opplugin", (Object[])new Object[0]), childDy.getString("createorg.name") + "(" + childDy.getString("createorg.number") + ")", childDy.getString("number"));
                return new Result(Status.ACC_UP_FAIL, resultTip);
            }
        }
        if (!"6".equals(controlStrategy) && !"5".equals(controlStrategy)) {
            Map<Long, List<DynamicObject>> childOrgAccountsMap;
            Set<Long> childOrgIds;
            long superiorOrgId;
            Map<Long, DynamicObject> superiorOrgAccs;
            List superiorOrgs;
            if (CheckType.PARTENT_ORG.isIn(checkTypes) && !CollectionUtils.isEmpty((Collection)(superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)"10", (long)operateOrgId))) && !(superiorOrgAccs = accountVersionRetrieveFunc.apply(accNumber, currentAccMasterId, Collections.singleton(superiorOrgId = ((Long)superiorOrgs.get(0)).longValue()), processAccId)).isEmpty()) {
                Preconditions.checkState((superiorOrgAccs.size() == 1 ? 1 : 0) != 0);
                DynamicObject superAccDyn = superiorOrgAccs.values().iterator().next();
                long superAccId = superAccDyn.getLong("id");
                boolean isChecked = AccountVersionControlChecker.isChecked(currentAccId, operateOrgId, superAccId, superiorOrgId);
                BiPredicate<Long, Long> isSameAcc = (accId, useOrgId) -> accId.longValue() == specificAcc.getLong("id") && assignRawChildOrgIds.contains(useOrgId);
                boolean isSame = isSameAcc.test(superAccId, superiorOrgId);
                logger.info(String.format("checkAccountControl.checkSpecificAccountControl on super org acc validation: curAccId: %s, opOrgId: %s, superAccId: %s, superOrgId: %s: isChecked: %s, isSame: %s", currentAccId, operateOrgId, superAccId, superiorOrgId, isChecked, isSame));
                if (!isChecked && !isSame) {
                    Map<String, Object> superiorAccProp = AccountVersionControlChecker.getAccountProp(superAccId);
                    Optional<String> errMsg3 = AccountVersionControlChecker.validateAccountControlRelation(prop, superiorAccProp, propTypes);
                    AccountVersionControlChecker.addToCheckedList(currentAccId, operateOrgId, superAccId, superiorOrgId);
                    if (errMsg3.isPresent()) {
                        DynamicObject superiorOrg = BDUtil.getOrgById(superiorOrgId);
                        String resultTip = errMsg3.get() + String.format(ResManager.loadKDString((String)"\u4e0e'%1$s'\u7ec4\u7ec7\u7684'%2$s'\u79d1\u76ee\u4e0d\u6ee1\u8db3\u7ba1\u63a7\u5173\u7cfb\u3002", (String)"AccountVersionControlChecker_14", (String)"fi-bd-opplugin", (Object[])new Object[0]), superiorOrg.getString("name") + "(" + superiorOrg.getString("number") + ")", superAccDyn.getString("number"));
                        return new Result(Status.PARTENT_ORG_FAIL, resultTip);
                    }
                }
            }
            if (CheckType.CHILD_ORG.isIn(checkTypes) && !(childOrgIds = BDUtil.getAllChildrenOrgIds(operateOrgId, false)).isEmpty() && !(childOrgAccountsMap = AccountVersionUtil.checkChildOrgAccVersion(specificAcc, childOrgIds)).isEmpty()) {
                for (Map.Entry<Long, List<DynamicObject>> childOrgAccEntry : childOrgAccountsMap.entrySet()) {
                    long childOrgId = childOrgAccEntry.getKey();
                    List<DynamicObject> childOrgAccList = childOrgAccEntry.getValue();
                    for (DynamicObject childOrgAcc : childOrgAccList) {
                        long childAccId = childOrgAcc.getLong("id");
                        boolean isChecked = AccountVersionControlChecker.isChecked(childAccId, childOrgId, currentAccId, operateOrgId);
                        BiPredicate<Long, Long> isSameAcc = (accId, useOrgId) -> accId.longValue() == specificAcc.getLong("id") && assignRawChildOrgIds.contains(useOrgId) || accId == processAccId;
                        boolean isSame = isSameAcc.test(childAccId, childOrgId);
                        logger.info(String.format("checkAccountControl.checkSpecificAccountControl on child org acc validation: childAccId: %s, childOrgId: %s, currentAccId: %s, opOrgId: %s: isChecked: %s, isSame: %s", childAccId, childOrgId, currentAccId, operateOrgId, isChecked, isSame));
                        if (isSame || isChecked) continue;
                        Map<String, Object> childOrgAccProp = AccountVersionControlChecker.getAccountProp(childAccId);
                        Optional<String> errMsg4 = AccountVersionControlChecker.validateAccountControlRelation(childOrgAccProp, prop, propTypes);
                        AccountVersionControlChecker.addToCheckedList(childAccId, childOrgId, currentAccId, operateOrgId);
                        if (!errMsg4.isPresent()) continue;
                        DynamicObject childOrg = BDUtil.getOrgById(childOrgId);
                        String resultTip = errMsg4.get() + String.format(ResManager.loadKDString((String)"\u4e0e'%1$s'\u7ec4\u7ec7\u7684'%2$s'\u79d1\u76ee\u5728'%3$s'\u671f\u95f4\u4e0d\u6ee1\u8db3\u7ba1\u63a7\u5173\u7cfb\u3002", (String)"AccountVersionControlChecker_16", (String)"fi-bd-opplugin", (Object[])new Object[0]), childOrg.getString("name") + "(" + childOrg.getString("number") + ")", childOrgAcc.getString("number"), childOrgAcc.getString("startdate"));
                        return new Result(Status.CHILD_ORG_FAIL, resultTip);
                    }
                }
            }
        }
        return Result.success();
    }

    public static Optional<String> validateAccountControlRelation(Map<String, Object> relativeChildProp, Map<String, Object> relativeSuperProp, int propTypes) {
        StringBuilder msg = new StringBuilder();
        if (AccPropType.OTHERS.isIn(propTypes)) {
            if (!"nocontrol".equals(relativeSuperProp.get("accrualdirection")) && !relativeSuperProp.get("accrualdirection").equals(relativeChildProp.get("accrualdirection"))) {
                msg.append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u5f55\u5165\u65b9\u5411\u4e3a\u501f\u65b9\uff08\u8d37\u65b9\uff09\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u8d37\u65b9\uff08\u501f\u65b9\uff09\u6216\u4e0d\u63a7\u5236\u3002", (String)"AccountVersionControlChecker_1", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (Integer.parseInt(relativeChildProp.get("orgcontrollevel").toString()) < Integer.parseInt(relativeSuperProp.get("orgcontrollevel").toString())) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u63a7\u5236\u7ea7\u6b21\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0b\u7ea7\u79d1\u76ee\u63a7\u5236\u7ea7\u6b21\u3002", (String)"AccountVersionControlChecker_2", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (!((Boolean)relativeSuperProp.get("isallowca")).booleanValue() && ((Boolean)relativeChildProp.get("isallowca")).booleanValue()) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u516c\u53f8\u589e\u52a0\u4e0b\u7ea7\u79d1\u76ee\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u5141\u8bb8\u3002", (String)"AccountVersionControlChecker_3", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (!((Boolean)relativeSuperProp.get("ismanual")).booleanValue() && ((Boolean)relativeChildProp.get("ismanual")).booleanValue()) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u5141\u8bb8\u3002", (String)"AccountVersionControlChecker_4", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (((Boolean)relativeSuperProp.get("iscash")).booleanValue() != ((Boolean)relativeChildProp.get("iscash")).booleanValue() || ((Boolean)relativeSuperProp.get("isbank")).booleanValue() != ((Boolean)relativeChildProp.get("isbank")).booleanValue()) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u662f\u73b0\u91d1\u79d1\u76ee\uff08\u94f6\u884c\u79d1\u76ee\uff09\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e5f\u5fc5\u987b\u662f\u73b0\u91d1\u79d1\u76ee\uff08\u94f6\u884c\u79d1\u76ee\uff09\u3002", (String)"AccountVersionControlChecker_5", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (((Boolean)relativeSuperProp.get("iscashequivalent")).booleanValue() && !((Boolean)relativeChildProp.get("iscashequivalent")).booleanValue()) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0b\u7ea7\u79d1\u76ee\u672a\u52fe\u9009\u73b0\u91d1\u7b49\u4ef7\u7269\u5c5e\u6027\uff0c\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u52fe\u9009\u73b0\u91d1\u7b49\u4ef7\u7269\u5c5e\u6027\u3002", (String)"AccountVersionControlChecker_17", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (((Boolean)relativeSuperProp.get("acnotice")).booleanValue() && !((Boolean)relativeChildProp.get("acnotice")).booleanValue()) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u52fe\u9009\u5f80\u6765\u901a\u77e5\u5c5e\u6027\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u53d6\u6d88\u52fe\u9009\u3002", (String)"AccountVersionControlChecker_6", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (((Boolean)relativeSuperProp.get("ischangecurrency")).booleanValue() && !((Boolean)relativeChildProp.get("ischangecurrency")).booleanValue()) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u52fe\u9009\u671f\u672b\u8c03\u6c47\u5c5e\u6027\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u53d6\u6d88\u52fe\u9009\u3002", (String)"AccountVersionControlChecker_7", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (((Boolean)relativeSuperProp.get("isqty")).booleanValue() && !((Boolean)relativeChildProp.get("isqty")).booleanValue()) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u52fe\u9009\u6570\u91cf\u6838\u7b97\u5c5e\u6027\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u53d6\u6d88\u52fe\u9009\u3002", (String)"AccountVersionControlChecker_8", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if ("nocurrency".equals(relativeSuperProp.get("acctcurrency")) && !"nocurrency".equals(relativeChildProp.get("acctcurrency"))) {
                msg.append("##").append(ResManager.loadKDString((String)"\u4e0d\u6838\u7b97\u5916\u5e01\uff0c\u4e0a\u4e0b\u7ea7\u5fc5\u987b\u76f8\u540c\u3002", (String)"AccountVersionControlChecker_9", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if ("descurrency".equals(relativeSuperProp.get("acctcurrency")) && "allcurrency".equals(relativeChildProp.get("acctcurrency"))) {
                msg.append("##").append(ResManager.loadKDString((String)"\u6307\u5b9a\u6838\u7b97\u5e01\u79cd\uff0c\u5219\u4e0b\u7ea7\u4e0d\u80fd\u6539\u4e3a\u6838\u7b97\u6240\u6709\u5e01\u79cd\u3002", (String)"AccountVersionControlChecker_10", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if ("descurrency".equals(relativeSuperProp.get("acctcurrency"))) {
                DynamicObjectCollection parDycol = (DynamicObjectCollection)relativeSuperProp.get("currencyentry");
                DynamicObjectCollection subDycol = (DynamicObjectCollection)relativeChildProp.get("currencyentry");
                ArrayList<Long> parList = new ArrayList<Long>(parDycol.size());
                ArrayList<Long> subList = new ArrayList<Long>(subDycol.size());
                if (parDycol != null) {
                    for (DynamicObject parDy : parDycol) {
                        parList.add(parDy.getLong("currency_id"));
                    }
                }
                if (subDycol != null) {
                    for (DynamicObject subDy : subDycol) {
                        subList.add(subDy.getLong("currency_id"));
                    }
                }
                if (!parList.containsAll(subList)) {
                    msg.append("##").append(ResManager.loadKDString((String)"\u6307\u5b9a\u6838\u7b97\u5e01\u79cd\uff0c\u5219\u4e0a\u7ea7\u5e01\u79cd\u5fc5\u987b\u5305\u542b\u4e0b\u7ea7\u5e01\u79cd\u3002", (String)"AccountVersionControlChecker_11", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if (AccPropType.ASSIST.isIn(propTypes)) {
            DynamicObjectCollection parAssistEntry = (DynamicObjectCollection)relativeSuperProp.get("checkitementry");
            DynamicObjectCollection assistEntry = (DynamicObjectCollection)relativeChildProp.get("checkitementry");
            HashMap parFlexfields = new HashMap(parAssistEntry.size());
            HashMap<String, String> parAssNameMap = new HashMap<String, String>(parAssistEntry.size());
            for (DynamicObject dyn : parAssistEntry) {
                DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
                ArrayList<Boolean> propList = new ArrayList<Boolean>(3);
                propList.add(dyn.getBoolean("isrequire"));
                propList.add(dyn.getBoolean("isdetail"));
                propList.add(dyn.getBoolean("enaccheck"));
                String assKey = assgrp.getString("flexfield");
                parFlexfields.put(assKey, propList);
                parAssNameMap.put(assKey, assgrp.getString("name"));
            }
            HashMap subflexfields = new HashMap(assistEntry.size());
            for (DynamicObject dyn : assistEntry) {
                DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
                ArrayList<Boolean> propList = new ArrayList<Boolean>(3);
                propList.add(dyn.getBoolean("isrequire"));
                propList.add(dyn.getBoolean("isdetail"));
                propList.add(dyn.getBoolean("enaccheck"));
                String assKey = assgrp.getString("flexfield");
                subflexfields.put(assKey, propList);
            }
            for (Map.Entry parent : parFlexfields.entrySet()) {
                ArrayList subPropList = (ArrayList)subflexfields.get(parent.getKey());
                ArrayList parPropList = (ArrayList)parFlexfields.get(parent.getKey());
                if (subPropList != null && parPropList != null) {
                    boolean parIsRequire = (Boolean)parPropList.get(0);
                    boolean parIsDetail = (Boolean)parPropList.get(1);
                    boolean parEnAccheck = (Boolean)parPropList.get(2);
                    boolean subIsRequire = (Boolean)subPropList.get(0);
                    boolean subIsDetail = (Boolean)subPropList.get(1);
                    boolean subEnAccheck = (Boolean)subPropList.get(2);
                    if (!(parIsRequire && !subIsRequire || parIsDetail && !subIsDetail) && (!parEnAccheck || subEnAccheck)) continue;
                    msg.append("##").append(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u201c%s\u201d\u6838\u7b97\u52fe\u9009\u5fc5\u5f55\uff08\u660e\u7ec6\u3001\u5f80\u6765\u6838\u7b97\uff09\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u53d6\u6d88\u52fe\u9009\u3002", (String)"AccountVersionControlChecker_12", (String)"fi-bd-opplugin", (Object[])new Object[0]), parAssNameMap.get(parent.getKey())));
                    continue;
                }
                msg.append("##").append(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u6709'%s'\u6838\u7b97\u7ef4\u5ea6\uff0c\u4e0b\u7ea7\u79d1\u76ee\u672a\u5305\u542b\u8be5\u7ef4\u5ea6\u3002", (String)"AccountVersionControlChecker_13", (String)"fi-bd-opplugin", (Object[])new Object[0]), parAssNameMap.get(parent.getKey())));
            }
        }
        return StringUtils.isBlank((CharSequence)msg.toString()) ? Optional.empty() : Optional.ofNullable(msg.toString());
    }

    private static Map<String, Object> getAccountProp(Long accId) {
        DynamicObject accDy = BusinessDataServiceHelper.loadSingle((Object)accId, (String)"bd_accountview", (String)USED_PROPS);
        return AccountVersionControlChecker.getAccountProp(accDy);
    }

    public static Map<String, Object> getAccountProp(DynamicObject parentAcc) {
        Map<String, Object> propMap = AccountVersionControlChecker.getWithoutEntryAccountProp(parentAcc);
        propMap.put("currencyentry", parentAcc.getDynamicObjectCollection("currencyentry"));
        propMap.put("checkitementry", parentAcc.getDynamicObjectCollection("checkitementry"));
        return propMap;
    }

    public static Map<String, Object> getWithoutEntryAccountProp(DynamicObject parentAcc) {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("dc", parentAcc.getString("dc"));
        propMap.put("accrualdirection", parentAcc.getString("accrualdirection"));
        propMap.put("orgcontrollevel", parentAcc.getString("orgcontrollevel"));
        propMap.put("isallowca", parentAcc.getBoolean("isallowca"));
        propMap.put("ismanual", parentAcc.getBoolean("ismanual"));
        propMap.put("iscash", parentAcc.getBoolean("iscash"));
        propMap.put("isbank", parentAcc.getBoolean("isbank"));
        propMap.put("iscashequivalent", parentAcc.getBoolean("iscashequivalent"));
        propMap.put("acnotice", parentAcc.getBoolean("acnotice"));
        propMap.put("ischangecurrency", parentAcc.getBoolean("ischangecurrency"));
        propMap.put("isqty", parentAcc.getBoolean("isqty"));
        propMap.put("acctcurrency", parentAcc.getString("acctcurrency"));
        return propMap;
    }

    public static Optional<String> buildCheckResultTip(Result resultCheck) {
        if (resultCheck.status == Status.SUCCESS) {
            return Optional.empty();
        }
        String msgTempate = null;
        if (Status.ACC_UP_FAIL == resultCheck.getStatus()) {
            msgTempate = ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u5f53\u524d\u7ec4\u7ec7\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\uff1a%s", (String)"AccountVersionControlChecker_18", (String)"fi-bd-common", (Object[])new Object[0]);
        } else if (Status.PARTENT_ORG_FAIL == resultCheck.getStatus()) {
            msgTempate = ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u4e0a\u7ea7\u7ec4\u7ec7\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\uff1a%s", (String)"AccountVersionControlChecker_19", (String)"fi-bd-common", (Object[])new Object[0]);
        } else if (Status.CHILD_ORG_FAIL == resultCheck.getStatus()) {
            msgTempate = ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u4e0b\u7ea7\u7ec4\u7ec7\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\uff1a%s", (String)"AccountVersionControlChecker_20", (String)"fi-bd-common", (Object[])new Object[0]);
        } else if (Status.ASSGIN_ACC_FAIL == resultCheck.getStatus()) {
            msgTempate = ResManager.loadKDString((String)"\u79d1\u76ee\u7684\u5206\u914d\u79d1\u76ee\u4e0d\u6ee1\u8db3\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\uff1a%s", (String)"AccountVersionControlChecker_21", (String)"fi-bd-common", (Object[])new Object[0]);
        } else {
            return Optional.empty();
        }
        return Optional.of(String.format(msgTempate, resultCheck.getErrMsg()));
    }

    public static Boolean compareAccountEntryIsEqual(DynamicObject dynamicObject, DynamicObject dbDynamicObject) {
        return AccountVersionControlChecker.compareAccountEntryIsEqual(dynamicObject, dbDynamicObject, false);
    }

    public static Boolean compareAccountEntryIsEqual(DynamicObject dynamicObject, DynamicObject dbDynamicObject, boolean isOnlyCheckAssistEntry) {
        Map<Long, Map<String, Boolean>> currEntryInfoMap = AccountVersionControlChecker.getFlexFieldsProp(dynamicObject);
        Map<Long, Map<String, Boolean>> dbEntryInfoMap = AccountVersionControlChecker.getFlexFieldsProp(dbDynamicObject);
        if (currEntryInfoMap.size() != dbEntryInfoMap.size()) {
            return false;
        }
        for (Map.Entry<Long, Map<String, Boolean>> dbEntryInfo : dbEntryInfoMap.entrySet()) {
            Map<String, Boolean> dbFlexFields = dbEntryInfo.getValue();
            Map<String, Boolean> currFlexFields = currEntryInfoMap.get(dbEntryInfo.getKey());
            if (isOnlyCheckAssistEntry) {
                if (!CollectionUtils.isEmpty(currFlexFields)) continue;
                return false;
            }
            if (!CollectionUtils.isEmpty(currFlexFields)) {
                boolean dbIsDetail = dbFlexFields.get("isdetail");
                boolean dbIsRequire = dbFlexFields.get("isrequire");
                boolean dbEnAccheck = dbFlexFields.get("enaccheck");
                boolean currIsDetail = currFlexFields.get("isdetail");
                boolean currIsRequire = currFlexFields.get("isrequire");
                boolean currEnAccheck = currFlexFields.get("enaccheck");
                if (dbIsDetail != currIsDetail || dbIsRequire != currIsRequire || dbEnAccheck != currEnAccheck) {
                    return false;
                }
            } else {
                return false;
            }
            Set<Long> currCurrencys = AccountVersionControlChecker.getCurrencyProp(dynamicObject);
            Set<Long> dbCurrencys = AccountVersionControlChecker.getCurrencyProp(dbDynamicObject);
            if (currCurrencys.size() != dbCurrencys.size()) {
                return false;
            }
            List currReduce = currCurrencys.stream().filter(item -> !dbCurrencys.contains(item)).collect(Collectors.toList());
            List dbReduce = dbCurrencys.stream().filter(item -> !currCurrencys.contains(item)).collect(Collectors.toList());
            if (currReduce.isEmpty() && dbReduce.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static Set<Long> getCurrencyProp(DynamicObject dynamicObject) {
        HashSet<Long> currencyInfos = new HashSet<Long>(8);
        DynamicObjectCollection currencyEntrys = dynamicObject.getDynamicObjectCollection("currencyentry");
        for (DynamicObject currency : currencyEntrys) {
            currencyInfos.add(currency.getLong("currency_id"));
        }
        return currencyInfos;
    }

    public static Map<Long, Map<String, Boolean>> getFlexFieldsProp(DynamicObject dynamicObject) {
        HashMap<Long, Map<String, Boolean>> entryInfoMap = new HashMap<Long, Map<String, Boolean>>(8);
        DynamicObjectCollection assistEntries = dynamicObject.getDynamicObjectCollection("checkitementry");
        for (DynamicObject assistEntry : assistEntries) {
            Long currAssistId = assistEntry.getDynamicObject("asstactitem").getLong("id");
            HashMap<String, Boolean> itemMap = new HashMap<String, Boolean>(8);
            itemMap.put("isdetail", assistEntry.getBoolean("isdetail"));
            itemMap.put("isrequire", assistEntry.getBoolean("isrequire"));
            itemMap.put("enaccheck", assistEntry.getBoolean("enaccheck"));
            entryInfoMap.put(currAssistId, itemMap);
        }
        return entryInfoMap;
    }

    public static boolean checkCurrencyChange(DynamicObject accountDB, DynamicObject account) {
        Set<Long> accCurrencySet;
        Set<Long> accDBCurrencySet;
        String acctcurrency = account.getString("acctcurrency");
        String dbCurrency = accountDB.getString("acctcurrency");
        if (!dbCurrency.equals(acctcurrency)) {
            return true;
        }
        return dbCurrency.equals("descurrency") && acctcurrency.equals("descurrency") && !(accDBCurrencySet = AccountVersionControlChecker.getCurrencyProp(accountDB)).equals(accCurrencySet = AccountVersionControlChecker.getCurrencyProp(account));
    }

    public static boolean accountCurrencyControlCheck(DynamicObject oldAccount, DynamicObject newAccount) {
        DynamicObject cur;
        String newCurrType = newAccount.getString("acctcurrency");
        String oldCurrType = oldAccount.getString("acctcurrency");
        if ((newCurrType.equals("descurrency") || newCurrType.equals("nocurrency")) && oldCurrType.equals("allcurrency")) {
            return true;
        }
        if (oldCurrType.equals("descurrency") && newCurrType.equals("nocurrency")) {
            return true;
        }
        DynamicObjectCollection newCurrencyEntry = newAccount.getDynamicObjectCollection("currencyentry");
        DynamicObjectCollection oldCurrenctEntry = oldAccount.getDynamicObjectCollection("currencyentry");
        HashSet<Long> pcid = new HashSet<Long>(newCurrencyEntry.size());
        for (DynamicObject row : newCurrencyEntry) {
            cur = row.getDynamicObject("currency");
            if (cur == null) continue;
            pcid.add(cur.getLong("id"));
        }
        for (DynamicObject row : oldCurrenctEntry) {
            cur = row.getDynamicObject("currency");
            if (CollectionUtils.isEmpty(pcid) || cur == null || pcid.contains(cur.getLong("id"))) continue;
            return true;
        }
        return false;
    }

    public static class DelRevisionOrgAccountFunction
    implements RetrieveOrgAccountFunction {
        @Override
        public Map<Long, DynamicObject> apply(String accNumber, long masterId, Set<Long> specificOrgIds, long processAccId) {
            return new DefaultOrgAccountFunction().apply(accNumber, masterId, specificOrgIds, processAccId).entrySet().stream().filter(x -> processAccId != ((DynamicObject)x.getValue()).getLong("id")).collect(Collectors.toMap(x -> (Long)x.getKey(), y -> (DynamicObject)y.getValue()));
        }
    }

    public static class DefaultOrgAccountFunction
    implements RetrieveOrgAccountFunction {
        @Override
        public Map<Long, DynamicObject> apply(String accNumber, long masterId, Set<Long> specificOrgIds, long processAccId) {
            Set<Tuple<Long, Long>> accOrgUseRelations = AccountVersionUtil.listOrgUsedAccRelation(specificOrgIds, accNumber, masterId);
            if (accOrgUseRelations.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            Set accIds = accOrgUseRelations.stream().map(x -> (Long)x.item1).collect(Collectors.toSet());
            Map<Long, DynamicObject> accIdMap = Arrays.stream(BusinessDataServiceHelper.load((String)"bd_accountview", (String)USED_PROPS, (QFilter[])new QFilter("id", "in", accIds).toArray())).collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
            HashMap<Long, DynamicObject> orgIdAccMap = new HashMap<Long, DynamicObject>(8);
            for (Tuple<Long, Long> relation : accOrgUseRelations) {
                long accId = (Long)relation.item1;
                long orgId = (Long)relation.item2;
                orgIdAccMap.put(orgId, accIdMap.get(accId));
            }
            return orgIdAccMap;
        }
    }

    @FunctionalInterface
    public static interface RetrieveOrgAccountFunction {
        public Map<Long, DynamicObject> apply(String var1, long var2, Set<Long> var4, long var5);
    }

    public static class Result {
        private Status status;
        private String errMsg;

        public Result(Status status, String errMsg) {
            this.status = status;
            this.errMsg = errMsg;
        }

        public static Result success() {
            return new Result(Status.SUCCESS, null);
        }

        public Status getStatus() {
            return this.status;
        }

        public String getErrMsg() {
            return this.errMsg;
        }
    }

    public static enum Status {
        SUCCESS,
        ACC_UP_FAIL,
        PARTENT_ORG_FAIL,
        CHILD_ORG_FAIL,
        ASSGIN_ACC_FAIL;

    }

    public static enum AccPropType {
        ASSIST(1),
        OTHERS(2);

        private int value;

        private AccPropType(int value) {
            this.value = value;
        }

        public static int allTypes() {
            int result = 0;
            for (AccPropType type : AccPropType.values()) {
                result |= type.value;
            }
            return result;
        }

        public boolean isIn(int value) {
            return (value & this.value) == this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CheckType {
        ACC_UP(1),
        ACC_DOWN(2),
        PARTENT_ORG(4),
        CHILD_ORG(8),
        ASSGIN_ACC(16);

        private int value;

        private CheckType(int value) {
            this.value = value;
        }

        public static int allTypes() {
            int result = 0;
            for (CheckType type : CheckType.values()) {
                result |= type.value;
            }
            return result;
        }

        public boolean isIn(int value) {
            return (value & this.value) == this.value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

