/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.OrgVO;

public class AccountVersionUtil {
    private static Log logger = LogFactory.getLog(AccountVersionUtil.class);
    private static final String ACCOUNT = "account";
    private static final String ORG = "org";
    private static final String GL = "gl";
    public static final String LATEST_VERSION_DATE = "2999-12-31";
    public static final String INIT_VERSION_DATE = "1900-01-01";
    public static final String ISVERSION = "isversion";
    public static final String ISASSIGN = "isassign";
    public static final String ISADDNEW = "isaddnew";
    private static volatile Date enddate;
    private static volatile Date initBegindate;
    private static final String USED_PROPS;
    public static final Set<String> CTRL_SHARE_STRATEGY;

    public static boolean isShareCtrlStrategy(DynamicObject account) {
        String controlStrategy = account.getString("ctrlstrategy");
        logger.info("current account {} controlStrategy is:{}", (Object)account.getString("number"), (Object)controlStrategy);
        return CTRL_SHARE_STRATEGY.contains(controlStrategy);
    }

    public static Date getEndDate() {
        if (enddate != null) {
            return enddate;
        }
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            enddate = dt.parse(LATEST_VERSION_DATE);
            return enddate;
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"AccountVersionUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
    }

    public static Date getInitBeginDate() {
        if (initBegindate != null) {
            return initBegindate;
        }
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            initBegindate = dt.parse(INIT_VERSION_DATE);
            return initBegindate;
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"AccountVersionUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
    }

    public static Date getStartDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            return dt.parse(dt.format(new Date()));
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"AccountVersionUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
    }

    public static int compareDate(Date left, Date right) {
        Calendar c = Calendar.getInstance();
        c.setTime(left);
        int leftTime = c.get(1) * 10000 + c.get(2) * 100 + c.get(5);
        c.setTime(right);
        int rightTime = c.get(1) * 10000 + c.get(2) * 100 + c.get(5);
        return leftTime < rightTime ? -1 : (leftTime == rightTime ? 0 : 1);
    }

    public static String getRefServiceKey(long orgId, long tableId, Date date) {
        return StringUtils.join((Object[])new Object[]{orgId, tableId, date.getTime()}, (char)'-');
    }

    public static boolean isReversion(DynamicObject book, Date curDate, Date lastVersionDate) {
        if (book == null) {
            Calendar c = Calendar.getInstance();
            c.setTime(curDate);
            int curTime = c.get(1) * 100 + c.get(2);
            c.setTime(lastVersionDate);
            int lastVersionTime = c.get(1) * 100 + c.get(2);
            return curTime == lastVersionTime;
        }
        QFilter qdate = new QFilter("begindate", "<=", (Object)lastVersionDate).and(new QFilter("enddate", ">=", (Object)lastVersionDate)).and(new QFilter("begindate", "<=", (Object)curDate).and(new QFilter("enddate", ">=", (Object)curDate)));
        return QueryServiceHelper.exists((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", book.get("periodtype.id")), qdate});
    }

    public static String getIds(Collection<Long> c) {
        StringBuilder str = new StringBuilder();
        for (Long pid : c) {
            if (str.length() != 0) {
                str.append(',');
            }
            str.append(pid);
        }
        return str.toString();
    }

    public static boolean ishasBalance(Object accountId, Object orgId) {
        QFilter[] qFilters;
        QFilter qacct = new QFilter(ACCOUNT, "=", accountId);
        if (orgId == null || Long.parseLong(String.valueOf(orgId)) == 0L) {
            qFilters = new QFilter[]{qacct};
        } else {
            QFilter qorg = new QFilter(ORG, "=", orgId);
            qFilters = new QFilter[]{qorg, qacct};
        }
        return QueryServiceHelper.exists((String)"gl_balance", (QFilter[])qFilters);
    }

    public static List<Object> getAllSubAccts(Object acctId) {
        List subIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("parent", "=", acctId)}, null, (int)-1);
        ArrayList<Object> result = new ArrayList<Object>(subIds.size());
        result.addAll(subIds);
        while (!subIds.isEmpty()) {
            subIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter("parent", "in", (Object)subIds).toArray(), null, (int)-1);
            result.addAll(subIds);
        }
        return result;
    }

    public static List<Object> getObjAssignSubOrgIds(Object id, Object curOrgId, String ctrlstrategy, boolean containAssign, boolean isIncludeCurOrg) {
        List<Long> subOrgIds = BDUtil.getAllSubordinateOrgs(curOrgId, isIncludeCurOrg);
        if (!("5".equals(ctrlstrategy) || "6".equals(ctrlstrategy) || "7".equals(ctrlstrategy))) {
            String sql = String.format("select fdataid,fuseorgid,fassignorgid from t_bd_accountusereg where fdataid = %s", id);
            ArrayList<Long> useOrgIds = new ArrayList<Long>();
            try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql);){
                Row row = null;
                while (dt.hasNext()) {
                    row = dt.next();
                    useOrgIds.add(row.getLong("fuseorgid"));
                }
            }
            if (!isIncludeCurOrg) {
                useOrgIds.remove(curOrgId);
            }
            if (containAssign) {
                subOrgIds.removeAll(useOrgIds);
                subOrgIds.addAll(useOrgIds);
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(subOrgIds);
        return result;
    }

    public static List<DynamicObject> getObjAssignSubOrgs(Object id, Object curOrgId, String ctrlstrategy, boolean containAssign) {
        List<Object> orgIds = AccountVersionUtil.getObjAssignSubOrgIds(id, curOrgId, ctrlstrategy, containAssign, false);
        ArrayList<Object> descOrgIds = new ArrayList<Object>(orgIds);
        for (int i = orgIds.size() - 1; i >= 0; --i) {
            descOrgIds.add(orgIds.get(i));
        }
        Map maps = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number,name,masterid", (QFilter[])new QFilter("id", "in", orgIds).toArray());
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(maps.size());
        for (Object e : descOrgIds) {
            DynamicObject org = (DynamicObject)maps.get(e);
            if (org == null) continue;
            result.add(org);
        }
        return result;
    }

    public static void clearBaseDataCache(boolean clearAll, Set<Long> orgIds) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        if (clearAll) {
            BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)"bd_accountview");
            BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)"bd_accountview");
        } else if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
            HashSet<Long> singletonList = new HashSet<Long>(1);
            for (Long orgId : orgIds) {
                singletonList.clear();
                singletonList.add(orgId);
                BaseDataCtrlCache.clearBaseDataUseRange((String)"bd_accountview", singletonList);
                BaseDataCtrlCache.clearBaseDataFilter((String)"bd_accountview", singletonList);
            }
        }
    }

    public static Map<Long, Long> getAssignAcctUseOrgId(Object oldAcctId, Set<Long> subOrgIds) {
        HashMap<Long, Long> useOrgToAssignOrgMap = new HashMap<Long, Long>(100);
        HashSet<Long> useOrgIds = new HashSet<Long>(100);
        String useRegSql = "select distinct fuseorgid,fassignorgid  from t_bd_accountusereg where fdataid = ?";
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)useRegSql, (Object[])new Object[]{oldAcctId});){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                useOrgIds.add(row.getLong("fuseorgid"));
                useOrgToAssignOrgMap.put(row.getLong("fuseorgid"), row.getLong("fassignorgid"));
            }
        }
        String excSql = "select distinct exc.fuseorgid fuseorgid from t_bd_accountexc exc  where exc.fdataid=?";
        DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)excSql, (Object[])new Object[]{oldAcctId});
        Object object = null;
        try {
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                useOrgIds.remove(row.getLong("fuseorgid"));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dt != null) {
                if (object != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dt.close();
                }
            }
        }
        useOrgIds.retainAll(subOrgIds);
        if (useOrgIds.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(100);
        for (Long id : useOrgIds) {
            resultMap.put(id, (Long)useOrgToAssignOrgMap.get(id));
        }
        return resultMap;
    }

    public static Map<Long, Long> getAssignAcctUseOrgIdIncludeExe(Object oldAcctId, Set<Long> subOrgIds) {
        HashMap<Long, Long> useOrgToAssignOrgMap = new HashMap<Long, Long>(100);
        HashSet<Long> useOrgIds = new HashSet<Long>(100);
        String useRegSql = "select distinct fuseorgid,fassignorgid  from t_bd_accountusereg where fdataid = ?";
        DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)useRegSql, (Object[])new Object[]{oldAcctId});
        Object object = null;
        try {
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                useOrgIds.add(row.getLong("fuseorgid"));
                useOrgToAssignOrgMap.put(row.getLong("fuseorgid"), row.getLong("fassignorgid"));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dt != null) {
                if (object != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dt.close();
                }
            }
        }
        useOrgIds.retainAll(subOrgIds);
        if (useOrgIds.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(100);
        for (Long id : useOrgIds) {
            resultMap.put(id, (Long)useOrgToAssignOrgMap.get(id));
        }
        return resultMap;
    }

    public static Set<Long> getAssignAcctUseOrgId(Long acctId) {
        HashSet<Long> useOrgIds = new HashSet<Long>(100);
        String useRegSql = "select distinct reg.fuseorgid fuseorgid  from t_bd_accountusereg reg  where reg.fdataid = ?";
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)useRegSql, (Object[])new Object[]{acctId});){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                useOrgIds.add(row.getLong("fuseorgid"));
            }
        }
        String excSql = "select distinct exc.fuseorgid fuseorgid from t_bd_accountexc exc  where exc.fdataid=?";
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)excSql, (Object[])new Object[]{acctId});){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                useOrgIds.remove(row.getLong("fuseorgid"));
            }
        }
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((Object)acctId, (String)"bd_accountview", (String)"createorg");
        useOrgIds.remove(accountObj.getLong("createorg.id"));
        return useOrgIds;
    }

    public static List<Object[]> getExcParams(List<Object[]> excParams, Set<Long> useOrgIds, Object oldAcctId, Object oldCreateOrgId) {
        if (excParams == null) {
            excParams = new ArrayList<Object[]>(100);
        }
        for (Long useOrgId : useOrgIds) {
            excParams.add(new Object[]{oldAcctId, oldCreateOrgId, useOrgId});
        }
        return excParams;
    }

    public static List<Object[]> getUseregParams(List<Object[]> useRegParams, Map<Long, Long> useOrgToAssignOrgMap, Object acctId, Object createOrgId, String ctrlstrategy, boolean self) {
        if (useRegParams == null) {
            useRegParams = new ArrayList<Object[]>(8);
        }
        if ("5".equals(ctrlstrategy) || "6".equals(ctrlstrategy)) {
            return useRegParams;
        }
        for (Map.Entry<Long, Long> entryMap : useOrgToAssignOrgMap.entrySet()) {
            long useOrgId = entryMap.getKey();
            long assignOrgId = entryMap.getValue();
            useRegParams.add(new Object[]{useOrgId, acctId, createOrgId, createOrgId, ctrlstrategy, assignOrgId == 0L ? "0" : "1", assignOrgId});
        }
        return useRegParams;
    }

    public static void doAssign(List<Object[]> excParams, List<Object[]> useRegParams) {
        String insertExcSql = "insert into t_bd_accountexc(fdataid,fcreateorgid,fuseorgid) values(?,?,?)";
        if (excParams != null && !excParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)"delete from t_bd_accountexc where fdataid = ? and fcreateorgid = ? and fuseorgid = ?", excParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)insertExcSql, excParams);
        }
        String insertUseRegSql = "insert into t_bd_accountusereg(fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid) values(?,?,?,?,?,?,?)";
        if (useRegParams != null && !useRegParams.isEmpty()) {
            ArrayList<Object[]> delParams = new ArrayList<Object[]>(useRegParams.size());
            for (Object[] param : useRegParams) {
                delParams.add(new Object[]{param[1], param[2], param[0]});
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)"delete from t_bd_accountusereg where fdataid = ? and fcreateorgid = ? and fuseorgid = ?", delParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)insertUseRegSql, useRegParams);
        }
        AccountVersionUtil.refreshBaseDataUseRange(excParams, useRegParams);
    }

    public static void refreshBaseDataUseRange(List<Object[]> excParams, List<Object[]> useRegParams) {
        if (excParams != null && !excParams.isEmpty()) {
            ArrayList<Object[]> deleteRParams = new ArrayList<Object[]>(excParams.size());
            for (Object[] param : excParams) {
                deleteRParams.add(new Object[]{param[0], param[2]});
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)"delete from t_bd_account_u where fdataid = ? and fuseorgid = ?", deleteRParams);
        }
        if (useRegParams != null && !useRegParams.isEmpty()) {
            ArrayList<Object[]> insertRParams = new ArrayList<Object[]>(useRegParams.size());
            for (Object[] param : useRegParams) {
                boolean containsExc;
                if (excParams != null && !excParams.isEmpty() && (containsExc = excParams.stream().anyMatch(excParam -> ((Long)excParam[0]).compareTo((Long)param[1]) == 0 && ((Long)excParam[2]).compareTo((Long)param[0]) == 0))) continue;
                insertRParams.add(new Object[]{param[1], param[0]});
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)"delete from t_bd_account_u where fdataid = ? and fuseorgid = ?", insertRParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)"insert into t_bd_account_u(fdataid,fuseorgid) values(?,?)", insertRParams);
            useRegParams.clear();
        }
        if (excParams != null) {
            excParams.clear();
        }
    }

    public static void refreshBaseDataUseRange(List<Object[]> shareUparams) {
        if (shareUparams != null && !shareUparams.isEmpty()) {
            ArrayList<Object[]> deleteRParams = new ArrayList<Object[]>(shareUparams.size() * 10);
            ArrayList<Object[]> insertRParams = new ArrayList<Object[]>(shareUparams.size() * 10);
            for (Object[] param : shareUparams) {
                Set orgIds = (Set)param[2];
                for (Long orgId : orgIds) {
                    if (param[1] != null) {
                        deleteRParams.add(new Object[]{param[1], orgId});
                    }
                    insertRParams.add(new Object[]{param[0], orgId});
                }
            }
            if (!insertRParams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)"delete from t_bd_account_u where fdataid = ? and fuseorgid = ?", insertRParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)GL), (String)"insert into t_bd_account_u(fdataid,fuseorgid) values(?,?)", insertRParams);
            }
            shareUparams.clear();
        }
    }

    private static List<Long> getDirectSubordinateOrgList(Long orgViewId, Long parentOrgId) {
        ORM ormOV = ORM.create();
        ArrayList<Long> directSubOrgIds = new ArrayList<Long>();
        boolean isctrlunit = false;
        QFilter f2 = new QFilter("view.id", "=", (Object)orgViewId);
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)isctrlunit);
        QFilter f4 = new QFilter("parent.id", "=", (Object)parentOrgId);
        QFilter f5 = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter f6 = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), "bos_org_structure", "org.id", new QFilter[]{f2, f3, f4, f5, f6});){
            for (Row row : ds) {
                if (row.getLong("org.id") == null) continue;
                directSubOrgIds.add(row.getLong("org.id"));
            }
        }
        ArrayList<Long> allSubOrgIds = new ArrayList<Long>();
        List<Long> subOrgIds = AccountVersionUtil.getAllSubordinateOrgs(orgViewId, directSubOrgIds, Boolean.TRUE, isctrlunit);
        allSubOrgIds.addAll(directSubOrgIds);
        allSubOrgIds.addAll(subOrgIds);
        allSubOrgIds.add(parentOrgId);
        return allSubOrgIds;
    }

    private static List<Long> getAllSubordinateOrgs(Long orgViewId, List<Long> directSubOrgIds, boolean b, boolean isctrlunit) {
        QFilter orgFilter = new QFilter(ORG, "in", directSubOrgIds);
        QFilter viewFilter = new QFilter("view", "=", (Object)orgViewId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter statusFilter = new QFilter("org.status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter isctrlunitFilter = new QFilter("isctrlunit", "=", (Object)isctrlunit);
        QFilter[] filters = new QFilter[]{orgFilter, freezeFilter, statusFilter, enableFilter, viewFilter, isctrlunitFilter};
        String parentLongNumber = null;
        ArrayList<String> parentLongnumberList = new ArrayList<String>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.servicehelper.org.OrgUnitServiceHelper.getAllSubordinateOrgs", (String)"bos_org_structure", (String)"longnumber", (QFilter[])filters, (String)"longnumber");
        Object object = null;
        try {
            for (Row row : dataSet) {
                String longnumber = row.getString("longnumber");
                if (StringUtils.isBlank((CharSequence)longnumber) || parentLongNumber != null && longnumber.startsWith(parentLongNumber)) continue;
                parentLongNumber = longnumber + "!";
                parentLongnumberList.add(parentLongNumber);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashSet<Long> childOrgIds = new HashSet<Long>();
        for (String longnumber : parentLongnumberList) {
            QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
            filters = new QFilter[]{longnumberFilter, freezeFilter, statusFilter, enableFilter, viewFilter, isctrlunitFilter};
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"kd.bos.servicehelper.org.OrgUnitServiceHelper.getAllSubordinateOrgs.longnumber", (String)"bos_org_structure", (String)ORG, (QFilter[])filters, null);
            Throwable throwable = null;
            try {
                for (Row row : dataSet2) {
                    childOrgIds.add(row.getLong(ORG));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet2 == null) continue;
                if (throwable != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet2.close();
            }
        }
        return new ArrayList<Long>(childOrgIds);
    }

    public static boolean saveSelfSubAccount(DynamicObject account, DynamicObject parent, Object subOrgId, Object masterId) {
        String ctrlStrategy;
        CloneUtils clone = new CloneUtils(true, true);
        DynamicObject newAcct = (DynamicObject)clone.clone((IDataEntityBase)account);
        newAcct.set("id", null);
        newAcct.set("masterid", masterId);
        newAcct.set("parent", (Object)parent);
        newAcct.set("parent_id", parent.get("id"));
        newAcct.set("createorg_id", subOrgId);
        newAcct.set("org_id", subOrgId);
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAcct});
        if (saveObjs != null && saveObjs.length > 0) {
            AccountVersionUtil.saveBaseDataRef(parent.getDataEntityType().getAlias(), parent.getDataEntityType().getDBRouteKey(), (DynamicObject)saveObjs[0]);
        }
        if ("5".equals(ctrlStrategy = parent.getString("ctrlstrategy"))) {
            newAcct.set("ctrlstrategy", (Object)"7");
        }
        Long newPK = (Long)newAcct.getPkValue();
        ArrayList<Long> useOrgSet = new ArrayList<Long>();
        useOrgSet.add((Long)subOrgId);
        AccountVersionUtil.saveBaseDataUseReg(newAcct, subOrgId, subOrgId, useOrgSet, ctrlStrategy);
        return true;
    }

    public static void saveBaseDataRef(String baseDataTableName, String dbRouteKey, DynamicObject saveObj) {
        String bsaeDataR3TableName = baseDataTableName + "_r3";
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String insertSql = "insert into " + bsaeDataR3TableName + "(fid,frefstatus) values(" + saveObj.getPkValue() + ",'1')";
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)insertSql, null);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
            }
        }
    }

    public static void saveBaseDataUseReg(DynamicObject dataInfo, Object createOrgID, Object adminOrgID, List<Long> useOrgList, String ctrlStrategy) {
        HashSet<Long> useOrgSet = new HashSet<Long>(16);
        for (Long useOrgID3 : useOrgList) {
            useOrgSet.add(useOrgID3);
        }
        DBRoute dbRoute = null;
        String dbRouteKey = dataInfo.getDataEntityType().getDBRouteKey();
        dbRoute = DBRoute.of((String)dbRouteKey);
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String bsaeDataUseRegTableName = baseDataTableName + "UseReg";
        String deleteSql = "delete from " + bsaeDataUseRegTableName + " where fuseorgid = ? and FDataID = ? ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(useOrgSet.size());
        Object[] params = null;
        for (Long l : useOrgSet) {
            params = new Object[]{l, dataInfo.getPkValue()};
            paramsList.add(params);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            DB.executeBatch((DBRoute)dbRoute, (String)deleteSql, paramsList);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        String insertSql = "insert into " + bsaeDataUseRegTableName + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign) values(?, ?, ?, ?, ?,'0')";
        paramsList = new ArrayList(useOrgSet.size());
        params = null;
        for (Long l : useOrgSet) {
            params = new Object[]{l, dataInfo.getPkValue(), createOrgID, adminOrgID, ctrlStrategy};
            paramsList.add(params);
        }
        Throwable throwable4 = null;
        try (TXHandle tXHandle = TX.required();){
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql, paramsList);
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        String string = dataInfo.getString("ctrlstrategy");
        String string2 = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String entityID = dataInfo.getDataEntityType().getName();
        if ("5".equals(string)) {
            BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)string2, (String)entityID);
            BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entityID);
        } else if ("6".equals(ctrlStrategy)) {
            try {
                DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityID);
                if (null == ctrlview) {
                    return;
                }
                DynamicObject useorg = dataInfo.getDynamicObject("useorg");
                List<Long> orgList = AccountVersionUtil.getDirectSubordinateOrgList((Long)ctrlview.getPkValue(), (Long)useorg.getPkValue());
                String key = null;
                for (Long org : orgList) {
                    key = entityID + org;
                    BaseDataCtrlCacheMrg.clearCache((String)string2, (String)key);
                    BaseDataCtrlCache.clearBaseDataUseRange((String)entityID, (Long)org);
                }
            }
            catch (Exception e) {
                logger.error("BaseDataServiceHelper.saveBaseDataUseReg" + e.getMessage());
            }
        } else {
            String key = null;
            for (Long useOrgID5 : useOrgList) {
                key = entityID + useOrgID5;
                BaseDataCtrlCacheMrg.clearCache((String)string2, (String)key);
                BaseDataCtrlCache.clearBaseDataUseRange((String)entityID, (Long)useOrgID5);
            }
        }
    }

    public static boolean isNameChanged(DynamicObject account, DynamicObject accountDB) {
        boolean isChange = false;
        for (IDataEntityProperty iDataEntityProperty : account.getDataEntityState().getBizChangedProperties()) {
            String changeKey = iDataEntityProperty.getName();
            if (!changeKey.equals("name")) continue;
            isChange = true;
            break;
        }
        return isChange && !account.getString("name").equals(accountDB.getString("name"));
    }

    public static boolean isLatestAccount(DynamicObject account, long id) {
        Date endDate;
        if (account == null) {
            account = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_accountview");
        }
        return !(endDate = account.getDate("enddate")).before(AccountVersionUtil.getEndDate());
    }

    public static Set<Long> queryAllAccIdsByUseOrgs(Collection<Long> useOrgIds, boolean includeShareAcc, QFilter otherAccountFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(otherAccountFilter);
        Set<Long> accIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1).stream().map(x -> (Long)x).collect(Collectors.toSet());
        HashSet<Long> resultSet = new HashSet<Long>(10);
        if (CollectionUtils.isEmpty(accIds)) {
            return resultSet;
        }
        int batchSize = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.bd.util.BizHappenUtils.batchOrgSize", 1000);
        long tick = System.currentTimeMillis();
        ArrayList<Long> orgList = new ArrayList<Long>(useOrgIds);
        List batchPartition = Lists.partition(orgList, (int)batchSize);
        for (List batchOrg : batchPartition) {
            Set<Long> res = AccountVersionUtil.queryUseAccts(accIds, batchOrg);
            resultSet.addAll(res);
        }
        if (DebugTrace.enable()) {
            logger.info("queryUseAccts cost:{}", (Object)(System.currentTimeMillis() - tick));
        }
        if (includeShareAcc) {
            QFilter shareFilter = new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('5')).and("status", "=", (Object)"C");
            Set shareAccIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{otherAccountFilter, shareFilter}, null, (int)-1).stream().map(x -> (Long)x).collect(Collectors.toSet());
            resultSet.addAll(shareAccIds);
        }
        return resultSet;
    }

    protected static Set<Long> queryUseAccts(Set<Long> accIds, Collection<Long> useOrgIds) {
        HashSet<Long> resultSet = new HashSet<Long>(10);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select  distinct fdataid id from t_bd_account_u  where ", new Object[0]);
        sqlBuilder.appendIn(" fdataid  ", accIds.toArray());
        sqlBuilder.appendIn(" and fuseorgid ", useOrgIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                resultSet.add(row.getLong("id"));
            }
        }
        return resultSet;
    }

    @Deprecated
    public static Set<Long> queryAllAccIdsByUseOrgs(Collection<Long> useOrgIds) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(useOrgIds) ? 1 : 0) != 0);
        Object[] useOrgIdSet = new HashSet<Long>(useOrgIds).toArray(new Long[0]);
        StringBuilder sql = new StringBuilder("SELECT distinct fdataid id FROM T_BD_ACCOUNT_U WHERE fuseorgid IN (");
        for (int j = 0; j < useOrgIdSet.length; ++j) {
            sql.append(j > 0 ? ",?" : "?");
        }
        sql.append(") ");
        HashSet<Long> accIds = new HashSet<Long>(8);
        try (DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql.toString(), (Object[])useOrgIdSet);){
            for (Row row : dataSet) {
                accIds.add(row.getLong("id"));
            }
        }
        return accIds;
    }

    public static Set<Tuple<Long, Long>> listOrgUsedAccRelation(Collection<Long> useOrgIds, String accNumber, long masterId) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(useOrgIds) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)accNumber));
        Object[] useOrgIdSet = new HashSet<Long>(useOrgIds).toArray(new Long[0]);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT u.fdataid id, u.fuseorgid FROM T_BD_ACCOUNT_U AS u INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid");
        sql.append(" WHERE c.fmasterid = ").append(masterId);
        sql.append(" AND c.fnumber = '").append(accNumber).append("' ");
        sql.append(" AND c.fenddate = to_date('").append(LATEST_VERSION_DATE).append("') ");
        sql.append(" AND u.fuseorgid IN (");
        for (int j = 0; j < useOrgIdSet.length; ++j) {
            sql.append(j > 0 ? ",?" : "?");
        }
        sql.append(") ");
        HashSet<Tuple<Long, Long>> accOrgRelation = new HashSet<Tuple<Long, Long>>(8);
        try (DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql.toString(), (Object[])useOrgIdSet);){
            for (Row row : dataSet) {
                accOrgRelation.add((Tuple<Long, Long>)new Tuple((Object)row.getLong("id"), (Object)row.getLong("fuseorgid")));
            }
        }
        return accOrgRelation;
    }

    public static Map<Long, Set<Long>> listAccOrgDomainAccRelation(long masterId, long useOrgId) {
        BiTreeNode<Long, OrgVO> useOrgTree = BDUtil.buildSubTreeByOrgId(10, Optional.of(useOrgId));
        ArrayList<Long> useOrgDomain = new ArrayList<Long>(useOrgTree.collect(BiTreeNode::getId));
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT u.fdataid id, u.fuseorgid FROM T_BD_ACCOUNT_U AS u INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid WHERE ", new Object[0]);
        sql.append(" c.fmasterid = ?", new Object[]{masterId});
        sql.appendIn(" AND u.fuseorgid ", useOrgDomain);
        HashMap<Long, Set<Long>> accOrgRelation = new HashMap<Long, Set<Long>>(8);
        try (DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                long accId = row.getLong("id");
                long orgId = row.getLong("fuseorgid");
                if (null == accOrgRelation.get(accId)) {
                    accOrgRelation.put(accId, new HashSet(8));
                }
                ((Set)accOrgRelation.get(accId)).add(orgId);
            }
        }
        sql = new SqlBuilder();
        sql.append("SELECT u.fdataid id, u.fuseorgid FROM T_BD_ACCOUNTUSEREG AS u", new Object[0]);
        sql.append("INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid WHERE ", new Object[0]);
        sql.append(" c.fmasterid = ?", new Object[]{masterId});
        sql.appendIn(" AND u.fuseorgid ", useOrgDomain);
        dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sql);
        var9_7 = null;
        try {
            for (Row row : dataSet) {
                accOrgRelation.computeIfAbsent(row.getLong("id"), k -> new HashSet()).add(row.getLong("fuseorgid"));
            }
        }
        catch (Throwable throwable) {
            var9_7 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var9_7 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var9_7.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return accOrgRelation;
    }

    public static List<Long> getAssignRecordIds(long accId, long creatorOrgId) {
        String sql = " SELECT  mu.fuseorgid uoid from t_bd_accountusereg mu  where mu.fdataid = " + accId + " and mu.fuseorgid <> " + creatorOrgId;
        String dbRouteKey = EntityMetadataCache.getDataEntityType((String)"bd_accountview").getDBRouteKey();
        return (List)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> list = new ArrayList<Long>(8);
                while (rs.next()) {
                    list.add(rs.getLong(1));
                }
                return list;
            }
        });
    }

    public static Map<Long, Set<Long>> filterAccountsNoChildVersioning(Collection<Long> accIds, long operateOrg) {
        if (CollectionUtils.isEmpty(accIds)) {
            return Collections.EMPTY_MAP;
        }
        String pidsStr = String.join((CharSequence)",", accIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet()));
        StringBuilder acctsqlStr = new StringBuilder();
        acctsqlStr.append("select t1.fparentid parentid,t1.fid fid from t_bd_account t1,t_bd_account t2 where t2.fid=t1.fparentid and t1.fstartdate=t2.fstartdate ");
        acctsqlStr.append(" and t1.fparentid in (").append(pidsStr).append(") ");
        acctsqlStr.append(" and t1.fcreateorgid=").append(operateOrg);
        acctsqlStr.append(" and not exists (select 1 from t_bd_account where fmasterid=t1.fmasterid and fenddate=t1.fstartdate and flevel=t1.flevel)");
        HashMap<Long, Set<Long>> parentSubIds = new HashMap<Long, Set<Long>>(8);
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)acctsqlStr.toString());){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                Set subIds = parentSubIds.computeIfAbsent(row.getLong("parentid"), k -> new HashSet(8));
                subIds.add(row.getLong("fid"));
            }
        }
        return parentSubIds;
    }

    public static Map<Long, Set<Long>> filterAccountsWithBalanceDown(Collection<Long> accIds, long operateOrg) {
        if (CollectionUtils.isEmpty(accIds)) {
            return Collections.EMPTY_MAP;
        }
        String pidsStr = String.join((CharSequence)",", accIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet()));
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.fparentid parentid,t1.fid fid from t_bd_account t1,t_bd_account t2 where t1.fcreateorgid=");
        sql.append(operateOrg);
        sql.append(" and t1.fmasterid=t2.fmasterid and t1.forgid=t2.forgid and t1.flevel<>t2.flevel and t1.fstartdate=t2.fenddate ");
        sql.append(" and t1.fparentid in (").append(pidsStr).append(')');
        HashMap<Long, Set<Long>> parentIdAddsubIds = new HashMap<Long, Set<Long>>(8);
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql.toString());){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                Set subIds = parentIdAddsubIds.computeIfAbsent(row.getLong("parentid"), k -> new HashSet(8));
                subIds.add(row.getLong("fid"));
            }
        }
        return parentIdAddsubIds;
    }

    public static boolean isAccountCustomizedByOrgs(long accId, Collection<Long> specificOrgs) {
        return !AccountVersionUtil.getCustomizedOrgIds(accId, specificOrgs).isEmpty();
    }

    public static Set<String> getCustomizedOrgInfos(long accId, Collection<Long> specificOrgs) {
        HashSet<String> rtnResult = new HashSet<String>(10);
        Set<Long> customizedOrgIds = AccountVersionUtil.getCustomizedOrgIds(accId, specificOrgs);
        if (customizedOrgIds.isEmpty()) {
            return rtnResult;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "in", customizedOrgIds));
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bos_org", (String)"name,number", (QFilter[])qfBuilder.toArray());
        for (DynamicObject dyn : result) {
            rtnResult.add(dyn.getString("name") + "(" + dyn.getString("number") + ")");
        }
        return rtnResult;
    }

    private static Set<Long> getCustomizedOrgIds(long accId, Collection<Long> specificOrgs) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fuseorgid from t_bd_accountexc ");
        sql.append(" WHERE fdataid = ").append(accId);
        if (!CollectionUtils.isEmpty(specificOrgs)) {
            String orgIds = String.join((CharSequence)",", specificOrgs.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet()));
            sql.append(" AND fuseorgid in (").append(orgIds).append(')');
        }
        HashSet<Long> customizedOrgIds = new HashSet<Long>();
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql.toString());){
            for (Row row : dt) {
                customizedOrgIds.add(row.getLong("fuseorgid"));
            }
        }
        return customizedOrgIds;
    }

    @Deprecated
    public static boolean isAccountInitVersion(long accId, long accMasterId, String accNumber) {
        return !QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)accMasterId), new QFilter("id", "!=", (Object)accId), new QFilter("number", "=", (Object)accNumber)});
    }

    public static boolean isAccountInitVersion(DynamicObject accountVersion, long operateOrgId) {
        return !AccountVersionUtil.findPreviousAccountVersion(accountVersion, operateOrgId).isPresent();
    }

    public static boolean isAccountVersionalized(DynamicObject account) {
        return AccountVersionUtil.isAccountVersionalized(account.getDate("startdate"));
    }

    public static boolean isAccountVersionalized(Date startDate) {
        return startDate.compareTo(AccountVersionUtil.getInitBeginDate()) != 0;
    }

    public static Optional<DynamicObject> findPreviousAccountVersion(DynamicObject accountVersion, long operateOrgId) {
        QFilter lastAccFilter = new QFilter("masterid", "=", (Object)accountVersion.getLong("masterid"));
        lastAccFilter.and("createorg", "=", (Object)operateOrgId);
        lastAccFilter.and("number", "=", (Object)accountVersion.getString("number"));
        lastAccFilter.and("enddate", "=", (Object)accountVersion.getDate("startdate"));
        lastAccFilter.and("id", "!=", (Object)accountVersion.getLong("id"));
        DynamicObject lastVersionAcc = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (QFilter[])lastAccFilter.toArray());
        if (Objects.isNull(lastVersionAcc)) {
            long accTableId = accountVersion.getLong("accounttable_id");
            String accNumber = accountVersion.getString("number");
            String sql = String.format("SELECT r.fdataid, r.fcreateorgid FROM t_bd_accountusereg AS r  INNER JOIN t_bd_account AS c ON r.fdataid  = c.fid WHERE r.fuseorgid=%s AND r.fisassign='1'  AND c.faccounttableid = %s AND c.fnumber = '%s' order by c.fstartdate asc", operateOrgId, accTableId, accNumber);
            HashMap<Long, Long> assignOrgVersionAccMap = new HashMap<Long, Long>(8);
            DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql);
            Object object = null;
            try {
                while (dt.hasNext()) {
                    Row row = dt.next();
                    long assignOrgId = row.getLong("fcreateorgid");
                    long versionAccId = row.getLong("fdataid");
                    assignOrgVersionAccMap.put(assignOrgId, versionAccId);
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dt != null) {
                    if (object != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            if (!assignOrgVersionAccMap.isEmpty()) {
                List<Long> parentOrgIds = BDUtil.getAllSuperiorOrgIds(operateOrgId, false);
                for (Long pOrgId : parentOrgIds) {
                    if (!Objects.nonNull(assignOrgVersionAccMap.get(pOrgId))) continue;
                    long lastVersionId = (Long)assignOrgVersionAccMap.get(pOrgId);
                    return Optional.of(BusinessDataServiceHelper.loadSingle((Object)lastVersionId, (String)"bd_accountview"));
                }
            }
        }
        return Optional.ofNullable(lastVersionAcc);
    }

    public static Optional<Long> getParentAssignAccId(long operateOrgId, long accMasterId, String accNumber) {
        String sql = String.format("SELECT u.fdataid, a.fcreateorgid FROM t_bd_account_u AS u  INNER JOIN t_bd_account AS a ON u.fdataid  = a.fid WHERE a.fmasterid=%s AND a.fnumber = '%s' ", accMasterId, accNumber);
        HashMap<Long, Long> creatorOrgAccIdMap = new HashMap<Long, Long>(8);
        DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql);
        Object object = null;
        try {
            while (dt.hasNext()) {
                Row row = dt.next();
                long creatorOrgId = row.getLong("fcreateorgid");
                long accId = row.getLong("fdataid");
                creatorOrgAccIdMap.put(creatorOrgId, accId);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dt != null) {
                if (object != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dt.close();
                }
            }
        }
        if (!creatorOrgAccIdMap.isEmpty()) {
            List<Long> parentOrgIds = BDUtil.getAllSuperiorOrgIds(operateOrgId, false);
            for (Long pOrgId : parentOrgIds) {
                if (!Objects.nonNull(creatorOrgAccIdMap.get(pOrgId))) continue;
                long lastAssignAccId = (Long)creatorOrgAccIdMap.get(pOrgId);
                return Optional.of(lastAssignAccId);
            }
        }
        return Optional.empty();
    }

    public static DataSet getAllDirectSubordinateAccounts(long orgId, long accountTableId, String accLongNumber, int level) {
        if (orgId == 0L || StringUtils.isBlank((CharSequence)accLongNumber)) {
            return null;
        }
        QFilter filter = new QFilter("longnumber", "like", (Object)(accLongNumber + "%"));
        filter.and("level", "=", (Object)(level + 1));
        filter.and("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(filter);
        String fields = String.join((CharSequence)",", "isallowca", "accrualdirection", "ismanual", "acnotice", "ischangecurrency", "isqty", "acctcurrency", "isjournal");
        return AccountUtils.queryAccountDataSet(orgId, accountTableId, fields, filters);
    }

    public static DataSet getAllSubordinateOrgAccounts(long orgId, long accountTableId, String accountNumber) {
        if (orgId == 0L || StringUtils.isBlank((CharSequence)accountNumber)) {
            return null;
        }
        List allSubordinateOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(orgId), (boolean)false);
        if (allSubordinateOrgList.isEmpty()) {
            return null;
        }
        String fields = String.join((CharSequence)",", "isallowca", "accrualdirection", "ismanual", "acnotice", "ischangecurrency", "isqty", "acctcurrency", "isjournal");
        return BatchProcessUtil.batchQueryDataSet(allSubordinateOrgList, batchOrgs -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("createorg", "in", batchOrgs);
            qfBuilder.add("number", "=", accountNumber);
            qfBuilder.add("accounttable", "=", accountTableId);
            qfBuilder.add("enddate", "=", AccountVersionUtil.getEndDate());
            return QueryServiceHelper.queryDataSet((String)"AccountVersionUtil#getAllSubordinateOrgAccounts", (String)"bd_accountview", (String)fields, (QFilter[])qfBuilder.toArray(), null);
        });
    }

    @Deprecated
    public static Long getCurVersionPid(long orgId, String number) {
        QFilter forg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter fenddate = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        QFilter fnumber = new QFilter("number", "=", (Object)number);
        DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{forg, fnumber, fenddate});
        return acct.getLong("id");
    }

    public static DynamicObject getParentAcct(DynamicObject acctDyn, long useOrgId, Optional<String> selectProps, boolean forceLatestVersion) {
        if (acctDyn.getDynamicObject("parent") == null) {
            return null;
        }
        long acctTableId = acctDyn.getLong("accounttable_id");
        String pnumber = acctDyn.getDynamicObject("parent").getString("number");
        QFilter fnumber = new QFilter("number", "=", (Object)pnumber);
        QFilter baseFilter = AccountUtils.getAccountDataFilter(useOrgId, acctTableId);
        QFilter fDate = AccountVersionUtil.buildAccVersionEndDateFilter(acctDyn, forceLatestVersion);
        QFilter allFilter = fnumber.and(baseFilter).and(fDate);
        if (selectProps.isPresent()) {
            return BusinessDataServiceHelper.loadSingle((String)"bd_accountview", (String)selectProps.get(), (QFilter[])allFilter.toArray());
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (QFilter[])allFilter.toArray());
    }

    public static DynamicObject[] getChildAccts(DynamicObject acctDyn, long useOrgId, Optional<String> selectProps, boolean forceLatestVersion) {
        long acctTableId = acctDyn.getLong("accounttable_id");
        QFilter flongNumber = new QFilter("longnumber", "like", (Object)(acctDyn.getString("longnumber") + "%"));
        QFilter flevel = new QFilter("level", "=", (Object)(acctDyn.getInt("level") + 1));
        QFilter fDate = AccountVersionUtil.buildAccVersionEndDateFilter(acctDyn, forceLatestVersion);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(fDate);
        filters.add(flongNumber);
        filters.add(flevel);
        Set<Long> accPks = AccountUtils.queryAccountIds(useOrgId, acctTableId, filters);
        if (accPks.isEmpty()) {
            return new DynamicObject[0];
        }
        if (selectProps.isPresent()) {
            QFilter qFilter = new QFilter("id", "in", accPks);
            return BusinessDataServiceHelper.load((String)"bd_accountview", (String)selectProps.get(), (QFilter[])qFilter.toArray());
        }
        return BusinessDataServiceHelper.load((Object[])accPks.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
    }

    private static QFilter buildAccVersionEndDateFilter(DynamicObject acctDyn, boolean forceLatestVersion) {
        QFilter fDate;
        if (forceLatestVersion) {
            fDate = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        } else {
            Date endDate = acctDyn.getDate("enddate");
            if (endDate.compareTo(AccountVersionUtil.getEndDate()) == 0) {
                fDate = new QFilter("enddate", "=", (Object)endDate);
            } else {
                fDate = new QFilter("startdate", ">=", (Object)endDate);
                fDate = fDate.and(new QFilter("enddate", "<=", (Object)endDate));
            }
        }
        return fDate;
    }

    public static boolean personalize(Long orgId, Long masterId, Long dataId, String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("createorg", "=", (Object)orgId));
        qfBuilder.add(new QFilter("masterid", "=", (Object)masterId));
        qfBuilder.add(new QFilter("id", "!=", (Object)dataId));
        qfBuilder.add(new QFilter("number", "=", (Object)number));
        return !QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])qfBuilder.toArray());
    }

    public static boolean isVersionedChildAccount(Long orgId, Long masterId, Long dataId, String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("createorg", "=", (Object)orgId));
        qfBuilder.add(new QFilter("masterid", "=", (Object)masterId));
        qfBuilder.add(new QFilter("id", "!=", (Object)dataId));
        qfBuilder.add(new QFilter("number", "!=", (Object)number));
        return QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])qfBuilder.toArray());
    }

    public static Set<Long> queryAssignedRawOrgIds(long accId) {
        String sql = String.format("SELECT distinct u.fuseorgid FROM t_bd_account_u AS u  INNER JOIN t_bd_accountusereg AS reg ON u.fuseorgid = reg.fuseorgid AND u.fdataid = reg.fdataid  WHERE u.fdataid = %s ", accId);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql);){
            while (dt.hasNext()) {
                Row row = dt.next();
                orgIds.add(row.getLong("fuseorgid"));
            }
        }
        if (!orgIds.isEmpty()) {
            Set<Long> accountingOrgs = BDUtil.getAllAccountingOrgs();
            orgIds.retainAll(accountingOrgs);
        }
        return orgIds;
    }

    public static Map<Long, Set<Long>> queryBatchAssignedRawOrgIds(Collection<Long> accIds) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(accIds) ? 1 : 0) != 0);
        String sql = String.format("SELECT u.fdataid, u.fuseorgid FROM t_bd_account_u AS u  INNER JOIN t_bd_accountusereg AS reg ON u.fuseorgid = reg.fuseorgid AND u.fdataid = reg.fdataid  WHERE u.fdataid in (%s)", StringUtils.join((Object[])accIds.toArray(new Long[0]), (String)","));
        HashMap<Long, Set<Long>> accOrgsMap = new HashMap<Long, Set<Long>>(8);
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (String)sql);){
            while (dt.hasNext()) {
                Row row = dt.next();
                long accId = row.getLong("fdataid");
                accOrgsMap.putIfAbsent(accId, new HashSet(8));
                ((Set)accOrgsMap.get(accId)).add(row.getLong("fuseorgid"));
            }
        }
        accIds.stream().filter(x -> !accOrgsMap.containsKey(x)).forEach(x -> accOrgsMap.put((Long)x, Collections.EMPTY_SET));
        return accOrgsMap;
    }

    @Deprecated
    public static Optional<DynamicObject> getAccountLatestVersion(long masterId, String accNumber, long useOrgId, String selectProps) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("enable", "=", Boolean.TRUE);
        qfBuilder.add("number", "=", accNumber);
        qfBuilder.add("masterid", "=", masterId);
        qfBuilder.add("enddate", "=", AccountVersionUtil.getEndDate());
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)useOrgId));
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)"bd_accountview", (String)selectProps, (QFilter[])qfBuilder.toArray()));
    }

    @Deprecated
    public static DynamicObjectCollection listAccountFullVersion(long accId, long masterId, String accNumber, long useOrgId, String selectProps) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("enable", "=", Boolean.TRUE);
        if (AccountVersionUtil.isVersionedChildAccount(useOrgId, masterId, accId, accNumber)) {
            qfBuilder.add("number", "=", accNumber);
        }
        qfBuilder.add("masterid", "=", masterId);
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)useOrgId));
        return QueryServiceHelper.query((String)"bd_accountview", (String)selectProps, (QFilter[])qfBuilder.toArray(), (String)"startdate");
    }

    public static Map<Long, String> getAccountNameByIds(Collection<Long> accountIds) {
        QFilter idfilter = new QFilter("id", "in", accountIds);
        HashMap<Long, String> accountIdNameMap = new HashMap<Long, String>(8);
        try (DataSet dataSetSet = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getNumberByIds"), (String)"bd_accountview", (String)"id,name", (QFilter[])idfilter.toArray(), null);){
            for (Row row : dataSetSet) {
                accountIdNameMap.put(row.getLong("id"), row.getString("name"));
            }
            HashMap<Long, String> hashMap = accountIdNameMap;
            return hashMap;
        }
    }

    public static Map<Long, String> getOrgNameByIds(Collection<Long> orgIds) {
        QFilter idfilter = new QFilter("id", "in", orgIds);
        HashMap<Long, String> orgIdNameMap = new HashMap<Long, String>(8);
        try (DataSet dataSetSet = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getOrgNameByIds"), (String)"bos_org", (String)"id,name", (QFilter[])idfilter.toArray(), null);){
            for (Row row : dataSetSet) {
                orgIdNameMap.put(row.getLong("id"), row.getString("name"));
            }
            HashMap<Long, String> hashMap = orgIdNameMap;
            return hashMap;
        }
    }

    public static List<AssistEntryVO> getAddingAssistList(DynamicObject newAccount, DynamicObject dbAccount) {
        DynamicObjectCollection newCollection = newAccount.getDynamicObjectCollection("checkitementry");
        DynamicObjectCollection dbCollection = dbAccount.getDynamicObjectCollection("checkitementry");
        Map<Long, DynamicObject> newAssistIdEntryMap = newCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstactitem.id"), x -> x));
        Map<Long, DynamicObject> dbAssistIdEntryMap = dbCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstactitem.id"), x -> x));
        ArrayList<AssistEntryVO> addingAssistList = new ArrayList<AssistEntryVO>(newAssistIdEntryMap.size());
        for (Map.Entry<Long, DynamicObject> newEntry : newAssistIdEntryMap.entrySet()) {
            Long newId = newEntry.getKey();
            DynamicObject newAssistEntry = newEntry.getValue();
            boolean newMustInput = newAssistEntry.getBoolean("isrequire");
            boolean newIsLeaf = newAssistEntry.getBoolean("isdetail");
            boolean newIsAc = newAssistEntry.getBoolean("enaccheck");
            DynamicObject dbAssistEntry = dbAssistIdEntryMap.get(newId);
            if (dbAssistEntry == null) {
                addingAssistList.add(new AssistEntryVO(newId, newMustInput, newIsLeaf, newIsAc));
                continue;
            }
            boolean dbMustInput = dbAssistEntry.getBoolean("isrequire");
            boolean dbIsLeaf = dbAssistEntry.getBoolean("isdetail");
            boolean dbIsAc = dbAssistEntry.getBoolean("enaccheck");
            boolean noToYes = !dbMustInput && newMustInput || !dbIsLeaf && newIsLeaf || !dbIsAc && newIsAc;
            if (!noToYes) continue;
            addingAssistList.add(new AssistEntryVO(newId, newMustInput, newIsLeaf, newIsAc));
        }
        if (DebugTrace.enable()) {
            logger.info("batch_adding_assist sum up with:" + StringUtils.join((Object[])new List[]{addingAssistList}));
        }
        return addingAssistList;
    }

    public static List<AssistEntryVO> getAllAssistList(DynamicObject account) {
        DynamicObjectCollection newCollection = account.getDynamicObjectCollection("checkitementry");
        HashSet<Long> existAssists = new HashSet<Long>(newCollection.size());
        ArrayList<AssistEntryVO> assistList = new ArrayList<AssistEntryVO>(newCollection.size());
        for (DynamicObject newAssistEntry : newCollection) {
            Long newId = newAssistEntry.getLong("asstactitem.id");
            if (existAssists.contains(newId)) continue;
            existAssists.add(newId);
            boolean newMustInput = newAssistEntry.getBoolean("isrequire");
            boolean newIsLeaf = newAssistEntry.getBoolean("isdetail");
            boolean newIsAc = newAssistEntry.getBoolean("enaccheck");
            assistList.add(new AssistEntryVO(newId, newMustInput, newIsLeaf, newIsAc));
        }
        return assistList;
    }

    public static Map<Long, List<DynamicObject>> checkChildOrgAccVersion(DynamicObject specificAcc, Set<Long> childOrgIds) {
        DynamicObject periodByDate;
        HashMap<Long, List<DynamicObject>> childOrgAccountMap = new HashMap<Long, List<DynamicObject>>(8);
        Date enddate = specificAcc.getDate("startdate");
        Set<Long> periodType = PeriodUtil.getPeriodType(specificAcc.getDynamicObject(ORG).getLong("id"));
        if (!periodType.isEmpty() && (periodByDate = PeriodUtil.getPeriodByDate(specificAcc.getDate("startdate"), periodType.iterator().next())) != null) {
            enddate = periodByDate.getDate("enddate");
        }
        String sql = String.format("SELECT a.fid,a.fnumber,a.fctrlstrategy,u.fuseorgid,a.fenddate,a.fparentid,  a.fstartdate FROM t_bd_account AS a  INNER JOIN t_bd_account_u AS u ON u.fdataid = a.fid  WHERE u.fuseorgid IN (%s) AND a.faccounttableid = %s AND a.fenddate > to_date('%s') AND a.fenable = '%s' AND a.fnumber LIKE '%s';", org.apache.commons.lang3.StringUtils.join((Object[])childOrgIds.toArray(), (String)","), specificAcc.getLong("accounttable_id"), DateUtils.formatString((Date)enddate, (String)"yyyy-MM-dd"), "1", specificAcc.getString("number") + "%");
        try (DataSet accountDataSet = DB.queryDataSet((String)(BDUtil.class.getName() + "#checkChildOrgAccVersion"), (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            if (!accountDataSet.isEmpty()) {
                HashMap<Long, Long> accUseOrgMap = new HashMap<Long, Long>(8);
                for (Row row : accountDataSet) {
                    accUseOrgMap.put(row.getLong("fid"), row.getLong("fuseorgid"));
                }
                DynamicObject[] childOrgAccounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)USED_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "in", accUseOrgMap.keySet())});
                Arrays.stream(childOrgAccounts).forEach(x -> childOrgAccountMap.computeIfAbsent((Long)accUseOrgMap.get(x.getLong("id")), k -> new ArrayList(8)).add(x));
                HashMap<Long, List<DynamicObject>> hashMap = childOrgAccountMap;
                return hashMap;
            }
        }
        return childOrgAccountMap;
    }

    public static boolean isVersionAddLeaf(boolean isVersion, DynamicObject acct) {
        return isVersion && !acct.getDataEntityState().getFromDatabase() && Objects.nonNull(acct.getDynamicObject("parent"));
    }

    public static Set<Long> batchGetAvailableAccIds(Set<Long> masterIds, Set<Long> useOrgIds, long startPeriodId, long endPeriodId, boolean isIncludeDisable) {
        DynamicObjectCollection periodDyos = QueryServiceHelper.query((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter("id", "in", (Object)new Long[]{startPeriodId, endPeriodId}).toArray(), (String)"id asc");
        Date startDate = ((DynamicObject)periodDyos.get(0)).getDate("begindate");
        Date endDate = ((DynamicObject)periodDyos.get(periodDyos.size() - 1)).getDate("enddate");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("startdate", "<=", endDate);
        qfBuilder.add("enddate", ">", startDate);
        if (!isIncludeDisable) {
            qfBuilder.add("enable", "=", "1");
        }
        qfBuilder.add("masterid", "in", masterIds);
        DataSet accDs = QueryServiceHelper.queryDataSet((String)"batchGetAvailableAccIds", (String)"bd_accountview", (String)"id,ctrlstrategy", (QFilter[])qfBuilder.toArray(), null);
        HashSet<Long> availableAccIds = new HashSet<Long>(8);
        HashSet<Long> candidateAccIds = new HashSet<Long>(8);
        while (accDs.hasNext()) {
            Row accRow = accDs.next();
            long accId = accRow.getLong("id");
            if ("5".equals(accRow.getString("ctrlstrategy"))) {
                availableAccIds.add(accId);
                continue;
            }
            candidateAccIds.add(accId);
        }
        if (CollectionUtils.isEmpty(candidateAccIds)) {
            return availableAccIds;
        }
        try (DataSet dataSet = BatchProcessUtil.batchQueryDataSet(useOrgIds, batchOrgs -> {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select distinct fdataid id from t_bd_account_u  where ", new Object[0]);
            sqlBuilder.appendIn(" fdataid  ", candidateAccIds.toArray());
            sqlBuilder.appendIn(" and fuseorgid ", batchOrgs.toArray());
            return DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sqlBuilder);
        });){
            for (Row row : dataSet) {
                availableAccIds.add(row.getLong("id"));
            }
        }
        dataSet = BatchProcessUtil.batchQueryDataSet(useOrgIds, batchOrgs -> {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select distinct u.fdataid id from t_bd_accountusereg as u", new Object[0]);
            sqlBuilder.append("inner join t_bd_account as c on u.fdataid = c.fid where ", new Object[0]);
            sqlBuilder.appendIn(" c.fmasterid ", masterIds.toArray());
            sqlBuilder.appendIn(" and u.fuseorgid ", batchOrgs.toArray());
            return DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sqlBuilder);
        });
        var15_14 = null;
        try {
            for (Row row : dataSet) {
                availableAccIds.add(row.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            var15_14 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var15_14 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var15_14.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return availableAccIds;
    }

    public static boolean isRebuildDataUseRangeSystemProperty() {
        return BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.bd.account.version.refreshandrebuild", true);
    }

    public static boolean isUseNewAssignMethodSystemProperty() {
        return BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.bd.account.assign.supportorgmove", false);
    }

    public static boolean checkSuperOrgCurrAcc(String longNumber, long accountTableId, List<Long> superOrgIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select top 1 fid from t_bd_account a inner join t_bd_account_u b on a.fid = b.fdataid ", new Object[0]);
        sqlBuilder.append(" where a.flongnumber = ?", new Object[]{longNumber});
        sqlBuilder.append(" and a.faccounttableid = ? ", new Object[]{accountTableId});
        sqlBuilder.appendIn(" and b.fuseorgid ", superOrgIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)"AccountVersionUtil.checkSuperOrgCurrAcc", (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sqlBuilder);){
            if (dataSet.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean isCurrentOrgMoved(String number, long accountTableId, long useOrgId, List<Long> superOrgIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select top 1 fdataid from t_bd_account a inner join t_bd_accountusereg b on a.fid = b.fdataid where ", new Object[0]);
        sqlBuilder.append(" a.fnumber = ?", new Object[]{number});
        sqlBuilder.append(" AND b.fuseorgid = ?", new Object[]{useOrgId});
        sqlBuilder.append(" AND a.faccounttableid = ?", new Object[]{accountTableId});
        sqlBuilder.appendIn(" AND b.fassignorgid ", superOrgIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)"AccountVersionUtil.isCurrentOrgMoved", (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sqlBuilder);){
            if (dataSet.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean isCreatedByCurrOrg(DynamicObject account, long accTableId, long useorgId) {
        QFilter filter = new QFilter("id", "=", (Object)account.getLong("masterid"));
        filter.and(ORG, "=", (Object)useorgId);
        filter.and("accounttable_id", "=", (Object)accTableId);
        return QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{filter});
    }

    public static Map<Long, Long> getAccountVersionIdMap(long useOrgId, long accTableId, long curPeriod) {
        Object newestAccount;
        DataSet[] globalGroupData;
        if (DebugTrace.enable()) {
            logger.info("useOrgid:{},accTableId:{},curPeriod:{}", new Object[]{useOrgId, accTableId, curPeriod});
        }
        DynamicObject periodDyos = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)curPeriod).toArray());
        Date endDate = periodDyos.getDate("enddate");
        HashMap<Long, Long> map = new HashMap<Long, Long>(8);
        HashMap<Long, String> idNumMap = new HashMap<Long, String>(8);
        SqlBuilder globalSql = new SqlBuilder();
        globalSql.append("SELECT fid,fmasterid,fenddate,fnumber FROM t_bd_account where fctrlstrategy = '5' AND fstatus = 'C' ", new Object[0]);
        globalSql.append(" and faccounttableid = ?", new Object[]{accTableId});
        globalSql.append(" and fisleaf ='1'", new Object[0]);
        globalSql.append(" and fstartdate <=?", new Object[]{endDate});
        DataSet globalDataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)globalSql);
        for (DataSet group : globalGroupData = globalDataSet.splitByGroup(new String[]{"fmasterid"})) {
            newestAccount = group.copy().topBy(1, new String[]{"fenddate desc"});
            Long newestId = 0L;
            DataSet[] dataSetArray = newestAccount.iterator();
            while (dataSetArray.hasNext()) {
                Row row = (Row)dataSetArray.next();
                newestId = row.getLong("fid");
            }
            for (Row row : group) {
                long id = row.getLong("fid");
                map.put(id, newestId);
                idNumMap.put(id, row.getString("fnumber"));
            }
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT a.fid,u.fuseorgid,a.fnumber,a.fmasterid  from t_bd_accountusereg as u inner join t_Bd_account as a  on a.fid=u.fdataid  where ", new Object[0]);
        sql.append("  a.faccounttableid = ?", new Object[]{accTableId});
        sql.append(" and a.fisleaf ='1'", new Object[0]);
        sql.append(" and a.fstartdate <=?", new Object[]{endDate});
        sql.append(" and u.fuseorgid = ?", new Object[]{useOrgId});
        DataSet useregDataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)sql);
        SqlBuilder useSql = new SqlBuilder();
        useSql.append("SELECT a.fid,u.fuseorgid,a.fnumber,a.fenddate,a.fmasterid  from t_Bd_account_u as u inner join t_Bd_account as a  on a.fid=u.fdataid  where ", new Object[0]);
        useSql.append("  a.faccounttableid = ?", new Object[]{accTableId});
        useSql.append(" and a.fisleaf ='1'", new Object[0]);
        useSql.append(" and a.fstartdate <=?", new Object[]{endDate});
        useSql.append(" and u.fuseorgid = ?", new Object[]{useOrgId});
        DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)GL), (SqlBuilder)useSql);
        newestAccount = null;
        try {
            DataSet[] groupDataSet;
            for (DataSet group : groupDataSet = dataSet.splitByGroup(new String[]{"fmasterid"})) {
                if (group.isEmpty()) continue;
                Long newestId = group.copy().topBy(1, new String[]{"fenddate desc"}).next().getLong("fid");
                Long fMasterId = 0L;
                for (Row row : group) {
                    long id = row.getLong("fid");
                    map.put(id, newestId);
                    idNumMap.put(id, row.getString("fnumber"));
                    if (0L != fMasterId) continue;
                    fMasterId = row.getLong("fmasterid");
                }
                DataSet filterDataSet = useregDataSet.copy().filter("fmasterid = " + fMasterId);
                for (Row row : filterDataSet) {
                    long id = row.getLong("fid");
                    if (map.containsKey(id)) continue;
                    map.put(id, newestId);
                    idNumMap.put(id, row.getString("fnumber"));
                }
            }
        }
        catch (Throwable groupDataSet) {
            newestAccount = groupDataSet;
            throw groupDataSet;
        }
        finally {
            if (dataSet != null) {
                if (newestAccount != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable groupDataSet) {
                        ((Throwable)newestAccount).addSuppressed(groupDataSet);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (DebugTrace.enable()) {
            for (Map.Entry entry : map.entrySet()) {
                long originId = (Long)entry.getKey();
                long targetId = (Long)entry.getValue();
                logger.info("account mapping: id: {}, number: {} -> id: {}, number:{}", new Object[]{originId, idNumMap.get(originId), targetId, idNumMap.get(targetId)});
            }
        }
        return map;
    }

    static {
        USED_PROPS = String.join((CharSequence)",", Arrays.asList("id", "number", "name", "accounttable", "accrualdirection", "orgcontrollevel", "isallowca", "ismanual", "createorg", "iscash", "isbank", "iscashequivalent", "acnotice", "ischangecurrency", "isqty", "acctcurrency", "currencyentry", "currencyentry.currency", "dc", "asstactitem", "checkitementry.isrequire", "checkitementry.isdetail", "checkitementry.enaccheck", "asstactitem.flexfield", "startdate", "enddate"));
        CTRL_SHARE_STRATEGY = new HashSet<String>(Arrays.asList("5", "6"));
    }
}

