/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CashflowBizCheckUtil {
    private static final Log LOG = LogFactory.getLog(CashflowBizCheckUtil.class);

    public static Table<Long, Long, Integer> batchCheckAfterSpecificDate(Map<Long, Set<Long>> orgCfitemMap, Date specificDate) {
        Preconditions.checkArgument((boolean)Objects.nonNull(orgCfitemMap));
        if (Objects.isNull(specificDate)) {
            specificDate = CashflowItemVersionUtil.getCurDate();
        }
        long tick = System.currentTimeMillis();
        Set<Long> periodIds = BDUtil.getLaterCrossPeriods(specificDate);
        Set<Long> itemIds = orgCfitemMap.values().stream().filter(x -> Objects.nonNull(x)).flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (itemIds.isEmpty()) {
            return HashBasedTable.create();
        }
        Set<Long> orgs = orgCfitemMap.keySet();
        long balanceInitTick = System.currentTimeMillis();
        Multimap<Long, Long> balanceInitData = CashflowBizCheckUtil.checkBalanceInitHappen(itemIds, orgs, periodIds);
        LOG.info("query_biz_happen on balance init cost: " + (System.currentTimeMillis() - balanceInitTick));
        long balanceTick = System.currentTimeMillis();
        Multimap<Long, Long> balanceData = CashflowBizCheckUtil.checkBalanceHappen(orgCfitemMap, periodIds);
        LOG.info("query_biz_happen on balance cost: " + (System.currentTimeMillis() - balanceTick));
        long reciInitTick = System.currentTimeMillis();
        Multimap<Long, Long> reciInitData = CashflowBizCheckUtil.checkFrmBillHappen(itemIds, orgs, periodIds);
        LOG.info("query_biz_happen on reciInit cost: " + (System.currentTimeMillis() - reciInitTick));
        long voucherTick = System.currentTimeMillis();
        Multimap<Long, Long> voucherData = CashflowBizCheckUtil.checkVoucherHappen(itemIds, orgs, periodIds);
        LOG.info("query_biz_happen on voucher cost: " + (System.currentTimeMillis() - voucherTick));
        HashBasedTable result = HashBasedTable.create();
        for (Map.Entry<Long, Set<Long>> orgEntry : orgCfitemMap.entrySet()) {
            Long orgId = orgEntry.getKey();
            for (Long accountId : orgEntry.getValue()) {
                Integer bizType = BizType.NONE.value;
                if (balanceInitData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.BALANCE_INIT.value;
                }
                if (balanceData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.BALANCE.value;
                }
                if (reciInitData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.FRMBILL.value;
                }
                if (voucherData.containsEntry((Object)orgId, (Object)accountId)) {
                    bizType = bizType | BizType.VOUCHER.value;
                }
                result.put((Object)orgId, (Object)accountId, (Object)bizType);
            }
        }
        LOG.info(String.format("query_biz_happen on %s on date: %s cost: %s", SerializationUtils.toJsonString(orgCfitemMap), DateFormatUtils.format((Date)specificDate, (String)"yyyy-MM-dd"), System.currentTimeMillis() - tick));
        return result;
    }

    public static Multimap<Long, Long> checkBalanceInitHappen(Set<Long> itemIds, Set<Long> orgIds, Set<Long> periodIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return LinkedListMultimap.create();
        }
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(8);
        if (!CollectionUtils.isEmpty(orgIds)) {
            QFilter qf = new QFilter("org", "in", orgIds);
            qfs.add(qf);
        }
        if (!CollectionUtils.isEmpty(periodIds)) {
            QFilter qperiod = new QFilter("startperiod", "in", periodIds);
            qfs.add(qperiod);
        }
        DynamicObjectCollection bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype", qfs.isEmpty() ? null : qfs.toArray(new QFilter[0]));
        HashMap<Long, Set> orgBooktypes = new HashMap<Long, Set>(bookColl.size());
        for (DynamicObject book : bookColl) {
            orgBooktypes.computeIfAbsent(book.getLong("org"), k -> new HashSet()).add(book.getLong("bookstype"));
        }
        if (orgBooktypes.isEmpty()) {
            return LinkedListMultimap.create();
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fcfitemid,forgid,fbooktypeid from t_gl_initcashflow where ftabdelete = '0' and ", new Object[0]);
        sqlBuilder.appendIn("fcfitemid ", new ArrayList<Long>(itemIds));
        if (!orgBooktypes.isEmpty()) {
            sqlBuilder.appendIn(" and forgid ", new ArrayList(orgBooktypes.keySet()));
            HashSet btIds = new HashSet(orgBooktypes.size());
            orgBooktypes.values().forEach(x -> btIds.addAll(x));
            sqlBuilder.appendIn(" and fbooktypeid ", new ArrayList(btIds));
        }
        LinkedListMultimap result = LinkedListMultimap.create();
        try (DataSet dataSet = DB.queryDataSet((String)CashflowBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                long orgId = row.getLong("forgid");
                long accId = row.getLong("fcfitemid");
                result.put((Object)orgId, (Object)accId);
            }
        }
        return result;
    }

    public static Multimap<Long, Long> checkFrmBillHappen(Set<Long> itemIds, Set<Long> orgIds, Set<Long> periodIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return LinkedListMultimap.create();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT c.fmaincfitem, b.ftallycompany FROM t_fr_manutalbill b inner join t_fr_manutalentry c on b.fid=c.fid WHERE", new Object[0]);
        sql.appendIn(" c.fmaincfitem ", itemIds.toArray());
        if (!CollectionUtils.isEmpty(orgIds)) {
            sql.appendIn(" AND b.ftallycompany ", orgIds.toArray());
        }
        if (!CollectionUtils.isEmpty(periodIds)) {
            sql.appendIn(" AND b.fperiod ", periodIds.toArray());
        }
        sql.append(" group by c.fmaincfitem, b.ftallycompany ", new Object[0]);
        LinkedListMultimap result = LinkedListMultimap.create();
        try (DataSet dataSet = DB.queryDataSet((String)CashflowBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                long orgId = row.getLong("ftallycompany");
                long itemId = row.getLong("fmaincfitem");
                result.put((Object)orgId, (Object)itemId);
            }
        }
        return result;
    }

    public static Multimap<Long, Long> checkBalanceHappen(Map<Long, Set<Long>> orgCfitemMap, Set<Long> periodIds) {
        Set itemIds = orgCfitemMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(itemIds)) {
            return LinkedListMultimap.create();
        }
        HashMap mid2itemIdMap = new HashMap(8);
        QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id,masterid", (QFilter[])new QFilter("id", "in", itemIds).toArray()).stream().forEach(x -> {
            long masterId = x.getLong("masterid");
            mid2itemIdMap.putIfAbsent(masterId, new HashSet(8));
            ((Set)mid2itemIdMap.get(masterId)).add(x.getLong("id"));
        });
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT b.fcfitemid masterid, b.forgid FROM t_gl_cashflow b WHERE ", new Object[0]);
        sqlBuilder.appendIn(" b.fcfitemid ", new ArrayList(mid2itemIdMap.keySet()));
        Set<Long> orgIds = orgCfitemMap.keySet();
        if (!CollectionUtils.isEmpty(orgIds)) {
            sqlBuilder.appendIn(" and b.forgid ", new ArrayList<Long>(orgIds));
        }
        if (!CollectionUtils.isEmpty(periodIds)) {
            sqlBuilder.appendIn(" and b.fperiodid ", new ArrayList<Long>(periodIds));
        }
        LinkedListMultimap result = LinkedListMultimap.create();
        try (DataSet dataSet = DB.queryDataSet((String)CashflowBizCheckUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                long orgId = row.getLong("forgid");
                Set ownCfIds = orgCfitemMap.getOrDefault(orgId, new HashSet(8));
                long masterId = row.getLong("masterid");
                HashSet ids = new HashSet(mid2itemIdMap.getOrDefault(masterId, new HashSet(8)));
                ids.retainAll(ownCfIds);
                if (CollectionUtils.isEmpty(ids)) continue;
                ids.stream().forEach(arg_0 -> CashflowBizCheckUtil.lambda$checkBalanceHappen$6((Multimap)result, orgId, arg_0));
            }
        }
        return result;
    }

    public static Multimap<Long, Long> checkVoucherHappen(Set<Long> itemIds, Set<Long> orgIds, Set<Long> periodIds) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(itemIds) ? 1 : 0) != 0);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(orgIds) ? 1 : 0) != 0);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(periodIds) ? 1 : 0) != 0);
        if (CollectionUtils.isEmpty(itemIds)) {
            return LinkedListMultimap.create();
        }
        LinkedListMultimap result = LinkedListMultimap.create();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)CashflowBizCheckUtil.class.getName(), (String)"gl_voucher", (String)"org,entries.maincfitem item", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("period", "in", periodIds), new QFilter("entries.maincfitem", "in", itemIds)}, null).groupBy(new String[]{"org", "item"}).finish();){
            for (Row row : ds) {
                long orgId = row.getLong("org");
                long accId = row.getLong("item");
                result.put((Object)orgId, (Object)accId);
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$checkBalanceHappen$6(Multimap result, long orgId, Long x) {
        result.put((Object)orgId, (Object)x);
    }

    public static enum BizType {
        NONE(0),
        BALANCE_INIT(1),
        BALANCE(2),
        FRMBILL(4),
        VOUCHER(8);

        private int value;

        private BizType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getDesc() {
            switch (this.value) {
                case 0: {
                    return ResManager.loadKDString((String)"\u65e0\u4e1a\u52a1\u53d1\u751f", (String)"CashflowBizCheckUtil_0", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 1: {
                    return ResManager.loadKDString((String)"\u4f59\u989d\u521d\u59cb\u5316", (String)"CashflowBizCheckUtil_1", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 2: {
                    return ResManager.loadKDString((String)"\u4f59\u989d", (String)"CashflowBizCheckUtil_2", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 4: {
                    return ResManager.loadKDString((String)"\u901a\u7528\u8f6c\u8d26\u7533\u8bf7\u5355", (String)"CashflowBizCheckUtil_3", (String)"fi-bd-common", (Object[])new Object[0]);
                }
                case 8: {
                    return ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"CashflowBizCheckUtil_4", (String)"fi-bd-common", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public static BizType getBizType(int value) {
            BizType[] values;
            for (BizType bizType : values = BizType.values()) {
                if (bizType.value != value) continue;
                return bizType;
            }
            throw new IllegalStateException("invalid BizType value:" + value);
        }

        public static boolean containType(int value, BizType type) {
            return (value & type.value) == type.value;
        }

        public static Set<BizType> withTypes(int value) {
            return Arrays.stream(BizType.values()).filter(x -> NONE != x).filter(x -> x.isIn(value)).collect(Collectors.toSet());
        }

        public boolean isIn(int value) {
            return (value & this.value) == this.value;
        }
    }
}

