/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.cfversion.bizchecker.CashflowBalChecker;
import kd.fi.bd.cfversion.bizchecker.CashflowLogChecker;
import kd.fi.bd.cfversion.bizchecker.ExistBizChecker;
import kd.fi.bd.cfversion.bizchecker.InitCashflowChecker;
import kd.fi.bd.cfversion.bizchecker.ManualtallybillChecker;
import kd.fi.bd.cfversion.bizchecker.TempVoucherChecker;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.bd.util.PerformanceMonitor;

public class CashflowItemCheckUtil {
    private static List<ExistBizChecker> checkers = new ArrayList<ExistBizChecker>(4);

    public static List<Long> getExistInitCashflow(List<Long> cfItemIds) {
        if (cfItemIds.size() == 0) {
            return new ArrayList<Long>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcfitemid from t_gl_initcashflow where ", new Object[0]);
        sqlBuilder.appendIn("fcfitemid ", new ArrayList<Long>(cfItemIds));
        sqlBuilder.append("group by fcfitemid", new Object[0]);
        return PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> existIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    existIds.add(rs.getLong(1));
                }
                return existIds;
            }
        }), 10, sqlBuilder);
    }

    public static List<Long> getExistSaveVoucher(List<Long> cfItemIds) {
        if (cfItemIds.size() == 0) {
            return new ArrayList<Long>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcashflowitemid from t_gl_tempvoucher_cf_index where", new Object[0]);
        sqlBuilder.appendIn("fcashflowitemid ", new ArrayList<Long>(cfItemIds));
        sqlBuilder.append("group by fcashflowitemid", new Object[0]);
        return PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> existIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    existIds.add(rs.getLong(1));
                }
                return existIds;
            }
        }), 10, sqlBuilder);
    }

    public static List<Long> getExistCashflow(List<Long> cfItemMasteridIds) {
        if (cfItemMasteridIds.size() == 0) {
            return new ArrayList<Long>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcfitemid from t_gl_cashflow where ", new Object[0]);
        sqlBuilder.appendIn("fcfitemid ", new ArrayList<Long>(cfItemMasteridIds));
        sqlBuilder.append("group by fcfitemid", new Object[0]);
        return PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> existIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    existIds.add(rs.getLong(1));
                }
                return existIds;
            }
        }), 10, sqlBuilder);
    }

    public static List<Long> getExistCashflowLog(List<Long> cfItemIds) {
        if (cfItemIds.size() == 0) {
            return new ArrayList<Long>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcfitemid from t_gl_cashflow_log where ", new Object[0]);
        sqlBuilder.append("fcalculated = '0' ", new Object[0]);
        sqlBuilder.appendIn("and fcfitemid ", new ArrayList<Long>(cfItemIds));
        sqlBuilder.append("group by fcfitemid", new Object[0]);
        return PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> existIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    existIds.add(rs.getLong(1));
                }
                return existIds;
            }
        }), 10, sqlBuilder);
    }

    public static List<Long> getExistInitCashflowByOrg(List<Long> cfItemIds, List<Long> booktype, List<Long> orgs) {
        if (cfItemIds.size() == 0 || orgs.size() == 0) {
            return new ArrayList<Long>(1);
        }
        List<List> result = BatchProcessUtil.batchProcess(orgs, splitOrg -> {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fcfitemid from t_gl_initcashflow where ", new Object[0]);
            sqlBuilder.appendIn("forgid ", new ArrayList(splitOrg));
            sqlBuilder.appendIn(" and fcfitemid ", new ArrayList(cfItemIds));
            sqlBuilder.append("group by fcfitemid", new Object[0]);
            return (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

                public List<Long> handle(ResultSet rs) throws Exception {
                    ArrayList<Long> existIds = new ArrayList<Long>(16);
                    while (rs.next()) {
                        existIds.add(rs.getLong(1));
                    }
                    return existIds;
                }
            });
        });
        ArrayList<Long> existIds = new ArrayList<Long>();
        for (List list : result) {
            existIds.addAll(list);
        }
        return existIds;
    }

    public static List<Long> getExistSaveVoucherByOrg(List<Long> cfItemIds, List<Long> orgs) {
        if (cfItemIds.size() == 0 || orgs.size() == 0) {
            return new ArrayList<Long>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcashflowitemid from t_gl_tempvoucher_cf_index where ", new Object[0]);
        sqlBuilder.appendIn("forgid ", new ArrayList<Long>(orgs));
        sqlBuilder.appendIn(" and fcashflowitemid ", new ArrayList<Long>(cfItemIds));
        sqlBuilder.append(" group by fcashflowitemid", new Object[0]);
        return PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> existIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    existIds.add(rs.getLong(1));
                }
                return existIds;
            }
        }), 10, sqlBuilder);
    }

    public static List<Long> getExistCashflowByOrg(List<Long> cfItemMasteridIds, List<Long> orgs) {
        if (cfItemMasteridIds.size() == 0 || orgs.size() == 0) {
            return new ArrayList<Long>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcfitemid from t_gl_cashflow where ", new Object[0]);
        sqlBuilder.appendIn("forgid ", new ArrayList<Long>(orgs));
        sqlBuilder.appendIn("and fcfitemid ", new ArrayList<Long>(cfItemMasteridIds));
        sqlBuilder.append("group by fcfitemid", new Object[0]);
        return PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> existIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    existIds.add(rs.getLong(1));
                }
                return existIds;
            }
        }), 10, sqlBuilder);
    }

    public static List<Long> getExistCashflowLogByOrg(List<Long> cfItemIds, List<Long> orgs) {
        if (cfItemIds.size() == 0 || orgs.size() == 0) {
            return new ArrayList<Long>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fcfitemid from t_gl_cashflow_log where ", new Object[0]);
        sqlBuilder.appendIn("forgid ", new ArrayList<Long>(orgs));
        sqlBuilder.append("and fcalculated = '0' ", new Object[0]);
        sqlBuilder.appendIn("and fcfitemid ", new ArrayList<Long>(cfItemIds));
        sqlBuilder.append("group by fcfitemid", new Object[0]);
        return PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> existIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    existIds.add(rs.getLong(1));
                }
                return existIds;
            }
        }), 10, sqlBuilder);
    }

    public static List<Long> getBookTypes() {
        ArrayList<Long> bookTypes = new ArrayList<Long>(1);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashflowItemCheckUtil", (String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[0], (String)"");){
            for (Row row : ds) {
                bookTypes.add(row.getLong("id"));
            }
        }
        return bookTypes;
    }

    public static boolean existsBizOnOrg(long masterId, long specificOrg, Date startDate) {
        String key = String.join((CharSequence)"-", String.valueOf(masterId), String.valueOf(specificOrg), String.valueOf(startDate));
        return (Boolean)ThreadCache.get((Object)key, () -> {
            DynamicObject cfitem = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"ctrlstrategy", (QFilter[])new QFilter("id", "=", (Object)masterId).toArray());
            boolean _isExistBiz = false;
            if (AccountVersionUtil.CTRL_SHARE_STRATEGY.contains(cfitem.getString("ctrlstrategy"))) {
                Set cfitemIdSet = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter("masterid", "=", (Object)masterId).toArray()).stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                Iterator iterator = cfitemIdSet.iterator();
                while (iterator.hasNext()) {
                    long cfitemId = (Long)iterator.next();
                    if (!CashflowItemCheckUtil.existOnLaterPeriods(cfitemId, Collections.EMPTY_LIST, startDate)) continue;
                    _isExistBiz = true;
                    break;
                }
            } else {
                Map<Long, Set<Long>> cfrelations = CashflowItemVersionUtil.item2UserOrgRelation(masterId, specificOrg);
                for (Map.Entry<Long, Set<Long>> cfIdUseOrgsEntry : cfrelations.entrySet()) {
                    long _Id = cfIdUseOrgsEntry.getKey();
                    if (!CashflowItemCheckUtil.existOnLaterPeriods(_Id, new ArrayList<Object>((Collection)cfIdUseOrgsEntry.getValue()), startDate)) continue;
                    _isExistBiz = true;
                    break;
                }
            }
            return _isExistBiz;
        }, (boolean)true);
    }

    public static boolean existOnLaterPeriods(long itemId, List<Object> orgIds, Date versionDate) {
        Set<Object> periods = new HashSet();
        QFilter fid = new QFilter("id", "=", (Object)itemId);
        DynamicObject object = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"masterid", (QFilter[])new QFilter[]{fid});
        long masterId = object.getLong("masterid");
        if (versionDate != null) {
            periods = BDUtil.getLaterCrossPeriods(versionDate);
        }
        for (ExistBizChecker checker : checkers) {
            if (!checker.isExist(orgIds, masterId, itemId, new ArrayList<Object>(periods))) continue;
            return true;
        }
        return false;
    }

    public static long getParentOrgId(Object useorgId) {
        QFilter q1 = new QFilter("org", "=", useorgId);
        QFilter q2 = new QFilter("view", "=", (Object)10);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])new QFilter[]{q1, q2});
        return org.getLong("parent");
    }

    static {
        checkers.add(new CashflowBalChecker());
        checkers.add(new InitCashflowChecker());
        checkers.add(new CashflowLogChecker());
        checkers.add(new TempVoucherChecker());
        checkers.add(new ManualtallybillChecker());
    }
}

