/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.ThreadCacheKey;
import kd.bos.flex.FlexService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.util.MasterBaseDataUtils;
import org.apache.commons.lang3.tuple.Triple;

public class FlexUtils {
    public static final String T_GL_ASSIST = "T_GL_ASSIST";
    public static final String GL = "gl";
    private static Log logger = LogFactory.getLog(FlexUtils.class);
    private static MainEntityType MAIN_ENTITY_TYPE = null;

    private FlexUtils() {
    }

    public static Map<String, Long> getAllFlexFieldIdMap() {
        return (Map)ThreadCache.get((Object)(FlexUtils.class.getName() + "#getAllFlexFieldIdMap"), () -> {
            Map allFlexCacheMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"id,flexfield", null);
            return allFlexCacheMap.values().stream().collect(Collectors.toMap(x -> x.getString("flexfield"), x -> x.getLong("id"), (oldVal, newVal) -> newVal));
        });
    }

    public static Map<String, FlexProperty> batchGetFlexProperty(String ... flexFields) {
        if (flexFields == null || flexFields.length == 0) {
            return Collections.emptyMap();
        }
        Map<String, Long> flexFieldIdMap = FlexUtils.getAllFlexFieldIdMap();
        if (flexFieldIdMap.isEmpty()) {
            return Collections.emptyMap();
        }
        List flexIdList = Arrays.stream(flexFields).map(flexFieldIdMap::get).filter(x -> x != null && x > 0L).collect(Collectors.toList());
        if (flexIdList.isEmpty()) {
            return Collections.emptyMap();
        }
        return FlexEntityMetaUtils.getFlexProperty(flexIdList).stream().collect(Collectors.toMap(FlexProperty::getFlexField, x -> x, (oldVal, newVal) -> newVal));
    }

    public static FlexProperty getFlexProperty(String flexField) {
        return FlexUtils.batchGetFlexProperty(flexField).get(flexField);
    }

    public static Object reloadBaseDataValue(String flexField, Object value) {
        if (flexField == null || value == null) {
            return value;
        }
        return FlexUtils.reloadBaseDataValue(FlexUtils.getFlexProperty(flexField), value);
    }

    public static Object reloadBaseDataValue(FlexProperty flexProperty, Object value) {
        if (flexProperty == null || value == null) {
            return value;
        }
        if ("3".equalsIgnoreCase(flexProperty.getValueType())) {
            return value;
        }
        return ThreadCache.get((Object)ThreadCacheKey.getReloadFlexMasterIdKey(flexProperty.getValueSource(), value), () -> MasterBaseDataUtils.reloadMasterId(flexProperty.getValueSource(), value));
    }

    public static long saveFlexData(Map<String, Object> flexFieldToValue, boolean isReLoadMasterId) {
        Objects.requireNonNull(flexFieldToValue);
        if (flexFieldToValue.isEmpty()) {
            return 0L;
        }
        return FlexUtils.saveSingleFlexData(FlexUtils.buildFlexEntireData(flexFieldToValue, isReLoadMasterId));
    }

    public static FlexEntireData buildFlexEntireData(Map<String, Object> flexFieldToValue, boolean isReLoadMasterId) {
        Map<String, FlexProperty> flexPropertyMap = FlexUtils.batchGetFlexProperty(flexFieldToValue.keySet().toArray(new String[0]));
        Map<FlexProperty, Object> flexPropValueMap = flexFieldToValue.entrySet().stream().filter(x -> flexPropertyMap.containsKey(x.getKey())).collect(Collectors.toMap(x -> (FlexProperty)flexPropertyMap.get(x.getKey()), Map.Entry::getValue, (oldVal, newVal) -> newVal));
        return FlexUtils.buildFlexEntireDataByProperty(flexPropValueMap, isReLoadMasterId);
    }

    public static FlexEntireData buildFlexEntireDataByProperty(Map<FlexProperty, Object> flexPropValueMap, boolean isReLoadMasterId) {
        ArrayList flexDataList = new ArrayList(flexPropValueMap.size());
        FlexEntireData flexEntireData = new FlexEntireData();
        flexPropValueMap.forEach((flexProperty, value) -> {
            if (null != value) {
                boolean isTxtType = "3".equals(flexProperty.getValueType());
                if (!isTxtType && isReLoadMasterId) {
                    long masterId = MasterBaseDataUtils.reloadMasterId(flexProperty.getValueSource(), value);
                    if (masterId > 0L) {
                        flexDataList.add(FlexUtils.createSinlgeFlexData(flexEntireData, flexProperty, masterId));
                    }
                } else {
                    flexDataList.add(FlexUtils.createSinlgeFlexData(flexEntireData, flexProperty, value));
                }
            }
        });
        flexEntireData.setFlexDatas(flexDataList);
        return flexEntireData;
    }

    private static FlexEntireData.FlexData createSinlgeFlexData(FlexEntireData flexEntireData, FlexProperty flexProperty, Object value) {
        FlexEntireData flexEntireData2 = flexEntireData;
        flexEntireData2.getClass();
        FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData2, flexProperty, value);
        FlexEntireData.FlexFieldDataType flexFieldDataType = "3".equals(flexProperty.getValueType()) ? FlexEntireData.FlexFieldDataType.STRING : FlexEntireData.FlexFieldDataType.LONG;
        flexData.setDbType(flexFieldDataType);
        return flexData;
    }

    private static Long saveSingleFlexData(FlexEntireData flexEntireData) {
        return FlexService.saveFlexData((MainEntityType)FlexUtils.getMainEntityType(), (FlexEntireData)flexEntireData);
    }

    private static MainEntityType getMainEntityType() {
        if (null == MAIN_ENTITY_TYPE) {
            MAIN_ENTITY_TYPE = new MainEntityType();
            MAIN_ENTITY_TYPE.setAlias(T_GL_ASSIST);
            MAIN_ENTITY_TYPE.setDBRouteKey(GL);
        }
        return MAIN_ENTITY_TYPE;
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnBalance(Map<String, Set<Object>> flexFilter) {
        try {
            Map<String, FlexProperty> propInfos = FlexUtils.batchGetFlexProperty(flexFilter.keySet().toArray(new String[0]));
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_balance").clone();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(propInfos.size());
            ArrayList<String> selectFields = new ArrayList<String>(propInfos.size());
            for (Map.Entry<String, FlexProperty> entry : propInfos.entrySet()) {
                FlexProperty flexProperty = entry.getValue();
                DynamicObjectType type = StringUtils.isEmpty((CharSequence)flexProperty.getValueSource()) ? (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_assist_txt").clone() : (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_assist_bd").clone();
                BasedataProp prop = new BasedataProp();
                prop.setAlias("fassgrpid");
                prop.setName("assgrp_" + entry.getKey());
                prop.setComplexType((IDataEntityType)type);
                ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
                balEntity.addProperty((DynamicProperty)prop);
                String flexField = "assgrp_" + entry.getKey();
                if (!flexFilter.get(entry.getKey()).isEmpty()) {
                    qFilters.add(new QFilter(flexField + ".asstype", "=", (Object)entry.getKey()));
                    qFilters.add(new QFilter(flexField + ".assval", "in", flexFilter.get(entry.getKey())));
                } else {
                    qFilters.add(QFilter.join((String)flexField, (String)(flexField + ".hg"), (QFilter)new QFilter(flexField + ".asstype", "=", (Object)entry.getKey()), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
                }
                selectFields.add(String.format("%s.assval %s", flexField, entry.getKey()));
            }
            return Triple.of((Object)balEntity, qFilters, selectFields);
        }
        catch (CloneNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }
}

