/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheHelper;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.enums.ConversionMethod;
import kd.fi.bd.vo.MulLocalCurrencyVO;

public class LocalCurrencyUtil {
    public static final String ENABLE_GROUP_LOCAL_CURRENCY = "enablegrplocalcur";
    public static final String GROUP_LOCAL_CURRENCY = "grplocalcur";
    public static final String EXCHANGE_RATE_TABLE = "exratetable";
    public static final String CONVERSION_METHOD = "conversionmethod";
    private static final String DELIMITER = ",";
    private static final String USE_GROUP_CURRENCY_KEY = "useGroupLocalCurrency";
    private static final String USE_SECOND_CURRENCY_KEY = "useSecondLocalCurrency";
    private static final String USE_THIRD_CURRENCY_KEY = "useThirdLocalCurrency";
    private static final String ALL_MUL_LOCAL_CURRENCY_KEY = "allMulLocalCurrency";
    private static final String MUL_LOCAL_CURRENCY_GROUP = "";
    private static final String SECOND_LOCAL_CURRENCY = "seclocalcur";
    private static final String SECOND_LOCAL_CURRENCY_ID = "seclocalcur_id";
    private static final String SECOND_EXRATE_TABLE = "secexratetable";
    private static final String SECOND_EXRATE_TABLE_ID = "secexratetable_id";
    private static final String THIRD_LOCAL_CURRENCY = "trdlocalcur";
    private static final String THIRD_LOCAL_CURRENCY_ID = "trdlocalcur_id";
    private static final String THIRD_EXRATE_TABLE = "trdexratetable";
    private static final String THIRD_EXRATE_TABLE_ID = "trdexratetable_id";

    @Deprecated
    public static boolean isUseGroupLocalCurrency() {
        return LocalCurrencyUtil.queryUseMulLocalCurrency(USE_GROUP_CURRENCY_KEY, "bd_accountingsys", new QFilter[]{new QFilter(ENABLE_GROUP_LOCAL_CURRENCY, "=", (Object)true)});
    }

    @Deprecated
    public static boolean isUseSecondLocalCurrency() {
        return LocalCurrencyUtil.queryUseMulLocalCurrency(USE_SECOND_CURRENCY_KEY, "gl_accountbook", new QFilter[]{new QFilter(SECOND_LOCAL_CURRENCY, "!=", (Object)0L)});
    }

    @Deprecated
    public static boolean isUseThirdLocalCurrency() {
        return LocalCurrencyUtil.queryUseMulLocalCurrency(USE_THIRD_CURRENCY_KEY, "gl_accountbook", new QFilter[]{new QFilter(THIRD_LOCAL_CURRENCY, "!=", (Object)0L)});
    }

    @Deprecated
    public static boolean isUseMulLocalCurrency() {
        return LocalCurrencyUtil.isUseGroupLocalCurrency() || LocalCurrencyUtil.isUseSecondLocalCurrency() || LocalCurrencyUtil.isUseThirdLocalCurrency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean queryUseMulLocalCurrency(String cacheKey, String entityName, QFilter[] qFilters) {
        LocalCacheKey localCacheKey = LocalCurrencyUtil.buildCacheKey(cacheKey);
        Boolean useGroupLocalCurrency = (Boolean)LocalCacheHelper.get((LocalCacheKey)localCacheKey, Boolean.class);
        if (!Objects.isNull(useGroupLocalCurrency)) return useGroupLocalCurrency;
        Class<LocalCurrencyUtil> clazz = LocalCurrencyUtil.class;
        synchronized (LocalCurrencyUtil.class) {
            useGroupLocalCurrency = (Boolean)LocalCacheHelper.get((LocalCacheKey)localCacheKey, Boolean.class);
            if (!Objects.isNull(useGroupLocalCurrency)) return useGroupLocalCurrency;
            useGroupLocalCurrency = QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
            LocalCacheHelper.put((LocalCacheKey)localCacheKey, (Object)useGroupLocalCurrency);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return useGroupLocalCurrency;
        }
    }

    @Deprecated
    public static Optional<MulLocalCurrencyVO> getMulLocalCurrency(long orgId, long bookTypeId) {
        MulLocalCurrencyVO mulLocalCurrencyVO;
        if (LocalCurrencyUtil.isUseMulLocalCurrency() && Objects.nonNull(mulLocalCurrencyVO = (MulLocalCurrencyVO)LocalCurrencyUtil.getAllMulLocalCurrency().get((Object)orgId, (Object)bookTypeId))) {
            return Optional.of(mulLocalCurrencyVO);
        }
        return Optional.empty();
    }

    @Deprecated
    public static Optional<Table<Long, Long, MulLocalCurrencyVO>> getMulLocalCurrencyTable(Collection<Long> orgIds, Collection<Long> bookTypeIds) {
        Table<Long, Long, MulLocalCurrencyVO> allMulLocalCurrencyTable;
        Set<Table.Cell> mulLocalCurrencyCellSet;
        if (LocalCurrencyUtil.isUseMulLocalCurrency() && CollectionUtils.isNotEmpty(mulLocalCurrencyCellSet = (allMulLocalCurrencyTable = LocalCurrencyUtil.getAllMulLocalCurrency()).cellSet().stream().filter(cellSet -> orgIds.contains(cellSet.getRowKey()) && bookTypeIds.contains(cellSet.getColumnKey())).collect(Collectors.toSet()))) {
            HashBasedTable mulLocalCurrencyTable = HashBasedTable.create();
            mulLocalCurrencyCellSet.forEach(arg_0 -> LocalCurrencyUtil.lambda$getMulLocalCurrencyTable$1((Table)mulLocalCurrencyTable, arg_0));
            return Optional.of(mulLocalCurrencyTable);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Table<Long, Long, MulLocalCurrencyVO> getAllMulLocalCurrency() {
        LocalCacheKey cacheKey = LocalCurrencyUtil.buildCacheKey(ALL_MUL_LOCAL_CURRENCY_KEY);
        Table mulLocalCurrencyTable = (Table)LocalCacheHelper.get((LocalCacheKey)cacheKey, Table.class);
        if (!Objects.isNull(mulLocalCurrencyTable)) return mulLocalCurrencyTable;
        Class<LocalCurrencyUtil> clazz = LocalCurrencyUtil.class;
        synchronized (LocalCurrencyUtil.class) {
            mulLocalCurrencyTable = (Table)LocalCacheHelper.get((LocalCacheKey)cacheKey, Table.class);
            if (!Objects.isNull(mulLocalCurrencyTable)) return mulLocalCurrencyTable;
            mulLocalCurrencyTable = HashBasedTable.create();
            Map mulLocalCurrencyMap = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)String.join((CharSequence)DELIMITER, "org", "bookstype", "accountingsys", "basecurrency", EXCHANGE_RATE_TABLE, SECOND_LOCAL_CURRENCY, SECOND_EXRATE_TABLE, THIRD_LOCAL_CURRENCY, THIRD_EXRATE_TABLE), (QFilter[])new QFilter[]{new QFilter("accountingsys.enablegrplocalcur", "=", (Object)true).or(new QFilter("enablemullocalcur", "=", (Object)true))});
            Collection mulLocalCurrencys = mulLocalCurrencyMap.values();
            for (DynamicObject mulLocalCurrency : mulLocalCurrencys) {
                MulLocalCurrencyVO mulLocalCurrencyVO = LocalCurrencyUtil.buildMulLocalCurrencyVO(mulLocalCurrency);
                mulLocalCurrencyTable.put((Object)mulLocalCurrencyVO.getOrgId(), (Object)mulLocalCurrencyVO.getBookTypeId(), (Object)mulLocalCurrencyVO);
            }
            LocalCacheHelper.put((LocalCacheKey)cacheKey, (Object)mulLocalCurrencyTable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return mulLocalCurrencyTable;
        }
    }

    public static boolean canUseMulLocalCurrency(boolean enableMulLocalCurrency) {
        return !enableMulLocalCurrency || LocalCurrencyUtil.haveMulLocalCurrencyLicense();
    }

    public static boolean haveMulLocalCurrencyLicense() {
        return LicenseServiceHelper.checkPerformGroup((String)MUL_LOCAL_CURRENCY_GROUP).getHasLicense();
    }

    public static void removeMulLocalCurrencyCache() {
        LocalCacheHelper.remove((LocalCacheKey)LocalCurrencyUtil.buildCacheKey(ALL_MUL_LOCAL_CURRENCY_KEY));
        LocalCacheHelper.remove((LocalCacheKey)LocalCurrencyUtil.buildCacheKey(USE_GROUP_CURRENCY_KEY));
        LocalCacheHelper.remove((LocalCacheKey)LocalCurrencyUtil.buildCacheKey(USE_SECOND_CURRENCY_KEY));
        LocalCacheHelper.remove((LocalCacheKey)LocalCurrencyUtil.buildCacheKey(USE_THIRD_CURRENCY_KEY));
    }

    private static LocalCacheKey buildCacheKey(String key) {
        return LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.BASE_CURRENCY, (Object[])new Object[]{key});
    }

    private static MulLocalCurrencyVO buildMulLocalCurrencyVO(DynamicObject mulLocalCurrency) {
        long orgId = mulLocalCurrency.getLong("org_id");
        long bookTypeId = mulLocalCurrency.getLong(LocalCurrencyUtil.getIdName("bookstype"));
        long accountingSysId = mulLocalCurrency.getLong(LocalCurrencyUtil.getIdName("accountingsys"));
        long baseCurrencyId = mulLocalCurrency.getLong("basecurrency_id");
        long exchangeRateTableId = mulLocalCurrency.getLong(LocalCurrencyUtil.getIdName(EXCHANGE_RATE_TABLE));
        long groupLocalCurrencyId = mulLocalCurrency.getLong(LocalCurrencyUtil.getIdName("accountingsys.grplocalcur"));
        long groupExchangeRateTableId = mulLocalCurrency.getLong(LocalCurrencyUtil.getIdName("accountingsys.exratetable"));
        ConversionMethod conversionMethod = ConversionMethod.getConversionMethodByValue(mulLocalCurrency.getString("accountingsys.conversionmethod"));
        long secondLocalCurrencyId = mulLocalCurrency.getLong(SECOND_LOCAL_CURRENCY_ID);
        long secondExchangeRateTableId = mulLocalCurrency.getLong(SECOND_EXRATE_TABLE_ID);
        long thirdLocalCurrencyId = mulLocalCurrency.getLong(THIRD_LOCAL_CURRENCY_ID);
        long thirdExchangeRateTableId = mulLocalCurrency.getLong(THIRD_EXRATE_TABLE_ID);
        return new MulLocalCurrencyVO(orgId, bookTypeId, accountingSysId, baseCurrencyId, exchangeRateTableId, groupLocalCurrencyId, groupExchangeRateTableId, conversionMethod, secondLocalCurrencyId, secondExchangeRateTableId, thirdLocalCurrencyId, thirdExchangeRateTableId);
    }

    private static String getIdName(String fieldName) {
        return fieldName + "_id";
    }

    private static /* synthetic */ void lambda$getMulLocalCurrencyTable$1(Table mulLocalCurrencyTable, Table.Cell cellSet) {
        MulLocalCurrencyVO cfr_ignored_0 = (MulLocalCurrencyVO)mulLocalCurrencyTable.put(cellSet.getRowKey(), cellSet.getColumnKey(), cellSet.getValue());
    }
}

