/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;
import kd.fi.bd.vo.CashflowItemOrgVo;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class POIUtils {
    private static final Log log = LogFactory.getLog(POIUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDownloadUrl(SXSSFWorkbook wb, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            try {
                wb.close();
                wb.dispose();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
    }

    public static void writeHeadLine(SXSSFWorkbook wb, List<String> headerList) {
        SXSSFSheet sh = wb.createSheet("sheet1");
        Row row = sh.createRow(0);
        CellStyle headerCellStyle = wb.createCellStyle();
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        headerCellStyle.setFont(headerFont);
        int size = headerList.size();
        for (int i = 0; i < size; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headerList.get(i));
            cell.setCellStyle(headerCellStyle);
        }
    }

    public static String generateFileName(String fileNamePrefix) {
        String fileName = fileNamePrefix;
        fileName = fileName + RequestContext.get().getTraceId() + ".xlsx";
        return fileName;
    }

    public static SXSSFWorkbook fillAssistOperateResultWorkbook(List<TaskExecutionResult<AccountOrgPairVO>> dataList) {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        List<String> headerList = Arrays.asList(BDCommonResource.getOrgIdText(), BDCommonResource.getOrgNameText(), BDCommonResource.getAccountNumberText(), BDCommonResource.getResultText(), BDCommonResource.getDescriptionText(), BDCommonResource.getMessageCodeText(), BDCommonResource.getExecuteOrderText());
        POIUtils.writeHeadLine(wb, headerList);
        SXSSFSheet sh = wb.getSheet("sheet1");
        sh.setColumnHidden(0, true);
        sh.setColumnHidden(6, true);
        List sortedDataList = dataList.stream().sorted(Comparator.comparing(TaskExecutionResult::getScheduleSeq)).collect(Collectors.toList());
        int size = sortedDataList.size();
        for (int i = 0; i < size; ++i) {
            TaskExecutionResult resultVO = (TaskExecutionResult)sortedDataList.get(i);
            AccountOrgPairVO dataVO = (AccountOrgPairVO)resultVO.getData();
            Row row = sh.createRow(i + 1);
            Cell dcell0 = row.createCell(0);
            Cell dcell1 = row.createCell(1);
            Cell dcell2 = row.createCell(2);
            Cell dcell3 = row.createCell(3);
            Cell dcell4 = row.createCell(4);
            Cell dcell5 = row.createCell(5);
            Cell dcell6 = row.createCell(6);
            dcell0.setCellValue(dataVO.getOrgId() + "");
            dcell1.setCellValue(dataVO.getOrgName());
            dcell2.setCellValue(dataVO.getAccountNumber());
            dcell3.setCellValue(resultVO.getStatus().getValue());
            String failedMsg = resultVO.getFailedMsg();
            if (StringUtils.isNotEmpty((String)failedMsg) && failedMsg.length() > 255) {
                if (DebugTrace.enable()) {
                    log.info("failed_acc: {}, orgId: {}, failedMsg: {}", new Object[]{dataVO.getAccountNumber(), dataVO.getOrgId(), failedMsg});
                }
                failedMsg = failedMsg.substring(0, 255);
            }
            dcell4.setCellValue(failedMsg);
            dcell5.setCellValue(resultVO.getMsgCode());
            dcell6.setCellValue((double)resultVO.getScheduleSeq());
        }
        return wb;
    }

    public static SXSSFWorkbook fillCashflowItemResultWorkbook(List<TaskExecutionResult<CashflowItemOrgVo>> dataList) {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        List<String> headerList = Arrays.asList(BDCommonResource.getOrgIdText(), BDCommonResource.getOrgNameText(), BDCommonResource.getCfitemNumberText(), BDCommonResource.getResultText(), BDCommonResource.getDescriptionText(), BDCommonResource.getMessageCodeText(), BDCommonResource.getExecuteOrderText());
        POIUtils.writeHeadLine(wb, headerList);
        SXSSFSheet sh = wb.getSheet("sheet1");
        sh.setColumnHidden(0, true);
        sh.setColumnHidden(6, true);
        List sortedDataList = dataList.stream().sorted(Comparator.comparing(TaskExecutionResult::getScheduleSeq)).collect(Collectors.toList());
        int size = sortedDataList.size();
        for (int i = 0; i < size; ++i) {
            TaskExecutionResult resultVO = (TaskExecutionResult)sortedDataList.get(i);
            CashflowItemOrgVo dataVO = (CashflowItemOrgVo)resultVO.getData();
            Row row = sh.createRow(i + 1);
            Cell dcell0 = row.createCell(0);
            Cell dcell1 = row.createCell(1);
            Cell dcell2 = row.createCell(2);
            Cell dcell3 = row.createCell(3);
            Cell dcell4 = row.createCell(4);
            Cell dcell5 = row.createCell(5);
            Cell dcell6 = row.createCell(6);
            dcell0.setCellValue(dataVO.getOrgId() + "");
            dcell1.setCellValue(dataVO.getOrgName());
            dcell2.setCellValue(dataVO.getItemNumber());
            dcell3.setCellValue(resultVO.getStatus().getValue());
            dcell4.setCellValue(resultVO.getFailedMsg());
            dcell5.setCellValue(resultVO.getMsgCode());
            dcell6.setCellValue((double)resultVO.getScheduleSeq());
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write2LocalZipFile(SXSSFWorkbook wb, String fileName, ZipOutputStream zipOut, boolean zipOutClose) throws IOException {
        File tmpFile = new File(FilenameUtils.getName((String)fileName));
        try (FileOutputStream outStream = new FileOutputStream(tmpFile);
             FileInputStream fis = new FileInputStream(tmpFile);
             BufferedInputStream bis = new BufferedInputStream(fis, 1024);){
            int len;
            wb.write((OutputStream)outStream);
            zipOut.putNextEntry(new ZipEntry(fileName));
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf, 0, 1024)) != -1) {
                zipOut.write(buf, 0, len);
            }
            zipOut.flush();
            zipOut.closeEntry();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            wb.close();
            wb.dispose();
            if (tmpFile.exists() && tmpFile.delete()) {
                log.info(tmpFile.getName() + " deleted");
            }
            if (zipOutClose) {
                zipOut.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static String witeFile2AttachmentFileService(String fileName, String path) throws Exception {
        File tmpFile = new File(FilenameUtils.getName((String)fileName));
        try {
            try (FileInputStream inStream = new FileInputStream(tmpFile);){
                FileService service = FileServiceFactory.getAttachmentFileService();
                String downloadUrl = service.upload(new FileItem(fileName, path, (InputStream)inStream));
                String string = "attachment/download.do?path=" + downloadUrl;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tmpFile.exists() && tmpFile.delete()) {
                log.info(tmpFile.getName() + " deleted");
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String getAttachmentDownloadUrl(SXSSFWorkbook wb, String fileName, String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SXSSFWorkbook fillMulCurVerifyResultWorkbook(List<Map<String, String>> dataList) {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        List<String> headerList = Arrays.asList(BDCommonResource.getOrgText(), BDCommonResource.getBookTypeText(), BDCommonResource.getLocalCurText(), BDCommonResource.getSecLocalCurText(), BDCommonResource.getTrdLocalCurText(), BDCommonResource.getGrpLocalCurText());
        POIUtils.writeHeadLine(wb, headerList);
        SXSSFSheet sh = wb.getSheet("sheet1");
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, String> data = dataList.get(i);
            Row row = sh.createRow(i + 1);
            Cell dcell0 = row.createCell(0);
            Cell dcell1 = row.createCell(1);
            Cell dcell2 = row.createCell(2);
            Cell dcell3 = row.createCell(3);
            Cell dcell4 = row.createCell(4);
            Cell dcell5 = row.createCell(5);
            dcell0.setCellValue(data.get("org"));
            dcell1.setCellValue(data.get("booktype"));
            dcell2.setCellValue(data.get("LocalCurrency"));
            dcell3.setCellValue(data.get("SecLocalCurrency") == null ? "" : data.get("SecLocalCurrency"));
            dcell4.setCellValue(data.get("TrdLocalCurrency") == null ? "" : data.get("TrdLocalCurrency"));
            dcell5.setCellValue(data.get("GrpLocalCurrency") == null ? "" : data.get("GrpLocalCurrency"));
        }
        return wb;
    }
}

