/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.function.Supplier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PerformanceMonitor {
    private static final Log LOG = LogFactory.getLog(PerformanceMonitor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T watch(Supplier<T> func, int costMillSecThreshold, Object watchParam) {
        T t;
        long tick = System.currentTimeMillis();
        try {
            t = func.get();
        }
        catch (Throwable throwable) {
            long cost = System.currentTimeMillis() - tick;
            if (cost > (long)costMillSecThreshold) {
                LOG.info("performance_warning: source: {}, cost:{}[{}] ms with {}", new Object[]{PerformanceMonitor.parseCallSource(new Throwable()), cost, costMillSecThreshold, null == watchParam ? "null" : watchParam.toString()});
            }
            throw throwable;
        }
        long cost = System.currentTimeMillis() - tick;
        if (cost > (long)costMillSecThreshold) {
            LOG.info("performance_warning: source: {}, cost:{}[{}] ms with {}", new Object[]{PerformanceMonitor.parseCallSource(new Throwable()), cost, costMillSecThreshold, null == watchParam ? "null" : watchParam.toString()});
        }
        return t;
    }

    public static <T> T watchAny(Supplier<T> func, Object watchParam) {
        return PerformanceMonitor.watch(func, 0, watchParam);
    }

    private static String parseCallSource(Throwable e) {
        StackTraceElement[] stack = e.getStackTrace();
        if (stack.length > 0) {
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement ste = stack[i];
                if (PerformanceMonitor.class.getName().equals(ste.getClassName())) continue;
                return String.format("Class: %s.%s, Line: %s", ste.getClassName(), ste.getMethodName(), ste.getLineNumber());
            }
        }
        return "";
    }

    public static String parseFullCallSource(Throwable e) {
        StackTraceElement[] stack = e.getStackTrace();
        if (stack.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement ste = stack[i];
                if (!ste.getClassName().startsWith("kd.fi.")) continue;
                sb.append(String.format("Class: %s.%s, Line: %s|", ste.getClassName(), ste.getMethodName(), ste.getLineNumber()));
            }
            return sb.toString();
        }
        return "";
    }
}

