/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;

public class PerformanceWatch {
    private static final String EMPTY_STR = "";
    private final String id;
    private Log logger;
    private boolean keepTaskList = true;
    private final List<TaskInfo> taskList = new ArrayList<TaskInfo>(1);
    private long startTimeNanos;
    private String currentTaskName;
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeNanos;
    private boolean enable;

    public PerformanceWatch(Class<?> clazz, String key, boolean isJustDebug) {
        this.id = StringUtils.isNotEmpty((String)key) ? key : clazz.getSimpleName();
        this.enable = false;
        if (!isJustDebug || DebugTrace.enable()) {
            this.enable = true;
        }
        this.logger = LogFactory.getLog(clazz);
    }

    public PerformanceWatch(Log logger, String key, boolean isJustDebug) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)key));
        this.id = key;
        this.enable = false;
        if (!isJustDebug || DebugTrace.enable()) {
            this.enable = true;
        }
        this.logger = logger;
    }

    public String getId() {
        return this.id;
    }

    public void setKeepTaskList(boolean keepTaskList) {
        this.keepTaskList = keepTaskList;
    }

    public void start() throws IllegalStateException {
        this.start(EMPTY_STR);
    }

    public void start(String taskName) throws IllegalStateException {
        if (!this.enable) {
            return;
        }
        if (this.currentTaskName != null) {
            throw new IllegalStateException("Can't start PerformanceWatch: it's already running");
        }
        this.currentTaskName = taskName;
        this.startTimeNanos = System.nanoTime();
    }

    public void stop() throws IllegalStateException {
        if (!this.enable) {
            return;
        }
        if (this.currentTaskName == null) {
            throw new IllegalStateException("Can't stop PerformanceWatch: it's not running");
        }
        long lastTime = System.nanoTime() - this.startTimeNanos;
        this.totalTimeNanos += lastTime;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, lastTime);
        if (this.keepTaskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.currentTaskName = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.buildLogMsg(true));
        } else {
            this.logger.warn(this.buildLogMsg(true));
        }
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    public String currentTaskName() {
        return this.currentTaskName;
    }

    public long getLastTaskTimeNanos() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeNanos();
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public String getLastTaskName() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task name");
        }
        return this.lastTaskInfo.getTaskName();
    }

    public TaskInfo getLastTaskInfo() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task info");
        }
        return this.lastTaskInfo;
    }

    public long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public long getTotalTimeMillis() {
        return PerformanceWatch.nanosToMillis(this.totalTimeNanos);
    }

    public double getTotalTimeSeconds() {
        return PerformanceWatch.nanosToSeconds(this.totalTimeNanos);
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[0]);
    }

    public String show(boolean isReset) {
        String result = this.show();
        if (isReset) {
            this.reset();
        }
        return result;
    }

    public String show() {
        if (!this.enable) {
            return EMPTY_STR;
        }
        return this.prettyPrint();
    }

    public void reset() {
        this.currentTaskName = null;
        this.taskCount = 0;
        this.startTimeNanos = 0L;
        this.totalTimeNanos = 0L;
        this.taskList.clear();
    }

    private String shortSummary() {
        return " PerformanceWatch '" + this.getId() + "': running time = " + this.getTotalTimeMillis() + " ms";
    }

    private String prettyPrint() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        if (!this.keepTaskList) {
            sb.append("No task info kept");
        } else {
            sb.append("---------------------------------------------\n");
            sb.append("ms         %     Task name\n");
            sb.append("---------------------------------------------\n");
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(9);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(3);
            pf.setGroupingUsed(false);
            for (TaskInfo task : this.getTaskInfo()) {
                sb.append(nf.format(task.getTimeMillis())).append("  ");
                sb.append(pf.format((double)task.getTimeMillis() / (double)this.getTotalTimeMillis())).append("  ");
                sb.append(task.getTaskName()).append('\n');
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        if (this.keepTaskList) {
            for (TaskInfo task : this.getTaskInfo()) {
                sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getTimeNanos()).append(" ns");
                long percent = Math.round(100.0 * (double)task.getTimeNanos() / (double)this.getTotalTimeNanos());
                sb.append(" = ").append(percent).append('%');
            }
        } else {
            sb.append("; no task info kept");
        }
        return sb.toString();
    }

    private String buildLogMsg(boolean isEnd) {
        StackTraceElement[] lvStacks = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder(100);
        if (lvStacks[4].getClassName().contains(".fi.")) {
            String superClassName = this.getSuperClassName(lvStacks[4]);
            sb.append(superClassName).append('.').append(lvStacks[4].getMethodName()).append('[').append(lvStacks[4].getLineNumber() - 1).append(']');
        }
        sb.append('.').append(lvStacks[3].getMethodName()).append("()[").append(lvStacks[3].getLineNumber() - 1).append(']').append("--FI-- [");
        if (!isEnd) {
            sb.append(this.currentTaskName).append("]").append(" begin ---");
        } else {
            sb.append(this.getLastTaskName()).append("]").append(" end, cost:").append(this.getLastTaskTimeMillis()).append(" ms ---");
        }
        return sb.toString();
    }

    private String getSuperClassName(StackTraceElement s) {
        String[] packs = s.getClassName().split("\\.");
        return packs[packs.length - 1];
    }

    private static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    private static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long timeNanos;

        TaskInfo(String taskName, long timeNanos) {
            this.taskName = taskName;
            this.timeNanos = timeNanos;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeNanos() {
            return this.timeNanos;
        }

        public long getTimeMillis() {
            return PerformanceWatch.nanosToMillis(this.timeNanos);
        }

        public double getTimeSeconds() {
            return PerformanceWatch.nanosToSeconds(this.timeNanos);
        }
    }
}

