/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.logging.LogFactory;

public class SafeStreamCloseHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<?> handleClosable(Closeable closeable, Function<Closeable, ?> streamHandler) {
        if (closeable == null) {
            return Optional.empty();
        }
        try {
            Optional<?> optional = Optional.ofNullable(streamHandler.apply(closeable));
            return optional;
        }
        finally {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LogFactory.getLog(SafeStreamCloseHelper.class).error("io exception caught with the closeable: " + closeable.toString(), (Throwable)e);
            }
        }
    }
}

