/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.Optional;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enhance.treetask.ITaskResult;

public class TaskExecutionResult<T>
implements ITaskResult {
    private static final long serialVersionUID = 1L;
    protected Status status = Status.success;
    protected String msgCode = "T001";
    protected int scheduleSeq;
    protected String failedMsg;
    protected Optional<T> data;

    public TaskExecutionResult() {
    }

    public TaskExecutionResult(T data) {
        this.data = Optional.ofNullable(data);
    }

    public static <T> TaskExecutionResult skipped(T data, String msg) {
        return TaskExecutionResult.skipped(data, msg, "S000");
    }

    public static <T> TaskExecutionResult skipped(T data, String msg, String code) {
        TaskExecutionResult<T> result = new TaskExecutionResult<T>(data);
        result.status = Status.skip;
        result.failedMsg = msg;
        result.msgCode = code;
        return result;
    }

    public static <T> TaskExecutionResult failed(T data, String msg) {
        return TaskExecutionResult.failed(data, msg, "E000");
    }

    public static <T> TaskExecutionResult failed(T data, String msg, String code) {
        TaskExecutionResult<T> result = new TaskExecutionResult<T>(data);
        result.status = Status.failed;
        result.failedMsg = msg;
        result.msgCode = code;
        return result;
    }

    public static <T> TaskExecutionResult fastFail(T data, String msg, String code) {
        TaskExecutionResult<T> result = new TaskExecutionResult<T>(data);
        result.status = Status.fast_failed;
        result.failedMsg = msg;
        result.msgCode = code;
        return result;
    }

    public static <T> TaskExecutionResult delay(T data, String msg, String code) {
        TaskExecutionResult<T> result = new TaskExecutionResult<T>(data);
        result.status = Status.delay;
        result.failedMsg = msg;
        result.msgCode = code;
        return result;
    }

    public static <T> TaskExecutionResult succeed(T data, String msg) {
        TaskExecutionResult<T> result = new TaskExecutionResult<T>(data);
        result.status = Status.success;
        result.failedMsg = msg;
        return result;
    }

    public TaskExecutionResult cloneStatus(T newData, String msgCode, String msg) {
        TaskExecutionResult<T> result = new TaskExecutionResult<T>(newData);
        result.status = this.status;
        result.failedMsg = msg;
        result.msgCode = msgCode;
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this.status != Status.failed && this.status != Status.fast_failed;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getFailedMsg() {
        return this.failedMsg;
    }

    public void setFailedMsg(String failedMsg) {
        this.failedMsg = failedMsg;
    }

    public T getData() {
        return this.data.isPresent() ? (T)this.data.get() : null;
    }

    public void setData(T data) {
        this.data = Optional.ofNullable(data);
    }

    public String getMsgCode() {
        return this.msgCode;
    }

    public void setMsgCode(String msgCode) {
        this.msgCode = msgCode;
    }

    public int getScheduleSeq() {
        return this.scheduleSeq;
    }

    public void setScheduleSeq(int scheduleSeq) {
        this.scheduleSeq = scheduleSeq;
    }

    public String toString() {
        return "TaskExecutionResult{status=" + (Object)((Object)this.status) + ", msgCode='" + this.msgCode + '\'' + ", scheduleSeq=" + this.scheduleSeq + ", failedMsg='" + this.failedMsg + '\'' + ", data=" + this.data + '}';
    }

    public static enum Status {
        success(BDCommonResource.getSuccessText()),
        failed(BDCommonResource.getFailedText()),
        fast_failed(BDCommonResource.getFailedText()),
        skip(BDCommonResource.getSkipText()),
        delay(BDCommonResource.getDelayText());

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

