/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.collections.queue;

import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public abstract class AbstractConcurrentSet<E> {
    final int capacity;
    final AtomicInteger count = new AtomicInteger(0);
    final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
    final Object notEmptyFlag = new Object();
    final Object notFullFlag = new Object();
    final LinkedHashSet<E> set;

    protected AbstractConcurrentSet(int capacity) {
        this.capacity = capacity;
        this.set = new LinkedHashSet(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalNotEmpty() {
        Object object = this.notEmptyFlag;
        synchronized (object) {
            this.notEmptyFlag.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalNotFull() {
        Object object = this.notFullFlag;
        synchronized (object) {
            this.notFullFlag.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doWriteLockOperation(boolean interruptibly, Supplier<T> operation) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock;
        try {
            if (interruptibly) {
                writeLock.lockInterruptibly();
            } else {
                writeLock.lock();
            }
            try {
                T t = operation.get();
                return t;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                writeLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    protected <T> T doWriteLockOperation(Supplier<T> operation) {
        return this.doWriteLockOperation(true, operation);
    }
}

