/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.collections.queue;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.fi.bd.util.collections.queue.ConcurrentSetQueue;

public class ConcurrentSetBlockingQueue<E>
extends ConcurrentSetQueue<E>
implements BlockingQueue<E> {
    public ConcurrentSetBlockingQueue(int capacity) {
        super(capacity);
    }

    public ConcurrentSetBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E result = null;
        int prevCnt = -1;
        AtomicInteger count = this.count;
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock;
        boolean infiniteWait = timeout < 0L;
        long waitTime = timeout < 0L ? -1L : unit.toMillis(timeout);
        long lastStartTime = System.currentTimeMillis();
        while (true) {
            long newStartTime;
            if (count.get() <= 0) {
                Object object = this.notEmptyFlag;
                synchronized (object) {
                    if (infiniteWait) {
                        this.notEmptyFlag.wait(500L);
                    } else {
                        if (waitTime <= 0L) {
                            return null;
                        }
                        this.notEmptyFlag.wait(waitTime);
                        newStartTime = System.currentTimeMillis();
                        waitTime -= newStartTime - lastStartTime;
                        lastStartTime = newStartTime;
                    }
                }
            }
            writeLock.lockInterruptibly();
            try {
                if (count.get() > 0) {
                    Object e = this.set.iterator().next();
                    result = e;
                    if (this.set.remove(e)) {
                        prevCnt = count.getAndDecrement();
                    }
                }
            }
            finally {
                writeLock.unlock();
            }
            if (result != null) {
                if (prevCnt >= 0) {
                    if (prevCnt > 1) {
                        this.signalNotEmpty();
                    }
                    if (prevCnt == this.capacity) {
                        this.signalNotFull();
                    }
                }
                return result;
            }
            if (!infiniteWait && (waitTime -= (newStartTime = System.currentTimeMillis()) - (lastStartTime = newStartTime)) <= 0L) break;
        }
        return null;
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void put(E newElement) throws InterruptedException {
        while (!this.offer(newElement, -1L, TimeUnit.MILLISECONDS)) {
            LockSupport.parkNanos(1000000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E newElement, long timeout, TimeUnit unit) throws InterruptedException {
        if (newElement == null) {
            return false;
        }
        int prevCnt = -1;
        AtomicInteger count = this.count;
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock;
        boolean infiniteWait = timeout < 0L;
        long waitTime = timeout < 0L ? -1L : unit.toMillis(timeout);
        long lastStartTime = System.currentTimeMillis();
        while (true) {
            long newStartTime;
            if (count.get() >= this.capacity) {
                Object object = this.notFullFlag;
                synchronized (object) {
                    if (infiniteWait) {
                        this.notFullFlag.wait(500L);
                    } else {
                        if (waitTime <= 0L) {
                            return false;
                        }
                        this.notFullFlag.wait(waitTime);
                        newStartTime = System.currentTimeMillis();
                        waitTime -= newStartTime - lastStartTime;
                        lastStartTime = newStartTime;
                    }
                }
            }
            writeLock.lockInterruptibly();
            try {
                if (!this.set.contains(newElement) && count.get() < this.capacity && this.set.add(newElement)) {
                    prevCnt = count.getAndIncrement();
                }
            }
            finally {
                writeLock.unlock();
            }
            if (prevCnt >= 0) {
                if (prevCnt > 0 && prevCnt + 1 < this.capacity) {
                    this.signalNotFull();
                }
                if (prevCnt == 0) {
                    this.signalNotEmpty();
                }
                return true;
            }
            if (!infiniteWait && (waitTime -= (newStartTime = System.currentTimeMillis()) - (lastStartTime = newStartTime)) <= 0L) break;
        }
        return false;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Object buf;
        int cnt;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        for (cnt = 0; cnt < maxElements && (buf = this.poll()) != null; ++cnt) {
            c.add(buf);
        }
        return cnt;
    }
}

