/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.collector;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ExtCollectors {
    public static <T, K, U> Collector<T, ?, Multimap<K, U>> toMultiap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return ExtCollectors.toMultiap(keyMapper, valueMapper, HashMultimap::create);
    }

    public static <T, K, U, M extends Multimap<K, U>> Collector<T, ?, M> toMultiap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        BiConsumer<Multimap, Object> accumulator = (map, element) -> map.put(keyMapper.apply(element), valueMapper.apply(element));
        BinaryOperator combiner = (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        };
        return Collector.of(mapSupplier, accumulator, combiner, new Collector.Characteristics[0]);
    }
}

