/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.filter;

import kd.fi.bd.util.filter.ILookupKeyInfo;
import kd.fi.bd.util.filter.IStoredWildcardKey;
import kd.fi.bd.util.filter.WildcardMatcher;
import kd.fi.bd.util.filter.WildcardPositionEnum;

public class BaseLookupWildcardKey<T>
implements IStoredWildcardKey,
ILookupKeyInfo {
    WildcardPositionEnum wildcardPosition;
    final char[] compareKey;
    int keyLength;
    int hash;

    public BaseLookupWildcardKey(String srcKey) {
        this(srcKey, WildcardPositionEnum.None);
    }

    public BaseLookupWildcardKey(String srcKey, WildcardPositionEnum wildcardPosition) {
        this.compareKey = srcKey.toCharArray();
        this.rebuildHashCode(wildcardPosition, this.compareKey.length);
        this.wildcardPosition = wildcardPosition;
    }

    public String toString() {
        return "BaseLookupWildcardKey{hash=" + this.hash + ", wildcardPosition=" + (Object)((Object)this.wildcardPosition) + ", compareKey=" + String.valueOf(this.compareKey) + ", keyLength=" + this.keyLength + '}';
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean rebuildHashCode(BaseLookupWildcardKey targetTemplate) {
        return this.rebuildHashCode(targetTemplate.wildcardPosition, targetTemplate.keyLength);
    }

    @Override
    public boolean rebuildHashCode(WildcardPositionEnum wildcardPosition, int keyLength) {
        if (keyLength <= 0 || keyLength > this.compareKey.length) {
            return false;
        }
        int incrementCnt = -1;
        if (wildcardPosition == this.wildcardPosition) {
            incrementCnt = keyLength - this.keyLength;
        } else {
            this.wildcardPosition = wildcardPosition;
        }
        boolean calDirection = true;
        int startPos = 0;
        int endPos = keyLength;
        switch (wildcardPosition) {
            case Suffix: {
                if (incrementCnt > 0) {
                    startPos = this.keyLength;
                    break;
                }
                this.hash = 0;
                break;
            }
            case Prefix: {
                calDirection = false;
                if (incrementCnt > 0) {
                    startPos = this.compareKey.length - 1 - this.keyLength;
                } else {
                    this.hash = -31;
                    startPos = this.compareKey.length - 1;
                }
                endPos = this.compareKey.length - keyLength;
                break;
            }
            default: {
                this.hash = 47;
            }
        }
        this.keyLength = keyLength;
        if (calDirection) {
            for (int i = startPos; i < endPos; ++i) {
                this.hash = 31 * this.hash + this.compareKey[i];
            }
        } else {
            for (int i = startPos; i >= endPos; --i) {
                this.hash = 31 * this.hash + this.compareKey[i];
            }
        }
        return true;
    }

    public boolean equals(Object targetObject) {
        if (this == targetObject) {
            return true;
        }
        if (targetObject instanceof BaseLookupWildcardKey) {
            BaseLookupWildcardKey anotherKey = (BaseLookupWildcardKey)targetObject;
            if (this.wildcardPosition == anotherKey.wildcardPosition && this.keyLength == anotherKey.keyLength) {
                char[] v2 = anotherKey.compareKey;
                int startPos = this.wildcardPosition == WildcardPositionEnum.Prefix ? this.compareKey.length - this.keyLength : 0;
                for (int i = 0; i < this.keyLength; ++i) {
                    if (this.compareKey[startPos + i] == v2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMatch(String targetValue) {
        int endPos;
        if (targetValue == null || this.keyLength > targetValue.length()) {
            return false;
        }
        switch (this.wildcardPosition) {
            case Prefix: {
                int startPos = this.compareKey.length - this.keyLength;
                endPos = targetValue.length();
                break;
            }
            default: {
                int startPos = 0;
                endPos = this.keyLength;
            }
        }
        for (int i = startPos; i < endPos; ++i) {
            if (targetValue.charAt(i) == this.compareKey[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public WildcardPositionEnum getWildcardPosition() {
        return this.wildcardPosition;
    }

    @Override
    public String getCompareKey() {
        return new String(this.compareKey);
    }

    @Override
    public String getCompareKey(boolean withWildcardKey) {
        return WildcardMatcher.addOrRemoveWildcard(this.wildcardPosition, withWildcardKey, new String(this.compareKey));
    }

    @Override
    public int getKeyLength() {
        return this.keyLength;
    }
}

