/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.filter;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.util.DateUtil;

public class FIQFilterUtil {
    private static final ThreadLocal<SimpleDateFormat> thSDF = ThreadLocals.create(() -> DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss"));
    private static final Set<Class<?>> numberClsSet = new HashSet();

    public static boolean isNumber(Class<?> cls) {
        return numberClsSet.contains(cls);
    }

    private static String toSqlValueString(Object value) {
        String v = String.valueOf(value);
        return v.replaceAll("'", "''");
    }

    static String parametertoString(Object value) {
        QParameter p = FIQFilterUtil.getInQParameter(value);
        if (p == null) {
            return "";
        }
        Object[] params = p.getParameters();
        StringBuilder s = new StringBuilder(params.length * 10);
        Object[] var4 = params;
        int var5 = params.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Object param = var4[var6];
            if (s.length() > 0) {
                s.append(',');
            }
            if (param == null) {
                s.append("''");
                continue;
            }
            Class<?> cls = param.getClass();
            if (!FIQFilterUtil.isNumber(cls) && cls != Boolean.class) {
                if (Date.class.isAssignableFrom(cls)) {
                    s.append('\'').append(thSDF.get().format((Date)param)).append('\'');
                    continue;
                }
                if (cls.isArray()) {
                    int n = Array.getLength(param);
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            s.append(',');
                        }
                        s.append(FIQFilterUtil.parametertoString(Array.get(param, i)));
                    }
                    continue;
                }
                if (value instanceof MultiBaseDataFilterValue) {
                    MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
                    s.append("{\"baseDataName\":\"").append(multi.getBaseDataName()).append("\",\"joinProperty\":\"").append(multi.getJoinProperty()).append("\",\"value\":\"").append(multi.getValue()).append("\"}");
                    continue;
                }
                s.append('\'').append(FIQFilterUtil.toSqlValueString(param)).append('\'');
                continue;
            }
            s.append(param);
        }
        return s.toString();
    }

    static QParameter getInQParameter(Object value) {
        if (value == null) {
            return null;
        }
        Object[] params = FIQFilterUtil.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            String sql = FIQFilterUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    public static QParameter getInQParameter(Object value, boolean sqlWithParam) {
        if (value == null) {
            return null;
        }
        Object[] params = FIQFilterUtil.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            if (sqlWithParam) {
                String sql = FIQFilterUtil.multiParamsSQL(params);
                return new QParameter(sql, new Object[0]);
            }
            String sql = FIQFilterUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    public static QParameter getInQParameter(Object[] params, boolean sqlWithParam) {
        int c = params.length;
        if (c > 0) {
            if (sqlWithParam) {
                String sql = FIQFilterUtil.multiParamsSQL(params);
                return new QParameter(sql, new Object[0]);
            }
            String sql = FIQFilterUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    static String multiParamsSQL(int c) {
        StringBuilder s = new StringBuilder(c * 2);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append('?');
        }
        return s.toString();
    }

    static String multiParamsSQL(Object[] params) {
        Object param0 = params[0];
        if (!(param0 instanceof Number)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"Unsupported data type:" + param0.getClass()});
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(params[i]);
        }
        return s.toString();
    }

    public static Object[] getWithoutDuplicateInValues(Object values) {
        if (values == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        Object[] params = null;
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                set.add(Array.get(values, i));
            }
            c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Set) {
            params = ((Set)values).toArray(new Object[((Set)values).size()]);
        } else if (values instanceof Collection) {
            HashSet set = new HashSet((Collection)values);
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Iterable) {
            HashSet set = new HashSet(16);
            for (Object item : (Iterable)values) {
                set.add(item);
            }
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else {
            Object originValue;
            params = values instanceof MultiBaseDataFilterValue ? ((originValue = ((MultiBaseDataFilterValue)values).getValue()) instanceof Collection ? ((Collection)originValue).toArray() : new Object[]{originValue}) : new Object[]{values};
        }
        return params;
    }

    public static int getValueSize(Object values) {
        if (values == null) {
            return 0;
        }
        if (values.getClass().isArray()) {
            return Array.getLength(values);
        }
        if (values instanceof Collection) {
            return ((Collection)values).size();
        }
        if (!(values instanceof Iterable)) {
            if (values instanceof MultiBaseDataFilterValue) {
                Object originValue = ((MultiBaseDataFilterValue)values).getValue();
                if (originValue == null) {
                    return 0;
                }
                if (originValue instanceof Collection) {
                    return ((Collection)originValue).size();
                }
            }
            return 1;
        }
        int count = 0;
        for (Object t : (Iterable)values) {
            ++count;
        }
        return count;
    }

    static {
        numberClsSet.add(Integer.TYPE);
        numberClsSet.add(Long.TYPE);
        numberClsSet.add(Short.TYPE);
        numberClsSet.add(Float.TYPE);
        numberClsSet.add(Double.TYPE);
        numberClsSet.add(Integer.class);
        numberClsSet.add(Long.class);
        numberClsSet.add(Short.class);
        numberClsSet.add(Float.class);
        numberClsSet.add(Double.class);
        numberClsSet.add(BigDecimal.class);
    }
}

