/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.filter.FilterMergedStatusCode;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.filter.WildcardMatcher;
import kd.fi.bd.util.filter.WildcardPositionEnum;

public class FilterValueMergeContainer {
    private Map<String, Map<String, Set<Object>>> mergeFilters;
    private boolean isValidFilterGroup;
    static final String[] CheckSingleWildCardKeyQcp = new String[]{"like", "not like"};
    private static final String[] Range_QCPs = new String[]{">", ">=", "<", "<="};
    private static final String[] In_Group_QCPs = new String[]{"in", "not in"};
    private static final String[][] SingleInToEqual_Check_QCPS = new String[][]{{"in", "="}, {"not in", "!="}};

    public FilterValueMergeContainer(int initialSize) {
        this.mergeFilters = new LinkedHashMap<String, Map<String, Set<Object>>>(initialSize);
    }

    public String toString() {
        return "FilterValueMergeContainer{mergeFilters=" + this.mergeFilters + ", isValidFilterGroup=" + this.isValidFilterGroup + '}';
    }

    public static String getMaxIntersectValue(char[][] srcStrArray, boolean forwardDirection, boolean mustMatchMaxString) {
        if (srcStrArray == null || srcStrArray.length <= 0) {
            return null;
        }
        int maxLength = -1;
        for (char[] s : srcStrArray) {
            if (s == null || s.length <= maxLength) continue;
            maxLength = s.length;
        }
        if (maxLength <= 0) {
            return null;
        }
        char[] resultVal = new char[maxLength];
        int itemCnt = srcStrArray.length;
        String resultString = null;
        for (int checkPos = 0; checkPos < maxLength; ++checkPos) {
            Character currentPosValue = FilterValueMergeContainer.getIntersectValue(srcStrArray, itemCnt, checkPos, forwardDirection);
            if (currentPosValue == null) {
                if (mustMatchMaxString) {
                    return null;
                }
                resultString = new String(resultVal, 0, checkPos);
                break;
            }
            resultVal[checkPos] = currentPosValue.charValue();
        }
        if (resultString == null) {
            resultString = new String(resultVal);
        }
        if (!forwardDirection) {
            resultString = new StringBuilder(resultString).reverse().toString();
        }
        return resultString;
    }

    private static Character getIntersectValue(char[][] srcStrArray, int checkItemCnt, int checkPos, boolean forwardDirection) {
        Character currentPosValue = null;
        int checkIndex = checkPos;
        for (int item_index = 0; item_index < checkItemCnt; ++item_index) {
            char[] checkItemBuf = srcStrArray[item_index];
            if (checkItemBuf == null || checkItemBuf.length <= checkPos) continue;
            if (!forwardDirection) {
                checkIndex = checkItemBuf.length - 1 - checkPos;
            }
            if (currentPosValue == null) {
                currentPosValue = Character.valueOf(checkItemBuf[checkIndex]);
                continue;
            }
            if (currentPosValue.charValue() == checkItemBuf[checkIndex]) continue;
            return null;
        }
        return currentPosValue;
    }

    public static String getMaxIntersectValue(Collection<String> srcStrArray, boolean forwardDirection, boolean mustMatchMaxString) {
        if (srcStrArray == null || srcStrArray.isEmpty()) {
            return null;
        }
        LinkedList<char[]> buf = new LinkedList<char[]>();
        for (String k : srcStrArray) {
            if (k == null || "".equals(k.trim())) continue;
            buf.add(k.toCharArray());
        }
        if (buf.isEmpty()) {
            return null;
        }
        return FilterValueMergeContainer.getMaxIntersectValue((char[][])buf.toArray((T[])new char[buf.size()][0]), forwardDirection, mustMatchMaxString);
    }

    public QFilterBuilder getFilterBuilder() {
        QFilterBuilder filterBuilder = new QFilterBuilder();
        for (Map.Entry<String, Map<String, Set<Object>>> en : this.mergeFilters.entrySet()) {
            block9: for (Map.Entry<String, Set<Object>> subEn : en.getValue().entrySet()) {
                switch (subEn.getKey()) {
                    case "is null": {
                        filterBuilder.add(QFilter.isNull((String)en.getKey()));
                        continue block9;
                    }
                    case "is not null": {
                        filterBuilder.add(QFilter.isNotNull((String)en.getKey()));
                        continue block9;
                    }
                }
                LinkedHashSet valueBufList = new LinkedHashSet(4);
                QFilterBuilder.parseContainerValues(subEn.getValue(), t -> valueBufList.add(t));
                if ("in".equals(subEn.getKey()) || "not in".equals(subEn.getKey())) {
                    filterBuilder.add(new QFilter(en.getKey(), subEn.getKey(), valueBufList));
                    continue;
                }
                for (Object v : valueBufList) {
                    filterBuilder.add(new QFilter(en.getKey(), subEn.getKey(), v));
                }
            }
        }
        return filterBuilder;
    }

    public FilterMergedStatusCode addFilter(QFilter.QFilterNest srcNestFilter) {
        if (srcNestFilter == null) {
            return FilterMergedStatusCode.Failed;
        }
        if ("or".equalsIgnoreCase(srcNestFilter.getOp())) {
            throw new IllegalArgumentException("Not Support Or NestFilter: " + srcNestFilter);
        }
        return this.addFilter(srcNestFilter.getFilter());
    }

    public static FilterMergedStatusCode addFilter(QFilter srcFilter, Map<String, Map<String, Set<Object>>> mergeFilters) {
        String filterQcp;
        if (srcFilter == null) {
            return FilterMergedStatusCode.Failed;
        }
        FilterMergedStatusCode resultCode = FilterMergedStatusCode.Success;
        Map qcpMap = mergeFilters.computeIfAbsent(srcFilter.getProperty(), t -> new HashMap(4));
        switch (filterQcp = srcFilter.getCP().toLowerCase(Locale.ENGLISH)) {
            case "=": 
            case "in": {
                return FilterValueMergeContainer.addEqualAndInValue("in", qcpMap, srcFilter);
            }
            case "!=": 
            case "<>": 
            case "not in": {
                return FilterValueMergeContainer.addEqualAndInValue("not in", qcpMap, srcFilter);
            }
            case "is null": {
                if (qcpMap.containsKey("is not null")) {
                    return FilterMergedStatusCode.Terminated;
                }
                qcpMap.put(filterQcp, null);
                return FilterMergedStatusCode.Success;
            }
            case "is not null": {
                if (qcpMap.containsKey("is null")) {
                    return FilterMergedStatusCode.Terminated;
                }
                qcpMap.put(filterQcp, null);
                return FilterMergedStatusCode.Success;
            }
            case ">": 
            case "<": 
            case ">=": 
            case "<=": {
                return FilterValueMergeContainer.addSingleRangeValue(qcpMap, srcFilter);
            }
            case "like": 
            case "match": 
            case "ilike": {
                return FilterValueMergeContainer.addLikeAndMatchValue(true, qcpMap, srcFilter);
            }
            case "not like": {
                return FilterValueMergeContainer.addLikeAndMatchValue(false, qcpMap, srcFilter);
            }
            case "not exists": 
            case "exists": 
            case "ftlike": {
                if (WildcardPositionEnum.Pre_Suffix != WildcardMatcher.getWildcardPos(String.valueOf(srcFilter.getValue()), '%')) break;
                return FilterValueMergeContainer.addLikeAndMatchValue(true, qcpMap, srcFilter);
            }
        }
        qcpMap.computeIfAbsent(filterQcp, t -> new LinkedHashSet()).add(srcFilter.getValue());
        return resultCode;
    }

    public FilterMergedStatusCode addFilter(QFilter srcFilter) {
        return FilterValueMergeContainer.addFilter(srcFilter, this.mergeFilters);
    }

    protected static FilterMergedStatusCode addEqualAndInValue(String qcp, Map<String, Set<Object>> qcpMap, QFilter srcFilter) {
        qcp = qcp.toLowerCase(Locale.ENGLISH);
        Set mergeFilterValues = qcpMap.computeIfAbsent(qcp, t -> new LinkedHashSet(4));
        Object filterValueBuf = srcFilter.getValue();
        List<Object> newFilterValues = QFilterBuilder.getContainerValues(filterValueBuf);
        if (newFilterValues.isEmpty()) {
            return FilterValueMergeContainer.addNullAndNotNullValue(true, qcpMap);
        }
        if (mergeFilterValues.isEmpty()) {
            mergeFilterValues.addAll(newFilterValues);
        } else {
            switch (qcp) {
                case "in": {
                    mergeFilterValues.retainAll(newFilterValues);
                    break;
                }
                case "not in": {
                    mergeFilterValues.addAll(newFilterValues);
                }
            }
            if (mergeFilterValues.isEmpty()) {
                return FilterMergedStatusCode.Terminated;
            }
        }
        return FilterMergedStatusCode.Success;
    }

    protected static FilterMergedStatusCode addSingleRangeValue(Map<String, Set<Object>> qcpMap, QFilter srcFilter) {
        String filterQcp = srcFilter.getCP().toLowerCase(Locale.ENGLISH);
        Set mergeFilterValues = qcpMap.computeIfAbsent(filterQcp, t -> new LinkedHashSet(4));
        Object newFilterValue = srcFilter.getValue();
        if (!(newFilterValue instanceof Number) && !(newFilterValue instanceof Date)) {
            throw new IllegalArgumentException(String.format("Invalid Range Value: %s on Filter=%s", newFilterValue, srcFilter));
        }
        if (mergeFilterValues.isEmpty()) {
            mergeFilterValues.add(newFilterValue);
        } else {
            Comparable oldValue = (Comparable)mergeFilterValues.iterator().next();
            switch (srcFilter.getCP()) {
                case ">": 
                case ">=": {
                    if (oldValue.compareTo(newFilterValue) < 0) break;
                    newFilterValue = null;
                    break;
                }
                case "<": 
                case "<=": {
                    if (oldValue.compareTo(newFilterValue) > 0) break;
                    newFilterValue = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid Range Filter=%s", srcFilter));
                }
            }
            if (newFilterValue != null) {
                mergeFilterValues.clear();
                mergeFilterValues.add(newFilterValue);
            }
        }
        return FilterMergedStatusCode.Success;
    }

    protected static FilterMergedStatusCode addNullAndNotNullValue(boolean isNull, Map<String, Set<Object>> qcpMap) {
        if (qcpMap.containsKey(isNull ? "is not null" : "is null")) {
            return FilterMergedStatusCode.Terminated;
        }
        qcpMap.put(isNull ? "is null" : "is not null", null);
        return FilterMergedStatusCode.Success;
    }

    protected static FilterMergedStatusCode addLikeAndMatchValue(boolean likeMode, Map<String, Set<Object>> qcpMap, QFilter srcFilter) {
        String checkKey;
        String qcpStr;
        String newFilterValue = String.valueOf(srcFilter.getValue());
        if (StringUtils.isEmpty((String)newFilterValue)) {
            return FilterValueMergeContainer.addNullAndNotNullValue(likeMode, qcpMap);
        }
        switch (WildcardMatcher.getWildcardPos(newFilterValue)) {
            case None: {
                return FilterValueMergeContainer.addEqualAndInValue(likeMode ? "in" : "not in", qcpMap, srcFilter);
            }
            case Global: {
                return FilterValueMergeContainer.addNullAndNotNullValue(!likeMode, qcpMap);
            }
        }
        if (likeMode) {
            qcpStr = "like";
            checkKey = "not like";
        } else {
            qcpStr = "not like";
            checkKey = "like";
        }
        if (qcpMap.getOrDefault(checkKey, Collections.EMPTY_SET).contains(newFilterValue)) {
            return FilterMergedStatusCode.Terminated;
        }
        qcpMap.computeIfAbsent(qcpStr.toLowerCase(Locale.ENGLISH), v -> new LinkedHashSet(1)).add(newFilterValue);
        return FilterMergedStatusCode.Success;
    }

    public FilterMergedStatusCode pack() {
        Map<String, Set<Object>> filterValueBufMap;
        Map.Entry<String, Map<String, Set<Object>>> filterProp;
        if (this.mergeFilters == null || this.mergeFilters.isEmpty()) {
            return FilterMergedStatusCode.Terminated;
        }
        if (FilterMergedStatusCode.Terminated == FilterValueMergeContainer.mergeAliasName(this.mergeFilters)) {
            return FilterMergedStatusCode.Terminated;
        }
        boolean invalidFilter = false;
        Iterator<Map.Entry<String, Map<String, Set<Object>>>> iterator = this.mergeFilters.entrySet().iterator();
        while (!(!iterator.hasNext() || (filterProp = iterator.next()) != null && (filterValueBufMap = filterProp.getValue()) != null && filterValueBufMap.size() >= 1 && ((invalidFilter = FilterValueMergeContainer.mergeNullWithOtherValue(filterProp.getValue()) == FilterMergedStatusCode.Terminated) || (invalidFilter = FilterValueMergeContainer.mergeSingleWildcardKeyValue(filterProp.getValue()) == FilterMergedStatusCode.Terminated) || (invalidFilter = FilterValueMergeContainer.mergeRangeValue(filterProp.getValue()) == FilterMergedStatusCode.Terminated) || (invalidFilter = FilterValueMergeContainer.mergeRangeWithInValue(filterProp.getValue()) == FilterMergedStatusCode.Terminated) || (invalidFilter = FilterValueMergeContainer.convertSingleInToEqual(filterProp.getValue()) == FilterMergedStatusCode.Terminated) || (invalidFilter = FilterValueMergeContainer.convertSingleInToEqual(filterProp.getValue()) == FilterMergedStatusCode.Terminated)))) {
        }
        if (invalidFilter) {
            return FilterMergedStatusCode.Terminated;
        }
        return FilterMergedStatusCode.Success;
    }

    public static FilterMergedStatusCode mergeAliasName(Map<String, Map<String, Set<Object>>> mergeFilters) {
        if (mergeFilters == null || mergeFilters.isEmpty()) {
            return FilterMergedStatusCode.Success;
        }
        HashMap lookupNames = new HashMap(mergeFilters.size());
        mergeFilters.keySet().forEach(n -> lookupNames.put(n.toLowerCase(Locale.ENGLISH), n));
        HashMap<String, List> mergeNames = new HashMap<String, List>(mergeFilters.size());
        for (String name : mergeFilters.keySet()) {
            String nameBuf = name.toLowerCase(Locale.ENGLISH);
            if (nameBuf.endsWith(".id")) {
                mergeNames.computeIfAbsent(name, v -> new LinkedList());
                continue;
            }
            String key = (String)lookupNames.get(nameBuf + ".id");
            if (key == null) continue;
            mergeNames.computeIfAbsent(key, v -> new LinkedList()).add(name);
        }
        boolean isValidFilter = true;
        for (Map.Entry en : mergeNames.entrySet()) {
            if (((List)en.getValue()).isEmpty()) continue;
            for (String mergeFieldName : (List)en.getValue()) {
                Map<String, Set<Object>> filterValues = mergeFilters.remove(mergeFieldName);
                if (filterValues == null) continue;
                for (Map.Entry<String, Set<Object>> subEn : filterValues.entrySet()) {
                    block20 : switch (subEn.getKey()) {
                        case "=": 
                        case "in": 
                        case "!=": 
                        case "<>": 
                        case "not in": {
                            isValidFilter = FilterMergedStatusCode.Success == FilterValueMergeContainer.addFilter(new QFilter((String)en.getKey(), subEn.getKey(), subEn.getValue()), mergeFilters);
                            break;
                        }
                        case "is null": {
                            isValidFilter = FilterMergedStatusCode.Success == FilterValueMergeContainer.addFilter(QFilter.isNull((String)((String)en.getKey())), mergeFilters);
                            break;
                        }
                        case "is not null": {
                            isValidFilter = FilterMergedStatusCode.Success == FilterValueMergeContainer.addFilter(QFilter.isNotNull((String)((String)en.getKey())), mergeFilters);
                            break;
                        }
                        case ">": 
                        case "<": 
                        case ">=": 
                        case "<=": {
                            if (subEn.getValue().isEmpty()) {
                                isValidFilter = FilterMergedStatusCode.Success == FilterValueMergeContainer.addFilter(new QFilter((String)en.getKey(), subEn.getKey(), null), mergeFilters);
                                break;
                            }
                            isValidFilter = FilterMergedStatusCode.Success == FilterValueMergeContainer.addFilter(new QFilter((String)en.getKey(), subEn.getKey(), subEn.getValue().iterator().next()), mergeFilters);
                            break;
                        }
                        case "like": 
                        case "match": 
                        case "ilike": 
                        case "not like": 
                        case "ftlike": {
                            if (subEn.getValue().isEmpty()) {
                                isValidFilter = FilterMergedStatusCode.Success == FilterValueMergeContainer.addFilter(QFilter.isNull((String)((String)en.getKey())), mergeFilters);
                                break;
                            }
                            for (Object fValue : subEn.getValue()) {
                                isValidFilter = FilterMergedStatusCode.Success == FilterValueMergeContainer.addFilter(new QFilter((String)en.getKey(), subEn.getKey(), fValue), mergeFilters);
                                if (isValidFilter) continue;
                                break block20;
                            }
                            break;
                        }
                    }
                    if (isValidFilter) continue;
                    break;
                }
                if (isValidFilter) continue;
                break;
            }
            if (isValidFilter) continue;
            break;
        }
        return isValidFilter ? FilterMergedStatusCode.Success : FilterMergedStatusCode.Terminated;
    }

    public static FilterMergedStatusCode mergeNullWithOtherValue(Map<String, Set<Object>> qcpMap) {
        if (qcpMap == null || qcpMap.isEmpty()) {
            return FilterMergedStatusCode.Success;
        }
        if (qcpMap.size() > 1) {
            if (qcpMap.containsKey("is null")) {
                return FilterMergedStatusCode.Terminated;
            }
            qcpMap.remove("is not null");
        }
        return FilterMergedStatusCode.Success;
    }

    public static FilterMergedStatusCode mergeSingleWildcardKeyValue(Map<String, Set<Object>> qcpMap) {
        ArrayList[] checkStrList = new ArrayList[]{new ArrayList(8), new ArrayList(8)};
        HashMap<PairTuple<Integer, String>, String> compareToOriginalap = new HashMap<PairTuple<Integer, String>, String>(8);
        for (String qcp : CheckSingleWildCardKeyQcp) {
            String filterValStr;
            Set<Object> filterValues = qcpMap.get(qcp);
            if (filterValues == null || filterValues.isEmpty()) continue;
            LinkedHashSet<Object> newFilterValues = new LinkedHashSet<Object>(filterValues.size());
            block5: for (Object f_val : filterValues) {
                int groupKey;
                String originalValStr = String.valueOf(f_val);
                switch (WildcardMatcher.getWildcardPos(originalValStr)) {
                    case Suffix: {
                        groupKey = 0;
                        break;
                    }
                    case Prefix: {
                        groupKey = 1;
                        break;
                    }
                    default: {
                        newFilterValues.add(f_val);
                        continue block5;
                    }
                }
                filterValStr = WildcardMatcher.trimWildcardKeys(WildcardPositionEnum.Pre_Suffix, originalValStr);
                checkStrList[groupKey].add(filterValStr);
                compareToOriginalap.put(new PairTuple<Integer, String>(groupKey, filterValStr), originalValStr);
            }
            for (int i = 0; i < checkStrList.length; ++i) {
                if (checkStrList[i].isEmpty()) continue;
                filterValStr = FilterValueMergeContainer.getMaxIntersectValue(checkStrList[i], i == 0, true);
                if (filterValStr == null) {
                    return FilterMergedStatusCode.Terminated;
                }
                newFilterValues.add(compareToOriginalap.get(new PairTuple<Integer, String>(i, filterValStr)));
            }
            qcpMap.put(qcp, newFilterValues);
        }
        return FilterMergedStatusCode.Success;
    }

    public static FilterMergedStatusCode mergeRangeValue(Map<String, Set<Object>> qcpMap) {
        ArrayList<String> rangeQcps = new ArrayList<String>(Arrays.asList(Range_QCPs));
        rangeQcps.retainAll(qcpMap.keySet());
        if (rangeQcps.isEmpty()) {
            return FilterMergedStatusCode.Success;
        }
        Comparable[] rangeValues = new Comparable[Range_QCPs.length];
        int checkStatus = 0;
        for (int i = 0; i < Range_QCPs.length; ++i) {
            Set<Object> valBufList = qcpMap.get(Range_QCPs[i]);
            if (valBufList == null || valBufList.isEmpty()) continue;
            rangeValues[i] = (Comparable)valBufList.iterator().next();
            valBufList.clear();
            checkStatus = (byte)(checkStatus | 1 << i);
        }
        Comparable[] check_cross_range = new Comparable[2];
        if ((checkStatus & 3) == 3) {
            switch (rangeValues[0].compareTo(rangeValues[1])) {
                case -1: {
                    rangeValues[0] = null;
                    break;
                }
                case 0: 
                case 1: {
                    rangeValues[1] = null;
                }
            }
        }
        Comparable comparable = check_cross_range[0] = rangeValues[0] != null ? rangeValues[0] : rangeValues[1];
        if ((checkStatus & 0xC) == 12) {
            switch (rangeValues[2].compareTo(rangeValues[3])) {
                case -1: 
                case 0: {
                    rangeValues[3] = null;
                    break;
                }
                case 1: {
                    rangeValues[2] = null;
                }
            }
        }
        Comparable comparable2 = check_cross_range[1] = rangeValues[2] != null ? rangeValues[2] : rangeValues[3];
        if (check_cross_range[0] != null && check_cross_range[1] != null) {
            switch (check_cross_range[0].compareTo(check_cross_range[1])) {
                case 1: {
                    return FilterMergedStatusCode.Terminated;
                }
                case 0: {
                    if (rangeValues[1] != null || rangeValues[3] != null) break;
                    return FilterMergedStatusCode.Terminated;
                }
            }
        }
        for (int i = 0; i < Range_QCPs.length; ++i) {
            if (rangeValues[i] != null) {
                qcpMap.get(Range_QCPs[i]).add(rangeValues[i]);
                continue;
            }
            qcpMap.remove(Range_QCPs[i]);
        }
        return FilterMergedStatusCode.Success;
    }

    public static FilterMergedStatusCode mergeRangeWithInValue(Map<String, Set<Object>> qcpMap) {
        ArrayList<String> rangeQcps = new ArrayList<String>(Arrays.asList(Range_QCPs));
        rangeQcps.retainAll(qcpMap.keySet());
        if (!rangeQcps.isEmpty()) {
            HashMap newResultMap = new HashMap(qcpMap.size());
            for (String in_qcp : In_Group_QCPs) {
                Set<Object> inFilterValues = qcpMap.get(in_qcp);
                if (inFilterValues == null || inFilterValues.isEmpty()) continue;
                for (String range_qcp : rangeQcps) {
                    FilterMergedStatusCode statusCode = FilterValueMergeContainer.mergeRangeWithInValue(range_qcp, (Comparable)qcpMap.get(range_qcp).iterator().next(), in_qcp, inFilterValues, (newQcp, newVals) -> {
                        newResultMap.put(newQcp, newVals);
                        return FilterMergedStatusCode.Success;
                    });
                    if (FilterMergedStatusCode.Terminated != statusCode) continue;
                    return statusCode;
                }
            }
            if (!newResultMap.isEmpty()) {
                qcpMap.putAll(newResultMap);
            }
        }
        return FilterMergedStatusCode.Success;
    }

    public static FilterMergedStatusCode convertSingleInToEqual(Map<String, Set<Object>> qcpMap) {
        if (qcpMap != null && !qcpMap.isEmpty()) {
            for (String[] qcp : SingleInToEqual_Check_QCPS) {
                Set<Object> value = qcpMap.get(qcp[0]);
                if (value == null || value.size() > 1) continue;
                qcpMap.put(qcp[1], qcpMap.remove(qcp[0]));
            }
        }
        return FilterMergedStatusCode.Success;
    }

    public static FilterMergedStatusCode mergeRangeWithInValue(String rangeFilterQcp, Comparable rangeFilterValue, String inFilterQcp, Set<Object> inFilterValue, BiFunction<String, Set<Object>, FilterMergedStatusCode> outputFunc) {
        if (rangeFilterValue == null) {
            return outputFunc.apply(inFilterQcp, inFilterValue);
        }
        if (inFilterValue == null) {
            return outputFunc.apply(rangeFilterQcp, new HashSet<Comparable>(Collections.singleton(rangeFilterValue)));
        }
        LinkedList<Comparable> mergeValueBufList = new LinkedList<Comparable>();
        boolean useEqualRange = false;
        block20: for (Object newVal : inFilterValue) {
            if (newVal instanceof Number || newVal instanceof Date) {
                Comparable compNewValue = (Comparable)newVal;
                switch (rangeFilterQcp) {
                    case ">": {
                        if (compNewValue.compareTo(rangeFilterValue) <= 0) continue block20;
                        mergeValueBufList.add((Comparable)newVal);
                        break;
                    }
                    case ">=": {
                        if (compNewValue.compareTo(rangeFilterValue) < 0) continue block20;
                        mergeValueBufList.add((Comparable)newVal);
                        break;
                    }
                    case "<": {
                        if (compNewValue.compareTo(rangeFilterValue) >= 0) continue block20;
                        mergeValueBufList.add((Comparable)newVal);
                        break;
                    }
                    case "<=": {
                        if (compNewValue.compareTo(rangeFilterValue) > 0) continue block20;
                        mergeValueBufList.add((Comparable)newVal);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Invalid Range Filter QCP=%s", rangeFilterQcp));
                    }
                }
                continue;
            }
            return FilterMergedStatusCode.Terminated;
        }
        switch (inFilterQcp) {
            case "in": {
                if (mergeValueBufList.isEmpty()) {
                    return FilterMergedStatusCode.Terminated;
                }
                Collections.sort(mergeValueBufList);
                return outputFunc.apply(inFilterQcp, new LinkedHashSet(mergeValueBufList));
            }
            case "not in": {
                if (!mergeValueBufList.isEmpty()) {
                    Collections.sort(mergeValueBufList);
                    outputFunc.apply("not in", new LinkedHashSet(mergeValueBufList));
                }
                return outputFunc.apply(rangeFilterQcp, new HashSet<Comparable>(Collections.singleton(rangeFilterValue)));
            }
        }
        throw new IllegalArgumentException(String.format("Invalid In Filter QCP=%s", inFilterQcp));
    }

    public boolean isEmpty() {
        return this.mergeFilters.isEmpty();
    }

    public int size() {
        return this.mergeFilters.size();
    }

    public void clear() {
        this.mergeFilters.clear();
    }

    public boolean isValidFilterGroup() {
        return this.isValidFilterGroup;
    }

    public void setValidFilterGroup(boolean validFilterGroup) {
        this.isValidFilterGroup = validFilterGroup;
    }
}

