/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.flex;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.flex.FlexDefaultValueUserType;

public class FlexDefaultValueBatchReader {
    private static final String SELECT = "org,usertype,entryentity.account.masterid,entryentity.currency currency,entryentity.assgrptype.flexfield flexfield,entryentity.txtval txtval,entryentity.basepk basepk";
    private static final String GL_ASSGRPDEFVAL = "gl_assgrpdefval";
    private static final String ORG = "org";
    private static final String USER_TYPE = "usertype";
    private static final String ACCOUNT_MASTERID = "entryentity.account.masterid";
    private static final String CURRENCY = "currency";
    private static final String FLEXFIELD = "flexfield";
    private static final String TXT_VAL = "txtval";
    private static final String BASE_PK = "basepk";
    private static final String MULUSER_FBASEDATAID = "muluser.fbasedataid";

    public static FlexDefaultValueMatchCollection init(Collection<Long> orgIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(orgIds), (Object)("illegal orgIds:" + orgIds));
        QFilterBuilder qFilterBuilder = FlexDefaultValueBatchReader.buildQFilterBuilder(orgIds);
        FlexDefaultValueMatchCollection result = new FlexDefaultValueMatchCollection();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FlexDefaultValueBatchReader.class.getName(), (String)GL_ASSGRPDEFVAL, (String)SELECT, (QFilter[])qFilterBuilder.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                result.defaultKeyValueMap.put(new FlexDefaultValueKey(row.getLong(ACCOUNT_MASTERID), row.getLong(CURRENCY), FlexDefaultValueUserType.fromValue(row.getString(USER_TYPE)), row.getString(FLEXFIELD)), StringUtils.isBlank((String)row.getString(TXT_VAL)) ? row.getLong(BASE_PK) : row.getString(TXT_VAL));
            }
        }
        return result;
    }

    private static QFilterBuilder buildQFilterBuilder(Collection<Long> orgIds) {
        QFilterBuilder result = new QFilterBuilder();
        result.addIn(ORG, orgIds);
        result.add(new QFilter(USER_TYPE, "=", (Object)FlexDefaultValueUserType.ALL.getValue()).or(new QFilter(USER_TYPE, "=", (Object)FlexDefaultValueUserType.MUL.getValue()).and(new QFilter(MULUSER_FBASEDATAID, "=", (Object)RequestContext.get().getCurrUserId()))));
        return result;
    }

    private static class FlexDefaultValueKey {
        private final Long accountMasterId;
        private final Long currencyId;
        private final FlexDefaultValueUserType userType;
        private final String flexfield;

        public FlexDefaultValueKey(Long accountMasterId, Long currencyId, FlexDefaultValueUserType userType, String flexfield) {
            this.accountMasterId = accountMasterId;
            this.currencyId = currencyId;
            this.userType = userType;
            this.flexfield = flexfield;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlexDefaultValueKey that = (FlexDefaultValueKey)o;
            if (!Objects.equals(this.accountMasterId, that.accountMasterId)) {
                return false;
            }
            if (!Objects.equals(this.currencyId, that.currencyId)) {
                return false;
            }
            if (this.userType != that.userType) {
                return false;
            }
            return Objects.equals(this.flexfield, that.flexfield);
        }

        public int hashCode() {
            int result = this.accountMasterId != null ? this.accountMasterId.hashCode() : 0;
            result = 31 * result + (this.currencyId != null ? this.currencyId.hashCode() : 0);
            result = 31 * result + (this.userType != null ? this.userType.hashCode() : 0);
            result = 31 * result + (this.flexfield != null ? this.flexfield.hashCode() : 0);
            return result;
        }
    }

    private static enum MatchPriority {
        FULL_MATCH(Map::get),
        CURRENCY_NONE((map, key) -> map.get(new FlexDefaultValueKey(((FlexDefaultValueKey)key).accountMasterId, 0L, FlexDefaultValueUserType.MUL, ((FlexDefaultValueKey)key).flexfield))),
        USERTYPE_ALL((map, key) -> map.get(new FlexDefaultValueKey(((FlexDefaultValueKey)key).accountMasterId, ((FlexDefaultValueKey)key).currencyId, FlexDefaultValueUserType.ALL, ((FlexDefaultValueKey)key).flexfield))),
        CURRENCY_NONE_AND_USERTYPE_ALL((map, key) -> map.get(new FlexDefaultValueKey(((FlexDefaultValueKey)key).accountMasterId, 0L, FlexDefaultValueUserType.ALL, ((FlexDefaultValueKey)key).flexfield))),
        ACCOUNT_NONE((map, key) -> map.get(new FlexDefaultValueKey(0L, ((FlexDefaultValueKey)key).currencyId, FlexDefaultValueUserType.MUL, ((FlexDefaultValueKey)key).flexfield))),
        ACCOUNT_AND_CURRENCY_NONE((map, key) -> map.get(new FlexDefaultValueKey(0L, 0L, FlexDefaultValueUserType.MUL, ((FlexDefaultValueKey)key).flexfield))),
        ACCOUNT_AND_USERTYPE_ALL((map, key) -> map.get(new FlexDefaultValueKey(0L, ((FlexDefaultValueKey)key).currencyId, FlexDefaultValueUserType.ALL, ((FlexDefaultValueKey)key).flexfield))),
        FUZZY_MATCH((map, key) -> map.get(new FlexDefaultValueKey(0L, 0L, FlexDefaultValueUserType.ALL, ((FlexDefaultValueKey)key).flexfield)));

        private final BiFunction<Map<FlexDefaultValueKey, Object>, FlexDefaultValueKey, Object> matchFunc;

        private MatchPriority(BiFunction<Map<FlexDefaultValueKey, Object>, FlexDefaultValueKey, Object> matchFunc) {
            this.matchFunc = matchFunc;
        }
    }

    public static class FlexDefaultValueMatchCollection {
        private final Map<FlexDefaultValueKey, Object> defaultKeyValueMap = new HashMap<FlexDefaultValueKey, Object>(32);

        public Object getDefaultValue(Long accountMasterId, Long currencyId, String flexField) {
            if (this.defaultKeyValueMap.isEmpty()) {
                return null;
            }
            FlexDefaultValueKey defaultValueKey = new FlexDefaultValueKey(accountMasterId, currencyId, FlexDefaultValueUserType.MUL, flexField);
            for (MatchPriority matchPriority : MatchPriority.values()) {
                Object resultBuf = matchPriority.matchFunc.apply(this.defaultKeyValueMap, defaultValueKey);
                if (resultBuf == null) continue;
                return resultBuf;
            }
            return null;
        }
    }
}

