/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.flex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.util.flex.FlexDefaultValue;
import kd.fi.bd.util.flex.FlexDefaultValueParam;
import kd.fi.bd.util.flex.FlexDefaultValueUserType;

public class FlexDefaultValueUtil {
    private static final String SELECT_FIELDS = "usertype,entryentity.account,entryentity.currency,entryentity.assgrptype.flexfield,entryentity.txtval,entryentity.basepk";
    private static final String GL_ASSGRPDEFVAL = "gl_assgrpdefval";
    private static final String ORG = "org";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String USERTYPE = "usertype";
    private static final String ENTRYENTITY_TXTVAL = "entryentity.txtval";
    private static final String ENTRYENTITY_BASEPK = "entryentity.basepk";
    private static final String ENTRYENTITY_ACCOUNT = "entryentity.account";
    private static final String ENTRYENTITY_ASSGRPTYPE_FLEXFIELD = "entryentity.assgrptype.flexfield";
    private static final String ENTRYENTITY_CURRENCY = "entryentity.currency";
    private static final String MULUSER_FBASEDATAID = "muluser.fbasedataid";

    private FlexDefaultValueUtil() {
    }

    public static Map<String, Object> getDefaultValue(FlexDefaultValueParam param) {
        if (param.getFlexFields().isEmpty()) {
            return Collections.emptyMap();
        }
        List<FlexDefaultValue> flexDefaultValueList = FlexDefaultValueUtil.query(param);
        HashMap<String, Object> valueMap = new HashMap<String, Object>(param.getFlexFields().size());
        for (FlexDefaultValue defaultValue : flexDefaultValueList) {
            if (!valueMap.containsKey(defaultValue.getFlexField())) {
                valueMap.put(defaultValue.getFlexField(), defaultValue.getValue());
            }
            if (valueMap.size() != param.getFlexFields().size()) continue;
            return valueMap;
        }
        return valueMap;
    }

    private static List<FlexDefaultValue> query(FlexDefaultValueParam param) {
        QFBuilder qfBuilder = FlexDefaultValueUtil.buildFilter(param);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FlexDefaultValueUtil.class.getName(), (String)GL_ASSGRPDEFVAL, (String)SELECT_FIELDS, (QFilter[])qfBuilder.toArray(), null);){
            ArrayList<FlexDefaultValue> flexDefaultValues = new ArrayList<FlexDefaultValue>(param.getFlexFields().size());
            for (Row row : dataSet) {
                String txtVal = row.getString(ENTRYENTITY_TXTVAL);
                String value = StringUtils.isBlank((CharSequence)txtVal) ? row.getLong(ENTRYENTITY_BASEPK) : txtVal;
                FlexDefaultValue flexDefaultValue = new FlexDefaultValue(row.getString(USERTYPE), row.getLong(ENTRYENTITY_ACCOUNT), row.getLong(ENTRYENTITY_CURRENCY), row.getString(ENTRYENTITY_ASSGRPTYPE_FLEXFIELD), value);
                flexDefaultValues.add(flexDefaultValue);
            }
            flexDefaultValues.sort((o1, o2) -> Integer.compare(o2.getCompareIndex(), o1.getCompareIndex()));
            ArrayList<FlexDefaultValue> arrayList = flexDefaultValues;
            return arrayList;
        }
    }

    private static QFBuilder buildFilter(FlexDefaultValueParam param) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ORG, "=", param.getOrgId());
        qfBuilder.add(ACCOUNTTABLE, "=", param.getAccTabId());
        ArrayList<Long> curIdList = new ArrayList<Long>(Collections.singleton(0L));
        if (param.getCurId() > 0L) {
            curIdList.add(param.getCurId());
        }
        qfBuilder.add(ENTRYENTITY_CURRENCY, "in", curIdList);
        qfBuilder.add(ENTRYENTITY_ASSGRPTYPE_FLEXFIELD, "in", param.getFlexFields());
        ArrayList<Long> accIdList = new ArrayList<Long>(Collections.singleton(0L));
        if (param.getAccMasterId() > 0L) {
            accIdList.addAll(QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter("masterid", "=", (Object)param.getAccMasterId()).toArray(), null, (int)-1));
        }
        qfBuilder.add(ENTRYENTITY_ACCOUNT, "in", accIdList);
        if (param.getUserId() <= 0L) {
            qfBuilder.add(USERTYPE, "=", FlexDefaultValueUserType.ALL.getValue());
        } else {
            QFilter userOr = new QFilter(USERTYPE, "=", (Object)FlexDefaultValueUserType.ALL.getValue()).or(new QFilter(USERTYPE, "=", (Object)FlexDefaultValueUserType.MUL.getValue()).and(new QFilter(MULUSER_FBASEDATAID, "=", (Object)param.getUserId())));
            qfBuilder.add(userOr);
        }
        return qfBuilder;
    }
}

