/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import kd.fi.bd.util.iterators.AbstractBufferContextWrapper;
import kd.fi.bd.util.iterators.impl.ArrayIterator;

public class ArrayBufferContextWrapper<SRC, OUT>
extends AbstractBufferContextWrapper<OUT[], SRC, OUT> {
    public ArrayBufferContextWrapper(OUT[] batchBufferRef, boolean skipNullValue) {
        super(batchBufferRef, skipNullValue);
        this.bufferSize = batchBufferRef.length;
    }

    public ArrayBufferContextWrapper(OUT[] batchBufferRef) {
        this(batchBufferRef, true);
    }

    protected ArrayBufferContextWrapper(int bufferSize, boolean skipNullValue) {
        super(skipNullValue, (seq, val) -> val);
        this.bufferSize = bufferSize;
    }

    public ArrayBufferContextWrapper(int bufferSize) {
        this(bufferSize, true);
    }

    protected void lazyInitBatchBuffer(OUT sourceVal, int batchSize) {
        if (sourceVal == null) {
            throw new IllegalArgumentException("Source Value cannot be null!");
        }
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch Size must greater than 0");
        }
        super.lazyInitBuffer((Object[])Array.newInstance(sourceVal.getClass(), batchSize), batchSize);
    }

    @Override
    protected boolean addValueIntoBuffer(int pos, OUT newValue) {
        ((Object[])this.bufferContext)[pos] = newValue;
        return true;
    }

    @Override
    public int size() {
        return ((Object[])this.bufferContext).length;
    }

    @Override
    public boolean isEmpty() {
        return this.bufferContext == null || ((Object[])this.bufferContext).length < 1;
    }

    @Override
    public void clear() {
        Arrays.fill((Object[])this.bufferContext, null);
    }

    @Override
    public OUT[] toArray() {
        if (this.currentPos[1] >= ((Object[])this.bufferContext).length) {
            return (Object[])this.bufferContext;
        }
        return Arrays.copyOf((Object[])this.bufferContext, this.currentPos[1]);
    }

    @Override
    public Iterator<OUT> iterator() {
        return new ArrayIterator<Object>((Object[])this.bufferContext, 0, this.getCurrentSeqNum());
    }
}

