/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.iterators.IBufferContextWrapper;
import kd.fi.bd.util.iterators.impl.AbstractIteratorWrapper;
import kd.fi.bd.util.iterators.impl.ArrayBufferContextWrapper;

public class ConvertibleBufferedIterator<SRC, OUTPUT>
extends AbstractIteratorWrapper<Iterator<SRC>, OUTPUT[]> {
    protected IBufferContextWrapper<SRC, OUTPUT> _bufferContext;

    public ConvertibleBufferedIterator(Iterator<SRC> sourceIterator, IBufferContextWrapper<SRC, OUTPUT> buffer) {
        super(sourceIterator);
        this._bufferContext = buffer;
    }

    @Override
    public boolean hasNext() {
        return this._hasValue && ((Iterator)this.valSource).hasNext();
    }

    @Override
    public OUTPUT[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements!");
        }
        boolean pos = false;
        while (((Iterator)this.valSource).hasNext() && !this._bufferContext.addValue(((Iterator)this.valSource).next())) {
        }
        return this._bufferContext.resetToNextBatch();
    }

    public static void main(String[] args) {
        LinkedList<String> source = new LinkedList<String>();
        for (int i = 0; i < 10; ++i) {
            source.add("Test-" + i);
        }
        PairTuple[] buffer = new PairTuple[3];
        ArrayBufferContextWrapper<String, PairTuple> wrapper = new ArrayBufferContextWrapper<String, PairTuple>((OUT[])buffer, true);
        wrapper.setFormatConvertFunc((idx, val) -> new PairTuple<Integer, String>((Integer)idx, (String)val));
        ConvertibleBufferedIterator bufferedIterator = new ConvertibleBufferedIterator(source.iterator(), wrapper);
        while (bufferedIterator.hasNext()) {
            System.out.println(Arrays.deepToString(bufferedIterator.next()));
        }
    }
}

