/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.iterators.IDataTreeIterator;

public class IDataTreeModelIterator
implements Iterator<Object> {
    private Deque<PairTuple<Boolean, Iterator>> iteratorStack = new ArrayDeque<PairTuple<Boolean, Iterator>>();
    private boolean canMoveNext = false;

    public IDataTreeModelIterator() {
    }

    public IDataTreeModelIterator(IDataTreeIterator rootTreeIterator, Object ... params) {
        this();
        this.reset(rootTreeIterator, params);
    }

    public void reset(IDataTreeIterator rootTreeIterator, Object ... params) {
        this.iteratorStack.clear();
        this.canMoveNext = rootTreeIterator == null ? false : this.pushChildIteratorToStack(this.parseValidTreeIterator(rootTreeIterator)) != null;
    }

    @Override
    public boolean hasNext() {
        if (this.iteratorStack.isEmpty()) {
            return false;
        }
        if (this.iteratorStack.peek().getValue().hasNext()) {
            return true;
        }
        this.canMoveNext = this.pushChildIteratorToStack(this.getNextValidIterator()) != null;
        return this.canMoveNext;
    }

    private Iterator<?> getNextValidIteratorFromTreeIterator(Iterator<IDataTreeIterator> srcIterator) {
        Iterator<?> iteratorBuf = null;
        while (srcIterator.hasNext()) {
            IDataTreeIterator buf = srcIterator.next();
            if (buf == null || (iteratorBuf = buf.getChildIterator(new Object[0])) == null || !iteratorBuf.hasNext()) continue;
            return iteratorBuf;
        }
        return iteratorBuf;
    }

    protected LinkedList<PairTuple<Boolean, Iterator>> getNextValidIterator() {
        LinkedList<PairTuple<Boolean, Iterator>> resultList = new LinkedList<PairTuple<Boolean, Iterator>>();
        this.iteratorStack.pop();
        if (this.iteratorStack.isEmpty()) {
            return resultList;
        }
        Iterator<?> iteratorBuf = null;
        PairTuple<Boolean, Iterator> currentNode = this.iteratorStack.peek();
        while (currentNode.getValue().hasNext()) {
            if (currentNode.getKey().booleanValue()) {
                iteratorBuf = this.getNextValidIteratorFromTreeIterator(currentNode.getValue());
                resultList.add(new PairTuple(Boolean.TRUE, iteratorBuf));
                break;
            }
            resultList = this.parseValidTreeIterator((IDataTreeIterator)currentNode.getValue().next());
            if (resultList.isEmpty()) continue;
        }
        if (resultList.isEmpty() && !this.iteratorStack.isEmpty()) {
            return this.getNextValidIterator();
        }
        return resultList;
    }

    protected Iterator<?> pushChildIteratorToStack(LinkedList<PairTuple<Boolean, Iterator>> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return null;
        }
        Iterator iteratorBuf = null;
        for (PairTuple pairTuple : sourceList) {
            if (!((Iterator)pairTuple.getValue()).hasNext()) continue;
            this.iteratorStack.push(pairTuple);
            if (!((Boolean)pairTuple.getKey()).booleanValue()) continue;
            iteratorBuf = (Iterator)pairTuple.getValue();
        }
        return iteratorBuf;
    }

    protected LinkedList<PairTuple<Boolean, Iterator>> parseValidTreeIterator(IDataTreeIterator rootTreeIterator) {
        LinkedList<PairTuple<Boolean, Iterator>> resultList = new LinkedList<PairTuple<Boolean, Iterator>>();
        if (rootTreeIterator == null) {
            return resultList;
        }
        Iterator<?> iteratorBuf = rootTreeIterator.getChildIterator(new Object[0]);
        if (iteratorBuf != null && iteratorBuf.hasNext()) {
            IDataTreeIterator childTreeIterator;
            resultList.add(new PairTuple(rootTreeIterator.isLeafBranch(new Object[0]), iteratorBuf));
            if (!rootTreeIterator.isLeafBranch(new Object[0]) && (childTreeIterator = (IDataTreeIterator)iteratorBuf.next()) != null) {
                resultList.addAll(this.parseValidTreeIterator(childTreeIterator));
            }
        }
        return resultList;
    }

    protected LinkedList<PairTuple<Boolean, Iterator>> pushChildIteratorToStack(Iterator<?> iterator) {
        LinkedList<PairTuple<Boolean, Iterator>> resultList = new LinkedList<PairTuple<Boolean, Iterator>>();
        if (iterator == null || !iterator.hasNext()) {
            return resultList;
        }
        Iterator<?> iteratorBuf = null;
        Object item = iterator.next();
        Class<?> itemClassType = item.getClass();
        if (IDataTreeIterator.class.isAssignableFrom(itemClassType)) {
            IDataTreeIterator treeIterator = (IDataTreeIterator)item;
            iteratorBuf = treeIterator.getChildIterator(new Object[0]);
            if (iteratorBuf != null && iteratorBuf.hasNext()) {
                if (treeIterator.isLeafBranch(new Object[0])) {
                    resultList.add(new PairTuple(Boolean.TRUE, iteratorBuf));
                } else {
                    resultList.addAll(this.pushChildIteratorToStack(treeIterator.getChildIterator(new Object[0])));
                }
            }
        } else {
            resultList.add(new PairTuple<Boolean, Object>(Boolean.TRUE, iteratorBuf));
        }
        return resultList;
    }

    @Override
    public Object next() {
        if (!this.canMoveNext) {
            this.canMoveNext = this.hasNext();
        }
        if (this.canMoveNext) {
            this.canMoveNext = false;
            return this.iteratorStack.peek().getValue().next();
        }
        throw new IndexOutOfBoundsException();
    }
}

