/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.pipe;

import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.util.exception.IExceptionListener;
import kd.fi.bd.util.pipe.datablock.IAsyncStreamDataBlock;
import kd.fi.bd.util.pipe.datablock.SimpleAsyncStreamDataBlock;

public class AsyncStreamPipe<E> {
    private static final ThreadPool CONSUMER_POOL = ThreadPools.newCachedThreadPool((String)AsyncStreamPipe.class.getName(), (int)1, (int)10);
    private static final Log logger = LogFactory.getLog(AsyncStreamPipe.class);
    public static final int PIPE_NOT_RUNNING = 0;
    public static final int PIPE_STARTING = 1;
    public static final int PIPE_RUNNING = 2;
    public static final int PIPE_STOPPING = 3;
    protected ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> dataQueue = new ConcurrentLinkedQueue();
    protected BiConsumer<Integer, IAsyncStreamDataBlock<E>> dataConsumer;
    protected AtomicInteger pipeStatus = new AtomicInteger(0);
    protected AtomicInteger activeConsumerCnt = new AtomicInteger(0);
    protected AtomicInteger waitingDataBlockCnt;
    protected IExceptionListener exceptionListener;
    protected int consumerThreadCnt;
    protected List<Future> consumerThreadRefs;
    protected Function<PipeConsumerTask, Future> threadPoolFunc;

    public AsyncStreamPipe(int consumerThreadCnt, Function<PipeConsumerTask, Future> threadPoolFunc) {
        this.consumerThreadCnt = consumerThreadCnt;
        this.consumerThreadRefs = new LinkedList<Future>();
        this.waitingDataBlockCnt = new AtomicInteger(0);
        this.threadPoolFunc = threadPoolFunc;
        if (this.threadPoolFunc == null) {
            throw new IllegalArgumentException("Pipe required Thread Pool cannot be null!");
        }
    }

    public AsyncStreamPipe(int threadCnt) {
        this(threadCnt, arg_0 -> ((ThreadPool)CONSUMER_POOL).submit(arg_0));
    }

    public AsyncStreamPipe() {
        this(1);
    }

    public AsyncStreamPipe(int consumerThreadCnt, Function<PipeConsumerTask, Future> threadPoolFunc, BiConsumer<Integer, IAsyncStreamDataBlock<E>> consumer) {
        this(consumerThreadCnt, threadPoolFunc);
        this.attach(consumer);
    }

    public void attach(BiConsumer<Integer, IAsyncStreamDataBlock<E>> consumer) {
        if (this.isRunning()) {
            this.close();
        }
        this.updatePipeStatus(1);
        this.dataConsumer = consumer;
        for (int i = 0; i < this.consumerThreadCnt; ++i) {
            this.consumerThreadRefs.add(this.threadPoolFunc.apply(new PipeConsumerTask(i, consumer)));
        }
        this.updatePipeStatus(2);
    }

    public void restart(boolean clearQueue) {
        if (clearQueue) {
            this.clearDataQueue();
        }
        this.attach(this.dataConsumer);
    }

    protected void clearDataQueue() {
        while (!this.dataQueue.isEmpty()) {
            IAsyncStreamDataBlock<E> dataBlock = this.dataQueue.poll();
            if (dataBlock == null) continue;
            dataBlock.onStageCompleted(CDCStageEnum.Canceled, false);
        }
        this.dataQueue.clear();
        this.waitingDataBlockCnt.set(0);
    }

    protected void updatePipeStatus(int statusCode) {
        this.pipeStatus.set(statusCode);
    }

    public boolean isStopped() {
        int status = this.pipeStatus.get();
        return status == 0 || status == 3;
    }

    public boolean isRunning() {
        int status = this.pipeStatus.get();
        return status == 2 || status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDataConsume(int consumerIndex, BiConsumer<Integer, IAsyncStreamDataBlock<E>> consumer) {
        this.activeConsumerCnt.incrementAndGet();
        AtomicInteger atomicInteger = this.activeConsumerCnt;
        synchronized (atomicInteger) {
            this.activeConsumerCnt.notifyAll();
        }
        IAsyncStreamDataBlock<E> dataBlock = null;
        while (this.isRunning()) {
            try {
                ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> concurrentLinkedQueue;
                dataBlock = this.dataQueue.poll();
                if (dataBlock != null) {
                    this.waitingDataBlockCnt.decrementAndGet();
                    if (this.dataQueue.isEmpty()) {
                        concurrentLinkedQueue = this.dataQueue;
                        synchronized (concurrentLinkedQueue) {
                            this.dataQueue.notifyAll();
                        }
                    }
                    consumer.accept(consumerIndex, dataBlock);
                    dataBlock.onStageCompleted(CDCStageEnum.Completed, true);
                    continue;
                }
                concurrentLinkedQueue = this.dataQueue;
                synchronized (concurrentLinkedQueue) {
                    this.dataQueue.wait(500L);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                if (this.exceptionListener != null) {
                    this.exceptionListener.onError(ex);
                }
                if (dataBlock == null) continue;
                dataBlock.onStageCompleted(CDCStageEnum.Completed, false);
            }
        }
        int result = this.activeConsumerCnt.decrementAndGet();
        AtomicInteger atomicInteger2 = this.activeConsumerCnt;
        synchronized (atomicInteger2) {
            this.activeConsumerCnt.notifyAll();
        }
        return result;
    }

    protected static void closeClosable(Closeable src) {
        if (src != null) {
            try {
                src.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) {
        if (this.isRunning()) {
            Object object;
            if (force) {
                this.clearDataQueue();
            } else {
                while (!this.dataQueue.isEmpty()) {
                    try {
                        object = this.dataQueue;
                        synchronized (object) {
                            this.dataQueue.wait(500L);
                        }
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            this.updatePipeStatus(3);
            object = this.dataQueue;
            synchronized (object) {
                this.dataQueue.notifyAll();
            }
            for (Future future : this.consumerThreadRefs) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException exception) {}
            }
            this.updatePipeStatus(0);
        }
    }

    public void close() {
        this.close(false);
    }

    public List<IAsyncStreamDataBlock<E>> putToQueue(Object groupKey, Collection<E> srcDatas) {
        LinkedList<IAsyncStreamDataBlock<IAsyncStreamDataBlock<E>>> result = new LinkedList<IAsyncStreamDataBlock<IAsyncStreamDataBlock<E>>>();
        for (E src : srcDatas) {
            result.add(this.putToQueue(groupKey, src));
        }
        return result;
    }

    public List<IAsyncStreamDataBlock<E>> putToQueue(Collection<E> srcDatas) {
        return this.putToQueue((Object)null, srcDatas);
    }

    public IAsyncStreamDataBlock<E> putToQueue(Object groupKey, E srcData) {
        return this.putToQueue(new SimpleAsyncStreamDataBlock<E>(groupKey, srcData));
    }

    public IAsyncStreamDataBlock<E> putToQueue(E srcData) {
        return this.putToQueue(null, srcData);
    }

    public IAsyncStreamDataBlock<E> putToQueue(Object groupKey, E srcData, int requiredNewPage, int requiredFlush, boolean last) {
        return this.putToQueue(new SimpleAsyncStreamDataBlock<E>(groupKey, srcData, requiredNewPage, requiredFlush, last));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAsyncStreamDataBlock<E> putToQueue(IAsyncStreamDataBlock<E> srcData) {
        this.dataQueue.offer(srcData);
        this.waitingDataBlockCnt.incrementAndGet();
        ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> concurrentLinkedQueue = this.dataQueue;
        synchronized (concurrentLinkedQueue) {
            this.dataQueue.notifyAll();
        }
        return srcData;
    }

    public IAsyncStreamDataBlock<E> peekFromQueue() {
        return this.dataQueue.peek();
    }

    public int queueSize() {
        return this.dataQueue.size();
    }

    public boolean isEmpty() {
        return this.dataQueue.isEmpty();
    }

    public IExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public BiConsumer<Integer, IAsyncStreamDataBlock<E>> getDataConsumer() {
        return this.dataConsumer;
    }

    public int getConsumerThreadCnt() {
        return this.consumerThreadCnt;
    }

    public void setConsumerThreadCnt(int consumerThreadCnt) {
        this.consumerThreadCnt = consumerThreadCnt;
    }

    public int getActiveConsumerCnt() {
        return this.activeConsumerCnt.get();
    }

    public void setDataConsumer(BiConsumer<Integer, IAsyncStreamDataBlock<E>> dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    public int getPipeStatus() {
        return this.pipeStatus.get();
    }

    public int getWaitingDataBlockCnt() {
        return this.waitingDataBlockCnt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDataBlockCnt(int waitForMaxValue) {
        while (this.waitingDataBlockCnt.get() > waitForMaxValue) {
            try {
                ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> concurrentLinkedQueue = this.dataQueue;
                synchronized (concurrentLinkedQueue) {
                    this.dataQueue.wait(500L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompleted() {
        while (this.waitingDataBlockCnt.get() > 0) {
            try {
                ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> concurrentLinkedQueue = this.dataQueue;
                synchronized (concurrentLinkedQueue) {
                    this.dataQueue.wait(500L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class PipeConsumerTask
    implements Callable<Integer> {
        final int consumerIndex;
        final BiConsumer<Integer, IAsyncStreamDataBlock<E>> consumer;

        public PipeConsumerTask(int consumerIndex, BiConsumer<Integer, IAsyncStreamDataBlock<E>> consumer) {
            this.consumerIndex = consumerIndex;
            this.consumer = consumer;
        }

        @Override
        public Integer call() throws Exception {
            return AsyncStreamPipe.this.doDataConsume(this.consumerIndex, this.consumer);
        }
    }
}

