/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Function;

public class IterableInputStream<T>
extends InputStream {
    public static final int EOF = -1;
    private final Iterator<T> iterator;
    private final Function<T, byte[]> mapper;
    private InputStream _currentInputStream;
    private static final InputStream EOF_IS = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };

    public IterableInputStream(Iterable<T> iterable, Function<T, byte[]> mapper) {
        this.iterator = iterable.iterator();
        this.mapper = mapper;
        this.next();
    }

    @Override
    public int read() throws IOException {
        int n = this._currentInputStream.read();
        while (n == -1 && this._currentInputStream != EOF_IS) {
            this.next();
            n = this._currentInputStream.read();
        }
        return n;
    }

    private void next() {
        this._currentInputStream = this.iterator.hasNext() ? new ByteArrayInputStream(this.mapper.apply(this.iterator.next())) : EOF_IS;
    }
}

