/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.timemeter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;

public class TimeCostMeter {
    private BiConsumer<String, Object[]> defaultLogOutput;
    private boolean enableSystemOut;
    private Map<String, Integer> meterNameIndex;
    private List<Long> timeValues;
    private String fixLogPrefix;
    private List<BiConsumer<String, Object[]>> meterOutput;

    public TimeCostMeter(boolean enableSystemOut, int initSize, Long startTime) {
        if (initSize <= 0) {
            initSize = 1;
        }
        this.meterNameIndex = new HashMap<String, Integer>(initSize);
        this.timeValues = new ArrayList<Long>(initSize);
        for (int i = 0; i < initSize; ++i) {
            this.timeValues.add(startTime);
        }
        this.meterOutput = new ArrayList<BiConsumer<String, Object[]>>(1);
        this.enableSystemOut = enableSystemOut;
    }

    public TimeCostMeter(int initSize, Long startTime) {
        this(TimeCostMeter.__isDefaultEnabledSystemOutput(), initSize, startTime);
    }

    public TimeCostMeter(int initSize) {
        this(TimeCostMeter.__isDefaultEnabledSystemOutput(), initSize, System.currentTimeMillis());
    }

    public static TimeCostMeter create(boolean enableSystemOut, int initSize, Long startTime, BiConsumer<String, Object[]> logOutput) {
        TimeCostMeter timeCostMeter = new TimeCostMeter(enableSystemOut, initSize, startTime);
        timeCostMeter.addLogOutput(logOutput);
        return timeCostMeter;
    }

    public static TimeCostMeter create(boolean enableSystemOut, int initSize, BiConsumer<String, Object[]> logOutput) {
        return TimeCostMeter.create(enableSystemOut, initSize, System.currentTimeMillis(), logOutput);
    }

    public static TimeCostMeter create(boolean enableSystemOut, Long startTime, BiConsumer<String, Object[]> logOutput, String ... initialMeters) {
        TimeCostMeter timeCostMeter;
        if (initialMeters != null && initialMeters.length > 0) {
            timeCostMeter = new TimeCostMeter(enableSystemOut, initialMeters.length, startTime);
            for (String meter : initialMeters) {
                timeCostMeter.addTimeMeters(meter, startTime);
            }
        } else {
            timeCostMeter = new TimeCostMeter(enableSystemOut, 1, startTime);
        }
        if (logOutput != null) {
            timeCostMeter.addLogOutput(logOutput);
        }
        return timeCostMeter;
    }

    public static TimeCostMeter create(boolean enableSystemOut, BiConsumer<String, Object[]> logOutput, String ... initialMeters) {
        return TimeCostMeter.create(enableSystemOut, System.currentTimeMillis(), logOutput, initialMeters);
    }

    public static TimeCostMeter create(BiConsumer<String, Object[]> logOutput, String ... initialMeters) {
        return TimeCostMeter.create(TimeCostMeter.__isDefaultEnabledSystemOutput(), System.currentTimeMillis(), logOutput, initialMeters);
    }

    public static TimeCostMeter create(BiConsumer<String, Object[]> logOutput, int meterCnt) {
        TimeCostMeter timeCostMeter = new TimeCostMeter(TimeCostMeter.__isDefaultEnabledSystemOutput(), meterCnt, System.currentTimeMillis());
        timeCostMeter.addLogOutput(logOutput);
        return timeCostMeter;
    }

    public static TimeCostMeter create(boolean enableSystemOut, String ... initialMeters) {
        return TimeCostMeter.create(enableSystemOut, System.currentTimeMillis(), null, initialMeters);
    }

    public static boolean __isDefaultEnabledSystemOutput() {
        return OptimizeControlPanel.debug_isDefaultEnabledSystemOutput();
    }

    public TimeCostMeter reset() {
        long time = System.currentTimeMillis();
        for (int i = 0; i < this.timeValues.size(); ++i) {
            this.timeValues.set(i, time);
        }
        return this;
    }

    public TimeCostMeter clear() {
        this.meterNameIndex.clear();
        this.timeValues.clear();
        this.fixLogPrefix = null;
        return this;
    }

    public int getLastTimeValueIndex() {
        return this.timeValues == null || this.timeValues.isEmpty() ? -1 : this.timeValues.size() - 1;
    }

    public int addTimeMeters(String meterName, long startTime) {
        if (this.meterNameIndex.containsKey(meterName)) {
            throw new IllegalArgumentException("Duplicate Meter Name: " + meterName);
        }
        int indexResult = this.meterNameIndex.size();
        this.meterNameIndex.put(meterName, indexResult);
        this.timeValues.add(startTime);
        return indexResult;
    }

    public int addTimeMeters(String meterName) {
        return this.addTimeMeters(meterName, System.currentTimeMillis());
    }

    public int[] addTimeMeters(String meterNamePrefx, int meterCnt) {
        long startTime = System.currentTimeMillis();
        int[] indexResult = new int[2];
        for (int i = 1; i <= meterCnt; ++i) {
            indexResult[i == 1 ? 0 : 1] = this.addTimeMeters(meterNamePrefx + i, startTime);
        }
        return indexResult;
    }

    public int[] addTimeMeters(String ... meterName) {
        if (meterName == null || meterName.length <= 0) {
            throw new IllegalArgumentException("Time Meter Name Cannot be null!");
        }
        long time = System.currentTimeMillis();
        int[] result = new int[meterName.length];
        int i = 0;
        for (String n : meterName) {
            result[i++] = this.addTimeMeters(n, time);
        }
        return result;
    }

    public Long setMeterTimeValue(String meterName, long newTimeValue) {
        Integer index = this.meterNameIndex.get(meterName);
        Long oldValue = null;
        if (index != null) {
            oldValue = this.timeValues.get(index);
            this.timeValues.set(index, newTimeValue);
        }
        return oldValue;
    }

    public Long setMeterTimeValue(int meterIndex, long newTimeValue) {
        Long oldValue = null;
        if (meterIndex >= 0 && meterIndex < this.timeValues.size()) {
            oldValue = this.timeValues.get(meterIndex);
            this.timeValues.set(meterIndex, newTimeValue);
        }
        return oldValue;
    }

    public TimeCostMeter copy() {
        TimeCostMeter result = new TimeCostMeter(this.meterNameIndex.size());
        result.meterNameIndex.putAll(this.meterNameIndex);
        result.timeValues.addAll(this.timeValues);
        return result;
    }

    public Integer getMeterIndex(String meterName) {
        return this.meterNameIndex.get(meterName);
    }

    public int getMeterIndexAndResetTime(String meterName) {
        Integer meterIndex = this.meterNameIndex.get(meterName);
        if (meterIndex == null) {
            return this.addTimeMeters(meterName);
        }
        this.timeValues.set(meterIndex, System.currentTimeMillis());
        return meterIndex;
    }

    public int[] getMeterIndexAndResetTime(String ... meterNames) {
        if (meterNames == null || meterNames.length <= 0) {
            return new int[0];
        }
        int i = 0;
        int[] indexes = new int[meterNames.length];
        for (String name : meterNames) {
            indexes[i++] = this.getMeterIndexAndResetTime(name);
        }
        return indexes;
    }

    public long getAndReset(String meterName) {
        long newTime = System.currentTimeMillis();
        Long oldTime = this.setMeterTimeValue(meterName, newTime);
        return oldTime != null ? newTime - oldTime : -1L;
    }

    public long getAndReset(int meterIndex) {
        long newTime = System.currentTimeMillis();
        Long oldTime = this.setMeterTimeValue(meterIndex, newTime);
        return oldTime != null ? newTime - oldTime : -1L;
    }

    public long getTimeCost(String meterName) {
        Long oldTime = this.timeValues.get(this.meterNameIndex.get(meterName));
        return oldTime != null ? System.currentTimeMillis() - oldTime : -1L;
    }

    public long getTimeCost(int meterIndex) {
        Long oldTime = this.timeValues.get(meterIndex);
        return oldTime != null ? System.currentTimeMillis() - oldTime : -1L;
    }

    public long resetMeter(int ... meterIndex) {
        if (meterIndex == null) {
            return -1L;
        }
        long newTime = System.currentTimeMillis();
        for (int i : meterIndex) {
            this.setMeterTimeValue(i, newTime);
        }
        return newTime;
    }

    public int addLogOutput(String messagePrefix, BiConsumer<String, Object[]> logOutput) {
        if (logOutput == null) {
            return -1;
        }
        int index = this.meterOutput.size();
        this.meterOutput.add(logOutput);
        return index;
    }

    public int addLogOutput(BiConsumer<String, Object[]> logOutput) {
        return this.addLogOutput(null, logOutput);
    }

    public boolean isEnableSystemOut() {
        return this.enableSystemOut;
    }

    public TimeCostMeter setEnableSystemOut(boolean enableSystemOut) {
        this.enableSystemOut = enableSystemOut;
        return this;
    }

    public void setFixLogPrefix(String messagePrefix) {
        this.fixLogPrefix = messagePrefix;
    }

    public void outputTimeLog(int[] outputChannels, String messageTemplate, Object ... params) {
        String msgTemplate;
        String string = msgTemplate = this.fixLogPrefix != null ? this.fixLogPrefix + messageTemplate : messageTemplate;
        if (outputChannels == null) {
            for (BiConsumer<String, Object[]> out : this.meterOutput) {
                try {
                    out.accept(msgTemplate, params);
                }
                catch (Exception ex) {
                    this.defaultLogOutput.accept(ex.getMessage(), new Object[]{ex});
                }
            }
        } else {
            for (int channel : outputChannels) {
                try {
                    this.meterOutput.get(channel).accept(msgTemplate, params);
                }
                catch (Exception ex) {
                    this.defaultLogOutput.accept(ex.getMessage(), new Object[]{ex});
                }
            }
        }
        if (this.enableSystemOut) {
            System.out.println(String.format(messageTemplate.replace("{}", "%s"), params));
        }
    }

    public void outputTimeLog(String messageTemplate, Object ... params) {
        this.outputTimeLog(null, messageTemplate, params);
    }

    public BiConsumer<String, Object[]> getDefaultLogOutput() {
        return this.defaultLogOutput;
    }

    public void setDefaultLogOutput(BiConsumer<String, Object[]> defaultLogOutput) {
        this.defaultLogOutput = defaultLogOutput;
    }
}

