/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.xdb;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.mservice.ShardingMetadataService;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIterator;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIteratorBuilder;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;

public class FIXDBShardingHelper {
    public static final int Default_GL_Slice_Org_Mod = 6;

    public static boolean isTableEnabledSharding(String tableName) {
        return DB.isSharded((String)tableName);
    }

    public static String[] getShardingFields(String tableName) {
        if (FIXDBShardingHelper.isTableEnabledSharding(tableName)) {
            return XDBConfig.getShardingConfigProvider().getConfig(tableName).getShardingFields();
        }
        return null;
    }

    public static Map<String, String> parsePropFields(DataEntityPropertyCollection entityProperties, Set<String> filterFields) {
        if (entityProperties == null || entityProperties.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(filterFields != null ? filterFields.size() : entityProperties.size());
        for (IDataEntityProperty property : entityProperties) {
            if (property.getAlias() == null || property.getDisplayName() == null || filterFields != null && !filterFields.contains(property.getName().toLowerCase()) && !filterFields.contains(property.getAlias().toLowerCase())) continue;
            resultMap.put(property.getAlias().toLowerCase(), property.getName().toLowerCase());
        }
        return resultMap;
    }

    public static Map<String, String> parsePropFields(MainEntityType entityType, Set<String> filterFields) {
        if (entityType == null) {
            return Collections.EMPTY_MAP;
        }
        return FIXDBShardingHelper.parsePropFields(entityType.getProperties(), filterFields);
    }

    public static Map<String, String> getShardingFieldLookupMap(DataEntityPropertyCollection entityProperties) {
        String[] shardingFields = FIXDBShardingHelper.getShardingFields(entityProperties.getParent().getAlias().toLowerCase());
        if (shardingFields == null) {
            return Collections.EMPTY_MAP;
        }
        HashSet<String> filterFields = new HashSet<String>(shardingFields.length);
        filterFields.addAll(Arrays.asList(shardingFields));
        return FIXDBShardingHelper.parsePropFields(entityProperties, filterFields);
    }

    public static Map<String, String> getShardingFieldLookupMap(MainEntityType entityType) {
        return FIXDBShardingHelper.getShardingFieldLookupMap(entityType.getProperties());
    }

    public static Map<String, Object> getShardingParamMap(DynamicObject srcValueObject) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        IDataEntityType entityType = srcValueObject.getDataEntityType();
        if (entityType != null) {
            DataEntityPropertyCollection entityProperties = entityType.getProperties();
            Map<String, String> shardingFields = FIXDBShardingHelper.getShardingFieldLookupMap(entityProperties);
            for (String field : shardingFields.values()) {
                Object fieldValueBuf = ((IDataEntityProperty)entityProperties.get((Object)field)).getValueFast((Object)srcValueObject);
                if (fieldValueBuf instanceof Collection) {
                    resultMap.put(field + "$in", fieldValueBuf);
                    continue;
                }
                if (fieldValueBuf == null) continue;
                resultMap.put(field + "$=", fieldValueBuf);
            }
        }
        return resultMap;
    }

    public static String getGLOrgPeriodShardingTableName(long orgId, long periodId) {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("org$=", orgId);
        params.put("period$=", periodId);
        List tableNames = ShardingMetadataService.getInstance().getShardingTableName("gl_voucher", params);
        return tableNames == null ? null : (String)tableNames.get(0);
    }

    public static Map<String, Map<String, Set<Object>>> calcShardingQueryParamGroups(String targetEntityName, Map<String, Set<Object>> shardingQueryParams) {
        LinkedHashMap<String, Map<String, Set<Object>>> resultMap = new LinkedHashMap<String, Map<String, Set<Object>>>();
        IntArraySequenceIteratorBuilder iteratorBuilder = new IntArraySequenceIteratorBuilder();
        int shardingFieldCnt = shardingQueryParams.size();
        String[] fieldNames = new String[shardingFieldCnt];
        int fieldIndex = 0;
        for (Map.Entry<String, Set<Object>> en : shardingQueryParams.entrySet()) {
            fieldNames[fieldIndex++] = en.getKey();
            iteratorBuilder.addArrayValue(en.getValue().toArray(new Object[0]));
        }
        IntArraySequenceIterator grpIterator = iteratorBuilder.build();
        HashMap<String, Object> params = new HashMap<String, Object>(shardingFieldCnt);
        while (grpIterator.hasNext()) {
            int i;
            params.clear();
            Object[] currentGrpValues = grpIterator.next();
            for (i = 0; i < shardingFieldCnt; ++i) {
                params.put(fieldNames[i] + "$=", currentGrpValues[i]);
            }
            List shardingTableName = ShardingMetadataService.getInstance().getShardingTableName(targetEntityName, params);
            if (shardingTableName == null || shardingTableName.isEmpty()) continue;
            Map shardingGrpBuf = resultMap.computeIfAbsent((String)shardingTableName.get(0), (Function<String, Map<String, Set<Object>>>)((Function<String, Map>)v -> {
                HashMap result = new HashMap(shardingFieldCnt);
                for (int i = 0; i < shardingFieldCnt; ++i) {
                    result.put(fieldNames[i], new HashSet(8));
                }
                return result;
            }));
            for (i = 0; i < shardingFieldCnt; ++i) {
                ((Set)shardingGrpBuf.get(fieldNames[i])).add(currentGrpValues[i]);
            }
        }
        return resultMap;
    }

    public static int parseSliceIndex(String shardingTableName) {
        String index;
        int startIndex;
        for (startIndex = shardingTableName.length() - 1; startIndex >= 0 && shardingTableName.charAt(startIndex) != '$'; --startIndex) {
        }
        if (startIndex > 1 && (index = shardingTableName.substring(startIndex + 1)) != null && !"".equals(index.trim())) {
            try {
                return Integer.parseInt(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static void main(String[] args) {
    }

    public static String updateGLQuerySQL(long orgId, long periodId, String srcSql) {
        if (srcSql == null) {
            return srcSql;
        }
        String sqlCheckBuf = srcSql.toLowerCase();
        if (!sqlCheckBuf.contains("gl_voucher") || !FIXDBShardingHelper.isTableEnabledSharding("t_gl_voucher")) {
            return srcSql;
        }
        String shardingTableName = FIXDBShardingHelper.getGLOrgPeriodShardingTableName(orgId, periodId);
        if (shardingTableName == null || "".equals(shardingTableName)) {
            return null;
        }
        shardingTableName = shardingTableName.toLowerCase();
        srcSql = IDataValueUtil.replaceIgnoreCase(srcSql, "t_gl_voucherentry", shardingTableName.replace("t_gl_voucher", "t_gl_voucherentry"));
        srcSql = IDataValueUtil.replaceIgnoreCase(srcSql, "t_gl_voucher", shardingTableName);
        return srcSql;
    }

    public static Map<String, Set<Object>> parseShardingValue(Map<String, String> shardingFieldNameMap, QFilterBuilder filterBuilder) {
        if (shardingFieldNameMap == null || shardingFieldNameMap.isEmpty() || filterBuilder == null || filterBuilder.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        int shardingFieldCnt = shardingFieldNameMap.size();
        HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>(shardingFieldCnt);
        int valueCacheIndex = 0;
        for (String n : shardingFieldNameMap.keySet()) {
            fieldIndexMap.put(n, valueCacheIndex++);
        }
        valueCacheIndex = 0;
        for (String n : shardingFieldNameMap.values()) {
            fieldIndexMap.put(n, valueCacheIndex++);
        }
        Set[] shardingFieldValueArray = new HashSet[shardingFieldCnt];
        for (int i = 0; i < shardingFieldCnt; ++i) {
            shardingFieldValueArray[i] = new HashSet(8);
        }
        Set keys = fieldIndexMap.keySet();
        Set<String> keyIds = keys.stream().map(x -> x + ".id").collect(Collectors.toSet());
        keyIds.addAll(keys);
        filterBuilder.collectFilterInfos((filter, index) -> {
            Integer f_index;
            if (filter.getValue() == null) {
                return;
            }
            String property = filter.getProperty();
            if (filter.getProperty().endsWith(".id")) {
                property = property.replace(".id", "");
            }
            if ((f_index = (Integer)fieldIndexMap.get(property)) != null) {
                if (filter.getValue() instanceof Collections) {
                    shardingFieldValueArray[f_index].addAll((Collection)filter.getValue());
                } else {
                    shardingFieldValueArray[f_index].add(filter.getValue());
                }
            }
        }, keyIds.toArray(new String[0]));
        String[] shardingFieldNames = shardingFieldNameMap.keySet().toArray(new String[0]);
        LinkedHashMap<String, Set<Object>> resultMap = new LinkedHashMap<String, Set<Object>>(shardingFieldCnt);
        for (int i = 0; i < shardingFieldCnt; ++i) {
            if (shardingFieldValueArray[i].isEmpty()) continue;
            resultMap.put(shardingFieldNames[i], shardingFieldValueArray[i]);
        }
        return resultMap;
    }

    public static Map<String, Set<Object>> parseShardingValue(IDataEntityType entityType, QFilterBuilder filterBuilder) {
        if (entityType == null) {
            return Collections.emptyMap();
        }
        String tableName = entityType.getAlias();
        if (!FIXDBShardingHelper.isTableEnabledSharding(tableName) || filterBuilder == null || filterBuilder.isEmpty()) {
            return Collections.emptyMap();
        }
        return FIXDBShardingHelper.parseShardingValue(FIXDBShardingHelper.parsePropFields(entityType.getProperties(), new HashSet<String>(Arrays.asList(FIXDBShardingHelper.getShardingFields(tableName)))), filterBuilder);
    }

    public static Map<String, List<HintCondition>> buildShardingHintConditions(Map<String, Map<String, Set<Object>>> shardingFieldValueMap) {
        if (shardingFieldValueMap == null || shardingFieldValueMap.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<HintCondition>> resultMap = new LinkedHashMap<String, List<HintCondition>>();
        shardingFieldValueMap.forEach((k, v) -> resultMap.put((String)k, FIXDBShardingHelper.buildSingleSliceHintConditions(v)));
        return resultMap;
    }

    public static List<HintCondition> buildSingleSliceHintConditions(Map<String, Set<Object>> shardingFieldValueMap) {
        if (shardingFieldValueMap == null || shardingFieldValueMap.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<HintCondition> shardingHintConditions = new LinkedList<HintCondition>();
        for (Map.Entry<String, Set<Object>> en : shardingFieldValueMap.entrySet()) {
            if (en == null || en.getKey() == null || en.getValue().isEmpty()) continue;
            shardingHintConditions.add(new HintCondition(en.getKey(), FilterType.in_range, en.getValue()));
        }
        return shardingHintConditions;
    }

    public static <T> T doSharingTableOperation(String entityName, QFilterBuilder filterBuilder, BiFunction<ShardingHintContext, List<HintCondition>, T> processFunc) {
        Map<String, Set<Object>> shardingFieldValueMap;
        List<HintCondition> hintConditions;
        if (!OptimizeControlPanel.isXDBAutoOptimizeEnabled()) {
            return processFunc.apply(null, null);
        }
        if (entityName == null) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (filterBuilder != null && filterBuilder.isEmpty()) {
            filterBuilder.pack(null);
        }
        if ((hintConditions = FIXDBShardingHelper.buildSingleSliceHintConditions(shardingFieldValueMap = FIXDBShardingHelper.parseShardingValue((IDataEntityType)entityType, filterBuilder))).isEmpty()) {
            return processFunc.apply(null, null);
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)entityType.getAlias(), (HintCondition[])hintConditions.toArray(new HintCondition[0]));){
            T t = processFunc.apply(ctx, hintConditions);
            return t;
        }
    }

    public static <T> T doSharingTableOperation(QueryBuilder queryBuilder, BiFunction<ShardingHintContext, List<HintCondition>, T> processFunc) {
        return FIXDBShardingHelper.doSharingTableOperation(queryBuilder.getEntityName(), QFilterBuilder.create(queryBuilder.getFilters()), processFunc);
    }
}

