/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.vo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.fi.bd.model.schema.basedata.AccountTableSchema;

public class CommonAssist {
    public final String key;
    public final int seq;
    public final String number;
    public final String name;
    public final String valueSourceType;
    public final String valueSource;
    public final Long assistType;
    public final boolean isBalanced;
    public final boolean isRequired;
    private static final String ASSISTANT_TYPE = "2";
    public static final String PREFIX_COMASSIST = "comassist";

    public String getKey() {
        return this.key;
    }

    public int getSeq() {
        return this.seq;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getValueSourceType() {
        return this.valueSourceType;
    }

    public String getValueSource() {
        return this.valueSource;
    }

    public Long getAssistType() {
        return this.assistType;
    }

    public boolean isBalanced() {
        return this.isBalanced;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public CommonAssist(String key, int seq, String number, String name, String valueSourceType, String valueSource, Long assistType, boolean isBalanced, boolean isRequired) {
        this.key = key;
        this.seq = seq;
        this.number = number;
        this.name = name;
        this.valueSourceType = valueSourceType;
        this.valueSource = valueSource;
        this.assistType = assistType;
        this.isBalanced = isBalanced;
        this.isRequired = isRequired;
    }

    public static List<CommonAssist> createComAssist(DynamicObjectCollection entry) {
        AccountTableSchema acctTableSchema = AccountTableSchema.instance;
        ArrayList<CommonAssist> assists = new ArrayList<CommonAssist>(entry.size());
        int i = 1;
        for (DynamicObject row : entry) {
            String valueSourceType = row.getString(acctTableSchema.valueSourceType.toString());
            String valueSource = ASSISTANT_TYPE.equals(valueSourceType) ? "bos_assistantdata_detail" : row.getString(acctTableSchema.valueSource.toString() + ".id");
            assists.add(new CommonAssist(PREFIX_COMASSIST + i, i++, row.getString(acctTableSchema.comAssistNumber.toString()), row.getString(acctTableSchema.comAssistName.toString()), valueSourceType, valueSource, row.getLong(acctTableSchema.assistantValueSource.toString() + ".id"), row.getBoolean(acctTableSchema.isBalanced.toString()), row.getBoolean(acctTableSchema.isRequired.toString())));
        }
        return assists;
    }

    public LocaleString getLocaleName() {
        return new LocaleString(this.name);
    }

    public boolean isAssistantSource() {
        return ASSISTANT_TYPE.equals(this.valueSourceType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonAssist that = (CommonAssist)o;
        return this.seq == that.seq && this.isBalanced == that.isBalanced && this.isRequired == that.isRequired && Objects.equals(this.key, that.key) && Objects.equals(this.number, that.number) && Objects.equals(this.name, that.name) && Objects.equals(this.valueSourceType, that.valueSourceType) && Objects.equals(this.valueSource, that.valueSource) && Objects.equals(this.assistType, that.assistType);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.seq, this.number, this.name, this.valueSourceType, this.valueSource, this.assistType, this.isBalanced, this.isRequired);
    }
}

