/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.vo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OrgAccOwnershipVO {
    private long orgId;
    private Map<String, AccInfo> accInfos = new HashMap<String, AccInfo>(2);

    public OrgAccOwnershipVO(long orgId) {
        this.orgId = orgId;
    }

    public AccInfo getOrNewAccInfo(String accNumber) {
        this.accInfos.computeIfAbsent(accNumber, number -> new AccInfo((String)number));
        return this.accInfos.get(accNumber);
    }

    public OrgAccOwnershipVO(long orgId, Map<String, AccInfo> accInfos) {
        this.orgId = orgId;
        this.accInfos = accInfos;
    }

    public Set<String> getAllAccNums() {
        return this.accInfos.keySet();
    }

    public Map<String, Long> getNumberLatestAccId() {
        return this.accInfos.entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> ((AccInfo)x.getValue()).getLatestVersionId()));
    }

    public Set<Long> getLatestAccIds() {
        return this.accInfos.values().stream().map(AccInfo::getLatestVersionId).collect(Collectors.toSet());
    }

    public Set<Long> getAllAccIds() {
        return this.accInfos.values().stream().flatMap(x -> x.getVersionIds().stream()).collect(Collectors.toSet());
    }

    public String getLogStr() {
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append(this.orgId);
        logBuilder.append("[");
        logBuilder.append(this.getNumberLatestAccId().toString());
        logBuilder.append("]");
        return logBuilder.toString();
    }

    public static class AccInfo {
        private String number;
        private long latestVersionId;
        private Set<Long> versionIds = new HashSet<Long>(2);

        public AccInfo(String number) {
            this.number = number;
        }

        public AccInfo(String number, long latestVersionId) {
            this.number = number;
            this.latestVersionId = latestVersionId;
            this.versionIds.add(this.latestVersionId);
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public long getLatestVersionId() {
            return this.latestVersionId;
        }

        public void setLatestVersionId(long latestVersionId) {
            this.latestVersionId = latestVersionId;
            this.versionIds.add(latestVersionId);
        }

        public Set<Long> getVersionIds() {
            return this.versionIds;
        }

        public void setVersionIds(Set<Long> versionIds) {
            this.versionIds = versionIds;
        }
    }
}

