/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.vo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OrgCfitemOwnershipVO {
    private long orgId;
    private Map<String, CfItemInfo> cfInfos = new HashMap<String, CfItemInfo>(2);

    public OrgCfitemOwnershipVO(long orgId) {
        this.orgId = orgId;
    }

    public CfItemInfo getOrNewCfInfo(String cfNumber) {
        this.cfInfos.computeIfAbsent(cfNumber, number -> new CfItemInfo((String)number));
        return this.cfInfos.get(cfNumber);
    }

    public OrgCfitemOwnershipVO(long orgId, Map<String, CfItemInfo> cfInfos) {
        this.orgId = orgId;
        this.cfInfos = cfInfos;
    }

    public Set<String> getAllCfNums() {
        return this.cfInfos.keySet();
    }

    public Map<String, Long> getNumberLatestCfId() {
        return this.cfInfos.entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> ((CfItemInfo)x.getValue()).getLatestVersionId()));
    }

    public Set<Long> getLatestCfIds() {
        return this.cfInfos.values().stream().map(CfItemInfo::getLatestVersionId).collect(Collectors.toSet());
    }

    public Set<Long> getAllCfIds() {
        return this.cfInfos.values().stream().flatMap(x -> x.getVersionIds().stream()).collect(Collectors.toSet());
    }

    public String getLogStr() {
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append(this.orgId);
        logBuilder.append("[");
        logBuilder.append(this.getNumberLatestCfId().toString());
        logBuilder.append("]");
        return logBuilder.toString();
    }

    public static class CfItemInfo {
        private String number;
        private long latestVersionId;
        private Set<Long> versionIds = new HashSet<Long>(2);

        public CfItemInfo(String number) {
            this.number = number;
        }

        public CfItemInfo(String number, long latestVersionId) {
            this.number = number;
            this.latestVersionId = latestVersionId;
            this.versionIds.add(this.latestVersionId);
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public long getLatestVersionId() {
            return this.latestVersionId;
        }

        public void setLatestVersionId(long latestVersionId) {
            this.latestVersionId = latestVersionId;
            this.versionIds.add(latestVersionId);
        }

        public Set<Long> getVersionIds() {
            return this.versionIds;
        }

        public void setVersionIds(Set<Long> versionIds) {
            this.versionIds = versionIds;
        }
    }
}

