/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;

public class AbstractCalRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private final String mulCostAcctField = this.getKeyFieldMap().get("mulcostaccountfilter");
    private final String mulCalOrgField = this.getKeyFieldMap().get("mulcalorgfilter");
    public final String startPeriodField = this.getKeyFieldMap().get("startperiodfilter");
    private final String endPeriodField = this.getKeyFieldMap().get("endperiodfilter");

    public final Map<String, String> getKeyFieldMap() {
        HashMap<String, String> keyFieldMap = new HashMap<String, String>(16);
        keyFieldMap.put("mulcostaccountfilter", "mulcostaccountfilter");
        keyFieldMap.put("mulcalorgfilter", "mulcalorgfilter");
        keyFieldMap.put("startperiodfilter", "startperiodfilter");
        keyFieldMap.put("endperiodfilter", "endperiodfilter");
        return keyFieldMap;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefault();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.mulCostAcctField.equals(key)) {
            this.costAcctChange();
        } else if (this.startPeriodField.equals(key)) {
            this.startPeriodChanged();
        } else if (this.endPeriodField.equals(key)) {
            this.endPeriodChanged();
        } else if (this.mulCalOrgField.equals(key)) {
            this.calOrgChanged();
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        return this.verifyBeforeQuery();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, this.mulCalOrgField, this.mulCostAcctField, this.startPeriodField, this.endPeriodField);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (this.mulCalOrgField.equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if (this.mulCostAcctField.equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if (this.startPeriodField.equals(key) || this.endPeriodField.equals(key)) {
            this.beforeF7Select4Period(e);
        }
    }

    public String getCheckPermissionEntity() {
        String entityName = this.getModel().getDataEntityType().getName();
        return entityName;
    }

    private void setDefault() {
        String entityName;
        Long userOrgId;
        Long userId = RequestContext.get().getCurrUserId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)(userOrgId = Long.valueOf(RequestContext.get().getOrgId())), (String)(entityName = this.getCheckPermissionEntity()));
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue(this.mulCalOrgField, (Object)new Object[]{calOrgId});
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)userOrgId);
            if (costAccount != null) {
                long costAcctId = costAccount.getLong("id");
                this.getModel().setValue(this.mulCostAcctField, (Object)new Object[]{costAcctId});
            }
            this.costAcctChange();
        }
    }

    private boolean verifyBeforeQuery() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection(this.mulCalOrgField);
        DynamicObjectCollection costaccountList = dataEntity.getDynamicObjectCollection(this.mulCostAcctField);
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue(this.startPeriodField);
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue(this.endPeriodField);
        if (calOrgList == null || calOrgList.size() == 0 || costaccountList == null || costaccountList.size() == 0 || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype,calpolicy.currency,calpolicy.currency.amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9", (String)"AbstractCalRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.mulCalOrgField);
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue(this.startPeriodField);
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue(this.endPeriodField);
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue(this.endPeriodField, startPeriod.getPkValue());
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue(this.startPeriodField);
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue(this.endPeriodField);
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue(this.startPeriodField, endPeriod.getPkValue());
        }
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.mulCostAcctField);
        HashSet<Long> periodIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> periodCostAccountMap = new HashMap<Long, DynamicObject>(16);
        if (costaccountList == null || costaccountList.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockGatherReportBplatForm_3", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        for (DynamicObject costaccount : costaccountList) {
            DynamicObject startPeriod = PeriodHelper.getCurrentPeriod((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (startPeriod == null) continue;
            periodIdSet.add(startPeriod.getLong("id"));
            periodCostAccountMap.put(startPeriod.getLong("id"), costaccount.getDynamicObject("fbasedataid"));
        }
        if (periodIdSet.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4", (String)"AbstractCalRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        Long periodId = (Long)Collections.min(periodIdSet);
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)((DynamicObject)periodCostAccountMap.get(periodId)));
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4", (String)"AbstractCalRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void calOrgChanged() {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.mulCalOrgField);
        if (calOrgList == null || calOrgList.size() == 0) {
            this.getModel().setValue(this.mulCostAcctField, null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue(this.mulCostAcctField, (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue(this.mulCostAcctField, null);
            }
        }
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        String entityName;
        Long userId = UserServiceHelper.getCurrentUserId();
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)(entityName = this.getCheckPermissionEntity()), (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void costAcctChange() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.mulCostAcctField);
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue(this.startPeriodField, null);
            this.getModel().setValue(this.endPeriodField, null);
        } else {
            HashSet<Long> costaccountIdSet = new HashSet<Long>();
            for (DynamicObject costaccount : costaccounts) {
                costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
            HashSet<Long> periodIds = new HashSet<Long>();
            for (Long costAccountId : costaccountIdSet) {
                DynamicObject period = (DynamicObject)periods.get(costAccountId);
                if (period == null) continue;
                periodIds.add(period.getLong("id"));
            }
            if (periodIds.isEmpty()) {
                this.getModel().setValue(this.startPeriodField, null);
                this.getModel().setValue(this.endPeriodField, null);
            } else {
                Long maxid = (Long)Collections.max(periodIds);
                Long minid = (Long)Collections.min(periodIds);
                this.getModel().setValue(this.startPeriodField, (Object)(periodIds.size() == 0 ? null : minid));
                this.getModel().setValue(this.endPeriodField, (Object)(periodIds.size() == 0 ? null : maxid));
            }
        }
    }

    public String getMulCostAcctField() {
        return this.mulCostAcctField;
    }

    public String getMulCalOrgField() {
        return this.mulCalOrgField;
    }

    public String getStartPeriodField() {
        return this.startPeriodField;
    }

    public String getEndPeriodField() {
        return this.endPeriodField;
    }
}

