/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.report.formplugin.AbstractCalRptFormPlugin;

public class CalOutRptDtlRptFormPlugin
extends AbstractCalRptFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String FILTERNAME_FILTERGRID = "commonfs";
    private static final String MUL_COST_ACCOUNT_FILTER = "mulcostaccountfilter";
    private static final String ONLY_SHOW_SUB_SUM = "onlyshowsubsum";
    private static final String SHOW_SUB_SUM = "showsubsum";
    private static final String START_TIMEF_ILTER = "starttimefilter";
    private static final String END_TIME_FILTER = "endtimefilter";

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (ONLY_SHOW_SUB_SUM.equals(key)) {
            this.onlyShowSubSumChange();
        } else if (key.equals(this.getMulCostAcctField())) {
            this.costAcctChange(false);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date now = TimeServiceHelper.now();
        this.getModel().setValue(START_TIMEF_ILTER, (Object)DateUtils.getDayStartTime((Date)now));
        this.getModel().setValue(END_TIME_FILTER, (Object)DateUtils.getDayEndTime((Date)now));
        this.fillFilterGridFields();
        this.costAcctChange(false);
        this.setFilterVisible();
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_caloutrpt_dtl_rpt");
        String filterSerDycStr = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{this.getModel().getDataEntity(true)}, (DynamicObjectType)entityType);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        String filterString = SerializationUtils.toJsonString((Object)filterCondition);
        queryParam.getCustomParam().put("filterSerDycStr", filterSerDycStr);
        queryParam.getCustomParam().put("comFilter", filterString);
        this.costAcctChange(true);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean superResult = super.verifyQuery(queryParam);
        return superResult ? this.verifyBeforeQuery(queryParam) : false;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        this.billNoLink(evt);
    }

    @Override
    public String getCheckPermissionEntity() {
        return "cal_calculateoutrpt";
    }

    private boolean verifyBeforeQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date startTimeFilter = (Date)filter.getValue(START_TIMEF_ILTER);
        Date endTimeFilter = (Date)filter.getValue(END_TIME_FILTER);
        if (startTimeFilter == null || endTimeFilter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void fillFilterGridFields() {
        String entity = "cal_caloutrpt_dtl";
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)entity);
        this.getView().setEnable(Boolean.TRUE, new String[]{FILTERNAME_FILTERGRID});
        if (srcMainType == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERNAME_FILTERGRID});
            return;
        }
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)srcMainType);
        Iterator iterator = cols.iterator();
        List comFilterfieldItem = ((ComboProp)EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()).findProperty("comfilterfield")).getComboItems();
        HashSet<String> comFilterFields = new HashSet<String>(16);
        for (ValueMapItem comfilterfield : comFilterfieldItem) {
            String filterField = comfilterfield.getValue();
            comFilterFields.add(filterField);
        }
        while (iterator.hasNext()) {
            boolean filterFieldNoContains;
            Map next = (Map)iterator.next();
            String fieldName = (String)next.get("fieldName");
            boolean notShow = fieldName.contains(".") && !fieldName.contains(".number") && !fieldName.contains(".name");
            boolean bl = filterFieldNoContains = !comFilterFields.contains(fieldName.split("\\.")[0]);
            if (!notShow && !filterFieldNoContains) continue;
            iterator.remove();
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        filterGrid.setEntityNumber(srcMainType.getName());
        filterGrid.setFilterColumns(cols);
        filterGrid.SetValue(new FilterCondition());
    }

    private void billNoLink(HyperLinkClickEvent evt) {
        int rowIndex;
        String fieldName = evt.getFieldName();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex = evt.getRowIndex());
        DynamicObject entity = rowData.getDynamicObject("entity");
        if (entity == null) {
            return;
        }
        String formId = entity.getString("number");
        String billNum = "";
        BillShowParameter showParameter = new BillShowParameter();
        Long billId = 0L;
        String msg = "";
        if ("billno".equals(fieldName)) {
            String formName = EntityMetadataCache.getDataEntityType((String)formId).getDisplayName().getLocaleValue();
            billNum = rowData.getString("billno");
            QFilter qFilter = new QFilter("billno", "=", (Object)billNum);
            qFilter.and("costaccount", "=", (Object)rowData.getLong("costaccount_id"));
            DynamicObject billDyc = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])qFilter.toArray());
            if (billDyc == null) {
                msg = ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684%1$s\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"CalOutRptDtlRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
                msg = String.format(msg, formName);
                throw new KDBizException(msg);
            }
            billId = billDyc.getLong("id");
        }
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean isShowSubSum() {
        boolean isShowSubSum = false;
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection(MUL_COST_ACCOUNT_FILTER);
        if (costaccounts == null || costaccounts.isEmpty()) {
            return isShowSubSum;
        }
        for (DynamicObject acctDyc : costaccounts) {
            Long costAcctId = acctDyc.getDynamicObject("fbasedataid").getLong("id");
            Boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAcctId);
            if (!calByCostElement.booleanValue()) continue;
            isShowSubSum = true;
            break;
        }
        return isShowSubSum;
    }

    private void costAcctChange(boolean onlySetVisible) {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection(MUL_COST_ACCOUNT_FILTER);
        if (costaccounts == null || costaccounts.size() == 0) {
            if (!onlySetVisible) {
                this.getModel().setValue(SHOW_SUB_SUM, (Object)false);
            }
        } else {
            boolean showSubSum = this.isShowSubSum();
            if (!onlySetVisible) {
                this.getModel().setValue(SHOW_SUB_SUM, (Object)showSubSum);
            }
            if (!showSubSum) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ONLY_SHOW_SUB_SUM});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ONLY_SHOW_SUB_SUM});
            }
        }
    }

    private void onlyShowSubSumChange() {
        boolean onlyShowSubSum = (Boolean)this.getModel().getValue(ONLY_SHOW_SUB_SUM);
        if (onlyShowSubSum) {
            this.getModel().setValue(SHOW_SUB_SUM, (Object)true);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SHOW_SUB_SUM});
        } else {
            boolean showSubSum = this.isShowSubSum();
            this.getModel().setValue(SHOW_SUB_SUM, (Object)showSubSum);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{SHOW_SUB_SUM});
        }
    }

    private void setFilterVisible() {
        boolean isLink;
        ReportQueryParam reportQueryParam = ((ReportShowParameter)this.getView().getFormShowParameter()).getReportQueryParam();
        if (reportQueryParam == null) {
            return;
        }
        Map customParam = reportQueryParam.getCustomParam();
        boolean bl = isLink = customParam != null && customParam.containsKey("isLink");
        if (isLink) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fsap"});
        }
    }
}

