/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.formula.StandGroupBaseDataConverter;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.ReportUtil;

public class FallPriceProvRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_fallprice_provrpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            this.setCostAccountByCalOrg(calOrgId);
        }
    }

    public void afterBindData(EventObject e) {
        boolean groupsum = (Boolean)this.getModel().getValue("groupsum");
        if (groupsum) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ownernum", "ownername"});
        }
        super.afterBindData(e);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        int endPeriodNumber;
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        boolean isLack = false;
        if (calOrg == null || costAccount == null || startPeriod == null || endPeriod == null) {
            isLack = true;
        }
        if (isLack) {
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_fallprice_provrpt", (String)"47150e89000000ac", (Long)calOrg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        if (startPeriodNumber > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockEstimateDetailRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, "calorg", "costaccount", "startperiod", "endperiod", "fallpricesetting", "groupstandard", "materialgroup", "mulmaterial", "materialto");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("settingnum".equals(key)) {
                    FallPriceProvRptFormPlugin.this.hyperLinkBillNoClick(evt);
                }
            }
        });
    }

    protected void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject rowdata = evt.getRowData();
        String settingnum = rowdata.getString("settingnum");
        QFilter qFilter = new QFilter("number", "=", (Object)settingnum);
        DynamicObject fallPriceSetting = QueryServiceHelper.queryOne((String)"cal_fallprice_setting", (String)"id", (QFilter[])qFilter.toArray());
        if (fallPriceSetting != null) {
            Long settingId = fallPriceSetting.getLong("id");
            if (settingId == null || settingId == 0L) {
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)settingId);
            showParameter.setFormId("cal_fallprice_setting");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Names) {
        BasedataEdit f7 = null;
        for (String f7Name : f7Names) {
            f7 = (BasedataEdit)this.getControl(f7Name);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4CalOrg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            this.beforeF7Select4Mulmaterial(e);
        } else if ("fallpricesetting".equals(key)) {
            this.beforeF7Select4FallPriceSetting(e);
        } else if ("materialgroup".equals(key)) {
            this.beforeF7SelectMatGroup(e);
        }
    }

    private void beforeF7SelectMatGroup(BeforeF7SelectEvent e) {
        Object mgs = this.getModel().getValue("groupstandard");
        mgs = mgs == null ? Long.valueOf(730148448254487552L) : ((DynamicObject)mgs).getPkValue();
        QFilter qFilter = new QFilter("standard", "=", mgs);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.setCustomParam("groupStandard", mgs);
    }

    private void beforeF7Select4FallPriceSetting(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockEstimateDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        q = new QFilter("costaccount", "=", costAccount.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Mulmaterial(BeforeF7SelectEvent e) {
        DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("materialgroup");
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        formShowParameter.setF7ClickByFilter(true);
        formShowParameter.setShowApproved(false);
        formShowParameter.setShowUsed(false);
        if (materialGroup != null) {
            Object mgs = this.getModel().getValue("groupstandard");
            mgs = mgs == null ? Long.valueOf(730148448254487552L) : ((DynamicObject)mgs).getPkValue();
            StandGroupBaseDataConverter baseDataParser = new StandGroupBaseDataConverter("bd_materialgroupdetail", "material");
            ArrayList<Long> list = new ArrayList<Long>(8);
            list.add(materialGroup.getLong("id"));
            Set matIds = baseDataParser.getBaseDataIdsByStandGroupId((Long)mgs, list);
            QFilter matIdFilter = new QFilter("id", "in", (Object)matIds);
            formShowParameter.getListFilterParameter().setFilter(matIdFilter);
        } else {
            formShowParameter.getListFilterParameter();
        }
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockEstimateDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StockEstimateDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        q = new QFilter("calorg", "=", calOrg.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CalOrg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_fallprice_provrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.calOrgChanged();
        } else if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("materialgroup".equals(key)) {
            this.materialgroupChanged();
        } else if ("groupstandard".equals(key)) {
            this.groupStdChanged();
        }
        super.propertyChanged(e);
    }

    private void groupStdChanged() {
        this.getModel().setValue("materialgroup", null);
    }

    private void materialgroupChanged() {
        this.getModel().setValue("mulmaterial", null);
        this.getModel().setValue("materialto", null);
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void costAccountChanged() {
        this.getModel().setValue("fallpricesetting", null);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("calsystem", null);
            this.getModel().setValue("calpolicy", null);
            return;
        }
        this.getModel().setValue("calsystem", costAccount.get("calsystem"));
        this.getModel().setValue("calpolicy", costAccount.get("calpolicy"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue()).toArray());
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period == null) {
            return;
        }
        this.getModel().setValue("startperiod", (Object)period.getLong("id"));
        this.getModel().setValue("endperiod", (Object)period.getLong("id"));
    }

    private void calOrgChanged() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            this.setCostAccountByCalOrg((Long)calOrg.getPkValue());
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
        }
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg);
        if (costAccount != null) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", (Object)costAccount.getLong("calpolicy")).toArray());
            this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
            this.getModel().setValue("calsystem", costAccount.get("calsystem"));
            this.getModel().setValue("calpolicy", costAccount.get("calpolicy"));
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("startperiod", (Object)period.getLong("id"));
                this.getModel().setValue("endperiod", (Object)period.getLong("id"));
            }
            this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
        } else {
            this.getModel().setValue("costaccount", null);
        }
    }
}

