/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;

public class InvCKAccountRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final String STORAGEORG = "storageorg";
    public static final String COSTACCOUNT = "costaccount";
    public static final String WAREHOUSE = "warehouse";
    public static final String MATERIAL = "material";
    public static final String CALORGID = "calorg.id";
    public static final String ENDDATE = "enddate";
    public static final String CAL_REPORT = "fi-cal-report";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_invckaccount");
        if (calOrgId != null && calOrgId != 0L) {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue(COSTACCOUNT, (Object)costAccount.getLong("id"));
            }
            this.setStorageOrg(calOrgId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl(STORAGEORG)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(COSTACCOUNT)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(WAREHOUSE)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(MATERIAL)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (STORAGEORG.equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if (COSTACCOUNT.equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if (WAREHOUSE.equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if (MATERIAL.equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (COSTACCOUNT.equals(key)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
            if (costAccount != null) {
                this.setStorageOrg(costAccount.getLong(CALORGID));
            } else {
                this.getModel().setValue(STORAGEORG, null);
            }
        } else if (STORAGEORG.equals(key)) {
            this.getModel().setValue(WAREHOUSE, null);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        Date endDate = (Date)this.getModel().getValue(ENDDATE);
        this.getModel().setValue(ENDDATE, (Object)(endDate == null ? null : DateUtils.getDayEndTime((Date)endDate)));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection storageOrg = (DynamicObjectCollection)this.getModel().getValue(STORAGEORG);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        Date endDate = (Date)this.getModel().getValue(ENDDATE);
        Boolean isInit = (Boolean)this.getModel().getValue("isinit");
        if (storageOrg == null || storageOrg.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_0", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_1", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        if (!isInit.booleanValue() && endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_3", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        DynamicObject periodDyc = ReportUtil.getYearPeriodByDate((Object)costAccount.getPkValue(), (Date)endDate);
        if (periodDyc == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"InvCKAccountRptFormPlugin_4", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        int periodDycNum = periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
        int periodNum = ReportUtil.getBeginPeriod((DynamicObject)costAccount);
        if (periodNum > periodDycNum) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u5fc5\u987b\u5728\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u4e4b\u540e\u3002", (String)"InvCKAccountRptFormPlugin_5", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (costAccount != null) {
            List storageOrgUnitByCalOrg = OrgHelper.getStorageOrgUnitByCalOrg((Long)costAccount.getLong(CALORGID));
            if (storageOrgUnitByCalOrg != null && !storageOrgUnitByCalOrg.isEmpty()) {
                QFilter filter = new QFilter("id", "in", (Object)storageOrgUnitByCalOrg.toArray());
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"InvCKAccountRptFormPlugin_2", (String)CAL_REPORT, (Object[])new Object[0]));
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List pemOrgs = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_invckaccount", (String)"47150e89000000ac");
        if (pemOrgs == null) {
            return;
        }
        QFilter filter = new QFilter("calorg", "in", (Object)pemOrgs.toArray());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    protected void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        QFilter filter = null;
        DynamicObjectCollection storageOrgDyc = (DynamicObjectCollection)this.getModel().getValue(STORAGEORG);
        if (storageOrgDyc == null || storageOrgDyc.isEmpty()) {
            filter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        } else {
            ArrayList orgIds = new ArrayList(storageOrgDyc.size());
            storageOrgDyc.forEach(item -> orgIds.add(item.get("fbasedataid_id")));
            List startWarehouseIds = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{orgIds});
            filter = new QFilter("id", "in", (Object)startWarehouseIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    private void setStorageOrg(Long calOrgId) {
        if (calOrgId == null || calOrgId == 0L) {
            return;
        }
        List storageOrgUnitByCalOrg = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
        if (storageOrgUnitByCalOrg != null && !storageOrgUnitByCalOrg.isEmpty()) {
            this.getModel().setValue(STORAGEORG, (Object)storageOrgUnitByCalOrg.toArray());
        }
    }
}

