/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;

public class InvCKCostCKCalRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String STORAGEORG = "storageorg";
    private static final String COSTACCOUNT = "costaccount";
    private static final String MATERIALFROM = "materialfrom";
    private static final String CALORGID = "calorg.id";
    private static final String COSTOBJECT = "costobject";
    private static final String CAL_REPORT = "fi-cal-report";
    private static final String BILLTYPE = "billtype";
    private static final String SHOWCOSTDATA = "showcostdata";
    private static final String STORAGEBILLNOS = "storagebillnos";
    private static final String BIZBILLNO = "bizbillno";
    private static final String CALBILLNO = "calbillno";
    private static final String COSTBILLNO = "costbillno";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_invckcostckcal");
        if (calOrgId != null && calOrgId != 0L) {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue(COSTACCOUNT, (Object)costAccount.getLong("id"));
            }
            this.setStorageOrg(calOrgId);
            if (costAccount == null) {
                return;
            }
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("calpolicy"))});
            this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("startdate", (Object)period.getDate("begindate"));
                this.getModel().setValue("enddate", (Object)period.getDate("enddate"));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl(STORAGEORG)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(COSTACCOUNT)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(COSTOBJECT)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(BILLTYPE)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(MATERIALFROM)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("materialto")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{STORAGEBILLNOS});
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (STORAGEORG.equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if (COSTACCOUNT.equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if (COSTOBJECT.equals(key)) {
            this.beforeF7SelectCostAccount(e);
        } else if (BILLTYPE.equals(key)) {
            this.beforeF7SelectBillType(e);
        } else if (MATERIALFROM.equals(key) || "materialto".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject dynamicObject;
        QFilter qFilter;
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        String billNum = "";
        BillShowParameter showParameter = new BillShowParameter();
        String formId = "";
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        Long billId = 0L;
        String msg = "";
        if (BIZBILLNO.equals(fieldName)) {
            billNum = rowData.getString(BIZBILLNO);
            formId = rowData.getDynamicObject("ebilltype").getString("number");
            msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"InvCKCostCKCalRptFormPlugin_1", (String)CAL_REPORT, (Object[])new Object[0]);
        } else if (CALBILLNO.equals(fieldName)) {
            billNum = rowData.getString(CALBILLNO);
            qFilter = new QFilter("billnumber", "=", (Object)billNum);
            qFilter.and("calbilltype", "=", (Object)rowData.getString("inouttype"));
            dynamicObject = QueryServiceHelper.queryOne((String)"cal_costrecord_subentity", (String)"id", (QFilter[])qFilter.toArray());
            formId = dynamicObject != null ? "cal_costrecord_subentity" : "cal_initbill";
            msg = ResManager.loadKDString((String)"\u6838\u7b97\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"InvCKCostCKCalRptFormPlugin_2", (String)CAL_REPORT, (Object[])new Object[0]);
        } else if (COSTBILLNO.equals(fieldName)) {
            billNum = rowData.getString(COSTBILLNO);
            formId = rowData.getDynamicObject("ebilltype").getString("number");
            formId = "im_mdc_mftmanuinbill".equals(formId) || "im_mdc_mftreturnbill".equals(formId) ? "cad_factnedoutputbill" : "sca_matalloc";
            msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"InvCKCostCKCalRptFormPlugin_1", (String)CAL_REPORT, (Object[])new Object[0]);
        }
        qFilter = new QFilter("billno", "=", (Object)billNum);
        if ("cal_costrecord_subentity".equals(formId)) {
            qFilter = new QFilter("billnumber", "=", (Object)billNum);
            long bizBillEntryId = rowData.getLong("eentryid");
            qFilter.and(new QFilter("entry.bizbillentryid", "=", (Object)bizBillEntryId));
            qFilter.and("calbilltype", "=", (Object)rowData.getString("inouttype"));
        }
        if ((dynamicObject = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])qFilter.toArray())) == null) {
            throw new KDBizException(msg);
        }
        billId = dynamicObject.getLong("id");
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (COSTACCOUNT.equals(key)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
            if (costAccount == null) {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
                return;
            }
            this.setStorageOrg(costAccount.getLong(CALORGID));
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
            this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("startdate", (Object)period.getDate("begindate"));
                this.getModel().setValue("enddate", (Object)period.getDate("enddate"));
            }
        } else if (MATERIALFROM.equals(key)) {
            this.materialChanged();
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        boolean showcostdata = (Boolean)this.getModel().getValue(SHOWCOSTDATA);
        HashSet<String> hiddenColumn = new HashSet<String>();
        if (!showcostdata) {
            hiddenColumn.add("invcostxcheck");
            hiddenColumn.add("costcalckamount");
            hiddenColumn.add("costcalckprice");
            hiddenColumn.add("costqty");
            hiddenColumn.add("costprice");
            hiddenColumn.add("costamount");
            hiddenColumn.add(COSTBILLNO);
            hiddenColumn.add("emanusbillno");
            hiddenColumn.add("ecostobject");
            hiddenColumn.add("ecostobjectname");
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        this.setNeedHiddenColumn(columns, hiddenColumn);
    }

    protected List<ReportColumn> setNeedHiddenColumn(List<AbstractReportColumn> columns, Set<String> hiddenColumn) {
        LinkedList<ReportColumn> needHiddenColumn = new LinkedList<ReportColumn>();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn column;
            if (abstractReportColumn instanceof ReportColumn) {
                column = (ReportColumn)abstractReportColumn;
                if (!hiddenColumn.contains(column.getFieldKey())) continue;
                column.setHide(true);
                needHiddenColumn.add(column);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            column = (ReportColumnGroup)abstractReportColumn;
            List groupColumns = column.getChildren();
            needHiddenColumn.addAll(this.setNeedHiddenColumn(groupColumns, hiddenColumn));
        }
        return needHiddenColumn;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection storageOrg = (DynamicObjectCollection)this.getModel().getValue(STORAGEORG);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        DynamicObjectCollection billType = (DynamicObjectCollection)this.getModel().getValue(BILLTYPE);
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        if (storageOrg == null || storageOrg.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_0", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_1", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        if (billType == null || billType.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKCostCKCalRptFormPlugin_0", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        if (startdate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u65e5\u671f\u3002", (String)"InvCKCostCKCalRptFormPlugin_3", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        if (enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ed3\u675f\u65e5\u671f\u3002", (String)"InvCKCostCKCalRptFormPlugin_4", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        if (enddate.before(startdate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"TransactionDetailRptFormPlugin_3", (String)CAL_REPORT, (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private void materialChanged() {
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getModel().getValue(MATERIALFROM);
        if (coll != null && coll.size() <= 1) {
            if (coll.size() == 1) {
                this.getModel().setValue("materialto", ((DynamicObject)coll.get(0)).getDynamicObject("fbasedataid").getPkValue());
            } else {
                this.getModel().setValue("materialto", null);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
        } else {
            this.getModel().setValue("materialto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialto"});
        }
    }

    private void beforeF7SelectCostAccount(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"InvCKAccountRptFormPlugin_2", (String)CAL_REPORT, (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("org", "=", (Object)costAccount.getLong(CALORGID));
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    private void beforeF7SelectBillType(BeforeF7SelectEvent e) {
        ((ListShowParameter)e.getFormShowParameter()).setShowApproved(false);
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (costAccount != null) {
            List storageOrgUnitByCalOrg = OrgHelper.getStorageOrgUnitByCalOrg((Long)costAccount.getLong(CALORGID));
            if (storageOrgUnitByCalOrg != null && !storageOrgUnitByCalOrg.isEmpty()) {
                QFilter filter = new QFilter("id", "in", (Object)storageOrgUnitByCalOrg.toArray());
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"InvCKAccountRptFormPlugin_2", (String)CAL_REPORT, (Object[])new Object[0]));
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List pemOrgs = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_invckcostckcal", (String)"47150e89000000ac");
        if (pemOrgs == null) {
            return;
        }
        QFilter filter = new QFilter("calorg", "in", (Object)pemOrgs.toArray());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    private void setStorageOrg(Long calOrgId) {
        if (calOrgId == null || calOrgId == 0L) {
            return;
        }
        List storageOrgUnitByCalOrg = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
        if (storageOrgUnitByCalOrg != null && !storageOrgUnitByCalOrg.isEmpty()) {
            this.getModel().setValue(STORAGEORG, (Object)storageOrgUnitByCalOrg.toArray());
        }
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && STORAGEBILLNOS.equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showStoragebillnos(key);
        }
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cal_billnos");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }
}

