/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;

public class SalesEstimateDetailRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private String queryType = "";
    private boolean isQueryByFilter = true;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_salesestimatedetairpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("mulcalorg", (Object)calOrgId);
            this.setCostAccountByCalOrg(calOrgId);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap5"});
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        int endPeriodNumber;
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("mulcalorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        String errMsg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879\uff1a%1$s\u3002", (String)"SalesEstimateDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
        boolean isLack = false;
        HashSet<String> lackFields = new HashSet<String>(4);
        if (calOrg == null) {
            lackFields.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"SalesEstimateDetailRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (costAccount == null) {
            lackFields.add(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"SalesEstimateDetailRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (startPeriod == null) {
            lackFields.add(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4", (String)"SalesEstimateDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (endPeriod == null) {
            lackFields.add(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4", (String)"SalesEstimateDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (isLack) {
            this.getView().showTipNotification(String.format(errMsg, String.join((CharSequence)", ", lackFields)));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_salesestimatedetairpt", (String)"47150e89000000ac", (Long)calOrg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        if (startPeriodNumber > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"SalesEstimateDetailRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String firstQuery = this.getPageCache().get("firstQuery");
        String currentMaterialId = null;
        String materialIds = "";
        String index = null;
        if (StringUtils.isEmpty((String)firstQuery) || this.isQueryByFilter) {
            QFilter balFilter = this.getBalFilter(queryParam);
            QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
            balFilter.and(billStatus);
            DataSet materialsDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.material.id, entry.material.number", (QFilter[])balFilter.toArray(), null).groupBy(new String[]{"entry.material.id", "entry.material.number"}).finish().orderBy(new String[]{"entry.material.number"});
            DynamicObjectCollection balCol = ORM.create().toPlainDynamicObjectCollection(materialsDataSet);
            if (balCol.size() == 0) {
                firstQuery = "false";
                currentMaterialId = String.valueOf(-1L);
                materialIds = "";
                index = "-1";
            } else {
                HashSet<String> idSet = new HashSet<String>(balCol.size());
                StringBuilder materialIdStr = new StringBuilder();
                for (DynamicObject balInfo : balCol) {
                    String id = String.valueOf(balInfo.get("entry.material.id"));
                    if (!idSet.add(id)) continue;
                    materialIdStr.append(id).append(',');
                }
                firstQuery = "false";
                currentMaterialId = String.valueOf(((DynamicObject)balCol.get(0)).getLong("entry.material.id"));
                materialIds = materialIdStr.substring(0, materialIdStr.length() - 1);
                index = "0";
            }
        } else {
            currentMaterialId = this.getPageCache().get("currentMaterialId");
            materialIds = this.getPageCache().get("materialIds");
            index = this.getPageCache().get("index");
            if (this.queryType.equals("")) {
                currentMaterialId = this.getPageCache().get("currentMaterialId");
            } else {
                String[] materialIdArray = materialIds.split(",");
                int indexInt = Integer.parseInt(index);
                if (this.queryType.equals("first")) {
                    indexInt = 0;
                } else if (this.queryType.equals("previous")) {
                    --indexInt;
                } else if (this.queryType.equals("next")) {
                    ++indexInt;
                } else if (this.queryType.equals("last")) {
                    indexInt = materialIdArray.length - 1;
                }
                currentMaterialId = materialIdArray[indexInt];
                index = String.valueOf(indexInt);
            }
        }
        if (queryParam.getFilter().getFilterItem("currentMaterialId") != null) {
            queryParam.getFilter().getFilterItem("currentMaterialId").setValue((Object)currentMaterialId);
        } else {
            queryParam.getFilter().addFilterItem("currentMaterialId", (Object)currentMaterialId);
        }
        this.getPageCache().put("currentMaterialId", currentMaterialId);
        this.getPageCache().put("firstQuery", firstQuery);
        this.getPageCache().put("index", index);
        this.getPageCache().put("materialIds", materialIds);
    }

    private QFilter getBalFilter(ReportQueryParam queryParam) {
        HashSet<Object> set;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        DynamicObject startPeriod = filterInfo.getDynamicObject("startperiod");
        DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
        DynamicObjectCollection filter_ownerFrom = null;
        String filter_ownertype = (String)filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)filter_ownertype)) {
            if ("bos_org".equals(filter_ownertype)) {
                filter_ownerFrom = filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(filter_ownertype)) {
                filter_ownerFrom = filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(filter_ownertype)) {
                filter_ownerFrom = filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        DynamicObjectCollection filter_storageOrg = filterInfo.getDynamicObjectCollection("mulstorageorg");
        Set warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)queryParam.getFilter());
        DynamicObjectCollection filter_warehouse = filterInfo.getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection filter_location = filterInfo.getDynamicObjectCollection("mullocation");
        String filter_mullot = filterInfo.getString("mullot");
        DynamicObjectCollection filter_materialFrom = filterInfo.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filterInfo.getDynamicObject("materialto");
        DynamicObjectCollection filter_customerFrom = filterInfo.getDynamicObjectCollection("mulcustomer");
        DynamicObject filter_customerTo = filterInfo.getDynamicObject("customerto");
        String filter_billno = filterInfo.getString("billno");
        DynamicObjectCollection filter_billtype = filterInfo.getDynamicObjectCollection("mulbilltype");
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        QFilter qmaterial = new QFilter("bookdate", ">=", (Object)startPeriod.getDate("begindate")).and("bookdate", "<=", (Object)endPeriod.getDate("enddate"));
        qmaterial = qmaterial.or(new QFilter("bookdate", "<", (Object)startPeriod.getDate("begindate")).and("writeoffstatus", "=", (Object)"B"));
        q.and(qmaterial);
        if (filter_mullot != null && !filter_mullot.equals("")) {
            q.and("entry.lot", "=", (Object)filter_mullot);
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)filter_ownertype, (DynamicObjectCollection)filter_ownerFrom, (String)"cal_costrecord");
        if (filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", (Object)warehsGroupSet);
        }
        if (filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("entry.material", "in", set);
            } else {
                q.and("entry.material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("entry.material.number", "<=", (Object)filter_materialTo.getString("number"));
        }
        if (filter_customerFrom != null) {
            if (filter_customerFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : filter_customerFrom) {
                    set.add(info.getPkValue());
                }
                q.and("customer", "in", set);
            } else {
                q.and("customer.number", ">=", (Object)((DynamicObject)filter_customerFrom.get(0)).getString("number"));
                if (filter_customerTo != null) {
                    q.and("customer.number", "<=", (Object)filter_customerTo.getString("number"));
                }
            }
        }
        if (filter_billno.length() >= 1) {
            q.and("billnumber", "=", (Object)filter_billno);
        }
        if (filter_billtype != null) {
            set = new HashSet();
            for (DynamicObject billtype : filter_billtype) {
                set.add(billtype.getPkValue());
            }
            q.and("bizentityobject", "in", set);
        } else {
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("outsplitebiztype");
            HashSet<Object> set2 = new HashSet<Object>();
            for (DynamicObject bizobject : bizobjects) {
                set2.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("bizentityobject", "in", set2);
        }
        return q;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap5"});
        String index = this.getPageCache().get("index");
        int indexInt = Integer.parseInt(index);
        if (indexInt == -1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_first", "bar_previous", "bar_next", "bar_last"});
        } else {
            String materialIds = this.getPageCache().get("materialIds");
            String[] materialIdArray = materialIds.split(",");
            if (indexInt == 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_first", "bar_previous"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_first", "bar_previous"});
            }
            if (indexInt == materialIdArray.length - 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_next", "bar_last"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_next", "bar_last"});
            }
        }
        IDataModel model = this.getModel();
        model.setValue("head_costaccount", model.getValue("costaccount"));
        if (String.valueOf(-1L).equals(this.getPageCache().get("currentMaterialId"))) {
            model.setValue("head_material", null);
        } else {
            model.setValue("head_material", (Object)this.getPageCache().get("currentMaterialId"));
        }
        model.setValue("head_period", (Object)(((DynamicObject)model.getValue("startperiod")).getString("name") + "-" + ((DynamicObject)model.getValue("endperiod")).getString("name")));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, "mulcalorg", "costaccount", "startperiod", "endperiod", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "mulcustomer", "customerto", "mulbilltype", "mulowner", "multracknum");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billnumber".equals(key)) {
                    SalesEstimateDetailRptFormPlugin.this.hyperLinkBillNoClick(evt);
                }
            }
        });
    }

    protected void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        String billid;
        DynamicObject costRecordRow;
        DynamicObject row = evt.getRowData();
        String billnumber = row.getString("billnumber");
        Date bookdate = row.getDate("bookdate");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("head_costaccount");
        Object costAccountId = costAccount.getPkValue();
        QFilter qFilter = new QFilter("billnumber", "=", (Object)billnumber);
        qFilter.and("costaccount", "=", costAccountId);
        qFilter.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and(billStatusf);
        qFilter.and("calbilltype", "=", (Object)"OUT");
        if (bookdate != null) {
            qFilter.and("bookdate", "=", (Object)bookdate);
        }
        if ((costRecordRow = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"id", (QFilter[])qFilter.toArray())) != null) {
            billid = String.valueOf(costRecordRow.get("id"));
            if ("0".equals(billid)) {
                return;
            }
        } else {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billid);
        showParameter.setFormId("cal_costrecord_subentity");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Names) {
        BasedataEdit f7 = null;
        for (String f7Name : f7Names) {
            f7 = (BasedataEdit)this.getControl(f7Name);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4CalOrg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel(), (String)"mulcalorg");
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulbilltype".equals(key)) {
            this.beforeF7Select4BillType(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            ReportUtil.beforeF7Select4Mulcalorgowner((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("ownerto".equals(key)) {
            ReportUtil.beforeF7Select4ownerto((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4BillType(BeforeF7SelectEvent e) {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("outsplitebiztype");
        HashSet<Object> set = new HashSet<Object>();
        for (DynamicObject bizobject : bizobjects) {
            set.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
        }
        QFilter q = new QFilter("number", "in", set);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("mulstorageorg");
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        } else if (storageOrgs != null && storageOrgs.size() > 0) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : storageOrgs) {
                Object[] warehouseIds = SCMHelper.getAllWarehouseIDs((String)info.getDynamicObject("fbasedataid").getString("number"));
                Long[] locationIds = SCMHelper.getAllLocationIDs((Object[])warehouseIds);
                if (locationIds == null) continue;
                for (Object id : warehouseIds) {
                    set.add(id);
                }
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        } else if (calOrg != null) {
            List storageOrgIds = OrgServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrg.getLong("id"), (Long)0L);
            Object[] warehouseIds = SCMHelper.getAllWarehouseIDs((Object[])storageOrgIds.toArray(new Long[0]));
            Long[] locationIds = SCMHelper.getAllLocationIDs((Object[])warehouseIds);
            q = new QFilter("id", "in", (Object)locationIds);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalesEstimateDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalesEstimateDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        List storageOrgIds = OrgServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrg.getLong("id"), (Long)0L);
        q = new QFilter("id", "in", (Object)storageOrgIds);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"SalesEstimateDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        q.and("enable", "=", (Object)Character.valueOf('1'));
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalesEstimateDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        q = new QFilter("calorg", "=", calOrg.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CalOrg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_salesestimatedetairpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.itemClick((ItemClickEvent)e);
        String key = e.getItemKey();
        this.isQueryByFilter = true;
        if ("bar_first".equals(key)) {
            this.queryType = "first";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_previous".equals(key)) {
            this.queryType = "previous";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_next".equals(key)) {
            this.queryType = "next";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_last".equals(key)) {
            this.queryType = "last";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcustomer".equals(key)) {
            this.mulCustomerChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.mulStorageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.mulWarehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void mulWarehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void mulStorageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void mulCustomerChanged() {
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getModel().getValue("mulcustomer");
        if (coll != null && coll.size() <= 1) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"customerto"});
        } else {
            this.getModel().setValue("customerto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"customerto"});
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("calsystem", null);
            this.getModel().setValue("calpolicy", null);
            return;
        }
        this.getModel().setValue("calsystem", costAccount.get("calsystem"));
        this.getModel().setValue("calpolicy", costAccount.get("calpolicy"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue()).toArray());
        if (coll == null) {
            return;
        }
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period == null) {
            return;
        }
        this.getModel().setValue("startperiod", (Object)period.getLong("id"));
        this.getModel().setValue("endperiod", (Object)period.getLong("id"));
    }

    private void calOrgChanged() {
        IDataModel model = this.getModel();
        model.setValue("mulstorageorg", null);
        model.setValue("mulowner", null);
        DynamicObject calOrg = (DynamicObject)model.getValue("mulcalorg");
        if (calOrg == null) {
            model.setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                model.setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                model.setValue("costaccount", null);
            }
            model.setValue("ownertypehead", (Object)"bos_org");
        }
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg);
        if (costAccount != null) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", (Object)costAccount.getLong("calpolicy")).toArray());
            this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
            this.getModel().setValue("calsystem", costAccount.get("calsystem"));
            this.getModel().setValue("calpolicy", costAccount.get("calpolicy"));
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("startperiod", (Object)period.getLong("id"));
                this.getModel().setValue("endperiod", (Object)period.getLong("id"));
            }
            this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
        } else {
            this.getModel().setValue("costaccount", null);
        }
    }
}

